/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ServiceContext
implements IServiceContext,
Serializable {
    private final BOSObjectType metaType;
    private final BOSObjectType boType;
    private final IMetaDataPK operationPK;
    private final IMetaDataPK uiOrFunctionPK;
    private final Object[] operationParams;
    private final Map serviceParams;
    private final Map serviceResult;
    private Object returnValue = null;
    private boolean methodReturn = false;
    private boolean batchExctue = false;
    private int executeMode = 0;

    public ServiceContext(BOSObjectType metaType, BOSObjectType boType, IMetaDataPK operationPK, Object[] operationParams) {
        this(metaType, boType, null, operationPK, operationParams);
    }

    public ServiceContext(BOSObjectType metaType, IMetaDataPK uiOrFunctionPK, IMetaDataPK operationPK, Object[] operationParams) {
        this(metaType, null, uiOrFunctionPK, operationPK, operationParams);
    }

    public ServiceContext(BOSObjectType metaType, BOSObjectType boType, IMetaDataPK uiOrFunctionPK, IMetaDataPK operationPK, Object[] operationParams) {
        this.metaType = metaType;
        this.boType = boType;
        this.operationPK = operationPK;
        this.uiOrFunctionPK = uiOrFunctionPK;
        this.operationParams = operationParams;
        this.serviceParams = new HashMap(4);
        this.serviceResult = new HashMap(4);
    }

    @Override
    public Object[] getOperationParameters() {
        return this.operationParams;
    }

    @Override
    public void setServiceParameter(String serviceName, String key, Object value) {
        this.getServicePrameters(serviceName).put(key, value);
    }

    @Override
    public Object getServiceParameter(String serviceName, String key) {
        return this.getServicePrameters(serviceName).get(key);
    }

    @Override
    public Map getServicePrameters(String serviceName) {
        HashMap params = (HashMap)this.serviceParams.get(serviceName);
        if (params != null) {
            return params;
        }
        params = new HashMap(4);
        this.serviceParams.put(serviceName, params);
        return params;
    }

    @Override
    public void setServiceResult(String serviceName, Object result) {
        this.serviceResult.put(serviceName, result);
    }

    @Override
    public Object getServiceResult(String serviceName) {
        return this.serviceResult.get(serviceName);
    }

    public Throwable getServiceException() {
        for (Map.Entry entry : this.serviceResult.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) continue;
            return (Throwable)value;
        }
        return null;
    }

    @Override
    public void setExecutionMode(int mode) {
        this.executeMode = mode;
    }

    @Override
    public int getExecutionMode() {
        return this.executeMode;
    }

    @Override
    public BOSObjectType getBoType() {
        return this.boType;
    }

    @Override
    public BOSObjectType getMetaType() {
        return this.metaType;
    }

    @Override
    public IMetaDataPK getOperationPK() {
        return this.operationPK;
    }

    @Override
    public IMetaDataPK getUiOrFunctionPK() {
        return this.uiOrFunctionPK;
    }

    @Override
    public void setExecuteMode(int i) {
        this.executeMode = i;
    }

    @Override
    public Context getContext() {
        return (Context)this.getOperationParameters()[0];
    }

    @Override
    public Object getMethodReturnValue() {
        return this.returnValue;
    }

    @Override
    public void setMethodReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public boolean isBatchExctue() {
        return this.batchExctue;
    }

    public void setBatchExctue(boolean batchExctue) {
        this.batchExctue = batchExctue;
    }

    public boolean invokeBreak() {
        return this.isMethodReturn();
    }

    public boolean isMethodReturn() {
        return this.methodReturn;
    }

    public void setMethodReturn(boolean methodReturn) {
        this.methodReturn = methodReturn;
    }
}

