/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.mutex;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.service.mutex.MutexItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashMap;

public class MutexInfo
extends AbstractMetaDataValue
implements Serializable {
    public MutexInfo() {
        this.put("items", new MutexItemCollection());
    }

    protected MutexInfo(boolean init) {
        super(init);
        this.put("items", new MutexItemCollection());
    }

    public MutexItemCollection getMutexItems() {
        Object obj = this.get("items");
        if (obj == null) {
            MutexItemCollection collection = new MutexItemCollection();
            this.put("items", collection);
            return collection;
        }
        return (MutexItemCollection)obj;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.MUTEX;
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        MutexItemCollection mutexItemCol = this.getMutexItems();
        int length = mutexItemCol.size();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            String name = mutexItemCol.get(i).getName();
            if (map.containsKey(name)) {
                vld.addError("Duplicated mutexItem name: " + name);
            } else {
                map.put(name, name);
            }
            vld.addValidateList(mutexItemCol.get(i).validate());
        }
        return vld.getValidateList();
    }
}

