/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.permission.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PermissionInfo
extends AbstractMetaDataValue
implements Serializable {
    private static Logger logger = Logger.getLogger(PermissionInfo.class);
    private Set hasReferencedSet = null;
    private Map dependenceListMap = null;
    private Set dependenceCheckedSet = null;
    private List dependenceCheckingSet = null;
    private Set dependenceListSet = null;
    private DependenceCollection lnkDependenceCollection;
    private PermissionItemCollection lnkPermissionItemCollection;

    public PermissionInfo() {
        this.put("permissionItems", new PermissionItemCollection());
        this.put("dependences", new DependenceCollection());
    }

    protected PermissionInfo(boolean init) {
        super(init);
        this.put("permissionItems", new PermissionItemCollection());
        this.put("dependences", new DependenceCollection());
    }

    public PermissionItemCollection getPermissionItems() {
        return (PermissionItemCollection)this.get("permissionItems");
    }

    public DependenceCollection getDependences() {
        return (DependenceCollection)this.get("dependences");
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.PERMISSION;
    }

    public boolean hasItemReferenced(String itemName) {
        if (this.hasReferencedSet == null) {
            this.hasReferencedSet = new HashSet();
            DependenceCollection dependences = this.getDependences();
            for (int i = 0; i < dependences.size(); ++i) {
                DependenceInfo depe = dependences.get(i);
                this.hasReferencedSet.add(depe.getReferedItem().getName());
            }
        }
        return this.hasReferencedSet.contains(itemName);
    }

    @Override
    public ValidateList validate() {
        super.validate();
        ValidateMetaData vld = this.getValidate();
        PermissionItemCollection permissionItems = this.getPermissionItems();
        int length = permissionItems.size();
        HashSet<String> nameSet = new HashSet<String>();
        HashSet<String> innerIDSet = new HashSet<String>();
        for (int i = 0; i < length; ++i) {
            PermissionItemInfo item = permissionItems.get(i);
            String name = item.getName();
            String innerID = item.getInnerID();
            if (item.getType() == null) {
                vld.addError("please input permission item type! " + name);
            }
            String groupName = item.getGroupName();
            String group = item.getGroup();
            if (!StringUtils.isEmpty((String)group) && !StringUtils.isEmpty((String)groupName)) {
                StringTokenizer tokenGroupName = new StringTokenizer(groupName, ".");
                StringTokenizer tokenGroup = new StringTokenizer(group, ".");
                if (tokenGroupName.countTokens() != tokenGroup.countTokens()) {
                    vld.addError("GroupName's level nomatch groupAlias's" + name);
                }
            }
            if (innerIDSet.contains(innerID)) {
                vld.addError("Duplicated permissionItem innerID: " + innerID);
            } else {
                innerIDSet.add(innerID);
            }
            if (nameSet.contains(name)) {
                vld.addError("Duplicated permissionItem name: " + name);
            } else {
                nameSet.add(name);
            }
            vld.addValidateList(permissionItems.get(i).validate());
        }
        vld.addValidateList(this.validateDependences());
        return vld.getValidateList();
    }

    private void validateDepdenceByReferedItem(String currentItemName) throws BOSException {
        if (this.dependenceCheckedSet.contains(currentItemName)) {
            return;
        }
        if (this.dependenceCheckingSet.contains(currentItemName)) {
            String circleTreeLink = "";
            for (int i = 0; i < this.dependenceCheckingSet.size(); ++i) {
                circleTreeLink = circleTreeLink.equals("") ? (String)this.dependenceCheckingSet.get(i) : circleTreeLink + "-->" + (String)this.dependenceCheckingSet.get(i);
            }
            circleTreeLink = circleTreeLink + "-->" + currentItemName;
            throw new BOSException("The dependence tree is a circle!\nThe circle link is: " + circleTreeLink);
        }
        if (!this.dependenceListMap.containsKey(currentItemName)) {
            this.dependenceCheckedSet.add(currentItemName);
            return;
        }
        this.dependenceCheckingSet.add(currentItemName);
        PermissionItemCollection referingItems = (PermissionItemCollection)this.dependenceListMap.get(currentItemName);
        for (int i = 0; i < referingItems.size(); ++i) {
            PermissionItemInfo referingItem = referingItems.get(i);
            if (this.dependenceCheckedSet.contains(referingItem.getName())) continue;
            this.validateDepdenceByReferedItem(referingItem.getName());
        }
        this.dependenceCheckedSet.add(currentItemName);
    }

    public ValidateList validateDependence(PermissionItemInfo referedItem) {
        ValidateMetaData vld = new ValidateMetaData();
        this.prepareValidateDependences();
        try {
            this.validateDepdenceByReferedItem(referedItem.getName());
        }
        catch (BOSException e) {
            vld.addError(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
        return vld.getValidateList();
    }

    public ValidateList validateDependence(String permissionItemName) {
        ValidateMetaData vld = new ValidateMetaData();
        this.prepareValidateDependences();
        try {
            this.validateDepdenceByReferedItem(permissionItemName);
        }
        catch (BOSException e) {
            vld.addError(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
        return vld.getValidateList();
    }

    public ValidateList validateDependences() {
        ValidateMetaData vld = new ValidateMetaData();
        this.prepareValidateDependences();
        for (String permItemName : this.dependenceListSet) {
            try {
                this.dependenceCheckingSet = new LinkedList();
                this.validateDepdenceByReferedItem(permItemName);
            }
            catch (BOSException e) {
                vld.addError(e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
        return vld.getValidateList();
    }

    private void prepareValidateDependences() {
        this.dependenceListMap = new HashMap();
        this.dependenceListSet = new HashSet();
        DependenceCollection deps = this.getDependences();
        for (int i = 0; i < deps.size(); ++i) {
            DependenceInfo dep = deps.get(i);
            this.dependenceListMap.put(dep.getReferedItem().getName(), dep.getReferingItems());
            this.dependenceListSet.add(dep.getReferedItem().getName());
        }
        this.dependenceCheckedSet = new HashSet();
        this.dependenceCheckingSet = new LinkedList();
    }
}

