/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bizunitproxy;

import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.WebUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WebListUIProxyHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.bizunitproxy.ListUIProxyHelper");
    private WebUIProxyHelper uiProxyHelper;

    WebListUIProxyHelper(WebUIProxyHelper uiProxyHelper) {
        this.uiProxyHelper = uiProxyHelper;
    }

    public void createKDTableForQuery(WebUIObjectInfo model, BizUnitInfo bizUnit, String doName) {
        String baseName = doName.substring(0, 1).toUpperCase() + doName.substring(1);
        String tabName = "kdt" + baseName;
        ComponentInfo dataGrid = new ComponentInfo("com.kingdee.bos.ctrl.web.DataGrid");
        dataGrid.setConstraint(new SmartLayoutData(10, 10, 600, 170, 12));
        dataGrid.setName(tabName);
        String shortName = CodeFactory.getWebUIShortPackage(model.getPackage());
        PropertyInfo binding = new PropertyInfo();
        binding.setName("binding");
        binding.setMultiLanguage(false);
        binding.setType("java.lang.String");
        binding.setValue("#{" + shortName + "." + model.getName() + "Bean.grid}");
        dataGrid.getProperties().add(binding);
        PropertyInfo paged = new PropertyInfo();
        paged.setName("paged");
        paged.setType("boolean");
        paged.setMultiLanguage(false);
        paged.setValue("true");
        dataGrid.getProperties().add(paged);
        PropertyInfo rows = new PropertyInfo();
        rows.setName("rows");
        rows.setType("int");
        rows.setMultiLanguage(false);
        rows.setValue("10");
        dataGrid.getProperties().add(rows);
        PropertyInfo value = new PropertyInfo();
        value.setName("value");
        value.setType("java.lang.String");
        value.setMultiLanguage(false);
        value.setValue("pagedListData");
        dataGrid.getProperties().add(value);
        PropertyInfo var = new PropertyInfo();
        var.setName("var");
        var.setType("java.lang.String");
        var.setMultiLanguage(false);
        var.setValue("data");
        dataGrid.getProperties().add(var);
        PropertyInfo pnum = new PropertyInfo();
        pnum.setName("showRowNumber");
        pnum.setType(Boolean.class.getName());
        pnum.setValue("true");
        dataGrid.getProperties().add(pnum);
        PropertyInfo psync = new PropertyInfo();
        psync.setName("sync");
        psync.setType(Boolean.class.getName());
        psync.setValue("true");
        dataGrid.getProperties().add(psync);
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        ComponentInfo rootForm = WebUIProxyHelper.findRootForm(model);
        if (rootForm == null) {
            return;
        }
        rootForm.addChild(model, dataGrid);
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl() || !ObjectStateType.NEW.equals((Object)bizField.getObjectState()) && !ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 4) == 0) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, newBizFields, true, ObjectStateType.NEW, false);
                continue;
            }
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        WebListUIProxyHelper.createDataGridColumn(tempFields, doName, dataGrid);
    }

    void updateKDTableForQuery(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName, boolean needAdd) {
        if (model == null || bizUnit == null) {
            return;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl()) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                if ((ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) || ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                    delBizFields.add(bizField);
                    continue;
                }
                if (bizUnit.getEntryUI() != null || ((BizGroupFieldInfo)bizField).getQuery() != null) continue;
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, newBizFields, true, ObjectStateType.NEW, false);
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, updBizFields, true, ObjectStateType.CHANGED, false);
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, delBizFields, true, ObjectStateType.DELETING, false);
                continue;
            }
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                newBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                updBizFields.add(bizField);
                continue;
            }
            if (!ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) && !ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 4) == 0) continue;
            delBizFields.add(bizField);
        }
        if (newBizFields.size() == 0 && updBizFields.size() == 0 && delBizFields.size() == 0) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        ComponentInfo kdTable = WebUIProxyHelper.findBindingKDTable(collection.get(0), dataObjName, "com.kingdee.bos.ctrl.web.DataGrid");
        if (kdTable == null) {
            if (needAdd) {
                this.createKDTableForQuery(model, bizUnit, dataObjName);
            }
            return;
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[delBizFields.size()];
        System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, delBizFields.size());
        this.uiProxyHelper.delKDTableColumn(model, kdTable, tempFields, false);
        tempFields = new BizFieldInfo[updBizFields.size()];
        System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
        WebListUIProxyHelper.updKDTableColumn(kdTable, tempFields, dataObjName);
        tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        WebListUIProxyHelper.createDataGridColumn(tempFields, dataObjName, kdTable);
    }

    private void resetColumnIndex(TableInfo tableInfo, BizFieldCollection bizFields) {
        int i;
        if (tableInfo.getHeaderCount() < 1) {
            return;
        }
        HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        List columns = tableInfo.getColumns();
        ArrayList cells = headerInfo.getCells();
        if (columns.size() > cells.size()) {
            return;
        }
        Hashtable<String, Integer> listItemNames = new Hashtable<String, Integer>();
        int n = bizFields.size();
        for (int i2 = 0; i2 < n; ++i2) {
            BizFieldInfo field = bizFields.get(i2);
            String listItemName = field.getWebListItemName();
            if (StringUtils.isEmpty((String)listItemName)) continue;
            listItemNames.put(listItemName, new Integer(field.getFieldView().getListIndex()));
        }
        int[] listIndexs = new int[columns.size()];
        int n2 = columns.size();
        for (i = 0; i < n2; ++i) {
            ColumnInfo column = (ColumnInfo)columns.get(i);
            String columnName = column.getName();
            listIndexs[i] = listItemNames.containsKey(columnName) ? (Integer)listItemNames.get(columnName) : 0;
        }
        n2 = listIndexs.length;
        for (i = 0; i < n2; ++i) {
            if (listIndexs[i] == 0) continue;
            for (int j = i + 1; j < n2; ++j) {
                if (listIndexs[j] == 0 || listIndexs[j] >= listIndexs[i]) continue;
                int index = listIndexs[j];
                listIndexs[j] = listIndexs[i];
                listIndexs[i] = index;
                String temp = ((ColumnInfo)columns.get(j)).getName();
                ((ColumnInfo)columns.get(j)).setName(((ColumnInfo)columns.get(i)).getName());
                ((ColumnInfo)columns.get(i)).setName(temp);
                temp = ((CellInfo)cells.get(j)).getName();
                ((CellInfo)cells.get(j)).setName(((CellInfo)cells.get(i)).getName());
                ((CellInfo)cells.get(i)).setName(temp);
                boolean hide = ((ColumnInfo)columns.get(j)).isHide();
                ((ColumnInfo)columns.get(j)).setHide(((ColumnInfo)columns.get(i)).isHide());
                ((ColumnInfo)columns.get(i)).setHide(hide);
            }
        }
    }

    public static void createDataGridColumn(BizFieldInfo[] newBizFields, String doName, ComponentInfo kdtControl) {
        for (BizFieldInfo field : newBizFields) {
            String name = field.getQueryFieldName();
            String tempQueryFieldName = field.getQueryFieldName();
            if (StringUtils.isEmpty((String)tempQueryFieldName)) continue;
            name = StringUtils.replace((String)name, (String)".", (String)"_");
            ComponentInfo columnComp = new ComponentInfo("com.kingdee.bos.ctrl.web.Column");
            columnComp.setContainer(false);
            columnComp.setName(name + "Column");
            field.setWebListItemName(columnComp.getName());
            columnComp.setConstraint("width=170;height=19;newLine=false");
            PropertyInfo pheader = new PropertyInfo();
            pheader.setName("header");
            pheader.setType("java.lang.String");
            String cellName = field.getAlias();
            pheader.setValue(StringUtils.isEmpty((String)cellName) ? name : cellName);
            pheader.setMultiLanguage(true);
            PropertyInfo pwidth = new PropertyInfo();
            pwidth.setName("width");
            pwidth.setType("int");
            pwidth.setValue("100");
            PropertyCollection pcs = columnComp.getProperties();
            pcs.add(pheader);
            pcs.add(pwidth);
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName("value");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(doName);
            propertyBindingInfo.setBingdingField(tempQueryFieldName);
            propertyBindingInfo.setFieldType(String.class.getName());
            propertyBindingInfo.setOverride(true);
            columnComp.getPropertyBindings().add(propertyBindingInfo);
            columnComp.setParent(kdtControl);
            kdtControl.getComponents().add(columnComp);
        }
    }

    public static void updKDTableColumn(ComponentInfo kdTable, BizFieldInfo[] updBizFields, String dataObjName) {
        if (kdTable == null || updBizFields == null || StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        for (int i = 0; i < updBizFields.length; ++i) {
            ComponentInfo column;
            BizFieldInfo field = updBizFields[i];
            String name = field.getWebListItemName();
            String oldColName = name;
            if (StringUtils.isEmpty((String)oldColName) || (column = WebUIProxyHelper.findColumn(kdTable, oldColName)) == null) continue;
            String text = field.getWebListLabelText();
            if (StringUtils.isEmpty((String)text)) {
                text = field.getAlias();
            }
            PropertyInfo pheader = new PropertyInfo();
            pheader.setName("header");
            pheader.setType("java.lang.String");
            pheader.setValue(text);
            pheader.setMultiLanguage(true);
            column.getProperties().add(pheader);
            PropertyBindingInfo propertyBindingInfo = column.getPropertyBindings().get("value");
            if (propertyBindingInfo != null) {
                propertyBindingInfo.setBindingObject(dataObjName);
                propertyBindingInfo.setBingdingField(field.getQueryFieldName());
                continue;
            }
            String tempFieldName = field.getQueryFieldName();
            if (StringUtils.isEmpty((String)tempFieldName)) continue;
            propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName("value");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(tempFieldName);
            propertyBindingInfo.setFieldType(String.class.getName());
            propertyBindingInfo.setOverride(true);
            column.getPropertyBindings().add(propertyBindingInfo);
        }
    }
}

