/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bizunitproxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.ConditionRuleCollection;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodCollection;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.BizTemplateInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.HorizontalAlignmentType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.ServiceItemConstants;
import com.kingdee.bos.ui.bizunitproxy.WebEditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.WebListUIProxyHelper;
import com.kingdee.bos.ui.dtp.ActionServicePropertyHelper;
import com.kingdee.bos.ui.dtp.ControlConstant;
import com.kingdee.bos.ui.dtp.EventInfoHelper;
import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WebUIProxyHelper {
    private static final Logger logger = Logger.getLogger(WebUIProxyHelper.class);
    private static WebUIProxyHelper instance;
    private WebEditUIProxyHelper editUIInstance;
    private WebListUIProxyHelper listUIInstance;
    private Hashtable horizontalAlignmentHash = new Hashtable();
    private Hashtable verticalAlignmentHash = new Hashtable();
    public static final String INTFORMAT = "&int";
    public static final String DOUBLEFORMAT = "&double";
    public static final String CURRENCYFORMAT = "&currency";
    public static final String DATEFORMAT = "&date";
    public static final String TIMEFORMAT = "&time";
    public static final String DATETIMEFORMAT = "&datetime";

    private WebUIProxyHelper() {
        this.initHorizontalAlignmentHash();
        this.initVerticalAlignmentHash();
        this.listUIInstance = new WebListUIProxyHelper(this);
        this.editUIInstance = new WebEditUIProxyHelper(this);
    }

    private void initHorizontalAlignmentHash() {
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Center, new Integer(0));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Left, new Integer(2));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Right, new Integer(4));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Leading, new Integer(10));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Trailing, new Integer(11));
    }

    private void initVerticalAlignmentHash() {
    }

    public int getSwingHorizontalAlignment(HorizontalAlignmentType type) {
        Integer value = (Integer)this.horizontalAlignmentHash.get((Object)type);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public static WebUIProxyHelper getInstance() {
        if (instance == null) {
            instance = new WebUIProxyHelper();
        }
        return instance;
    }

    public void initWebUIObjectInfo(WebUIObjectInfo model) {
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection.size() != 0) {
            return;
        }
        ComponentCollection components = new ComponentCollection();
        ComponentInfo mainPanel = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDPanel");
        mainPanel.setName(model.getName());
        mainPanel.setConstraint(new Rectangle(0, 0, 1016, 600), false);
        mainPanel.setContainer(true);
        mainPanel.setLayoutInfo(LayoutConverter.convertToInfo(new XYLayout()));
        components.add(mainPanel);
        model.setComponents(components);
    }

    public void overrideDataObject(DataObjectInfo dataObj, BizUnitInfo bizUnit, boolean isQuery) {
        if (dataObj == null || bizUnit == null) {
            return;
        }
        if (isQuery) {
            JoinQueryInfo query = bizUnit.getQuery();
            this.overrideDataObjectForQuery(dataObj, query);
        } else {
            EntityObjectInfo entity = bizUnit.getEntity();
            this.overrideDataObjectForEntity(dataObj, entity);
        }
    }

    private void overrideDataObjectForQuery(DataObjectInfo dataObj, QueryInfo queryInfo) {
        if (dataObj == null || queryInfo == null) {
            return;
        }
        String type = "";
        if (!StringUtils.isEmpty((String)queryInfo.getPackage())) {
            type = queryInfo.getPackage() + ".";
        }
        type = type + queryInfo.getName();
        dataObj.setType(type);
        dataObj.setOverride(true);
        dataObj.setWriteCode(true);
    }

    private void overrideDataObjectForEntity(DataObjectInfo dataObj, EntityObjectInfo entityInfo) {
        if (dataObj == null || entityInfo == null) {
            return;
        }
        String type = "";
        if (!StringUtils.isEmpty((String)entityInfo.getPackage())) {
            type = entityInfo.getPackage() + ".";
        }
        type = type + entityInfo.getName();
        dataObj.setType(type);
        dataObj.setOverride(true);
        dataObj.setWriteCode(true);
    }

    public String bindingDataObject(WebUIObjectInfo model, BizUnitInfo bizUnit, boolean isQuery) {
        if (model == null || bizUnit == null) {
            return null;
        }
        if (isQuery) {
            JoinQueryInfo query = bizUnit.getQuery();
            return this.bindingDataObjectForQuery(model, query);
        }
        EntityObjectInfo entity = bizUnit.getEntity();
        return this.bindingDataObjectForEntity(model, entity);
    }

    private String bindingDataObjectForQuery(WebUIObjectInfo model, QueryInfo queryInfo) {
        if (model == null || queryInfo == null) {
            return null;
        }
        DataObjectInfo doInfo = new DataObjectInfo();
        String doName = "query" + queryInfo.getName();
        doInfo.setName(doName);
        String type = "";
        if (!StringUtils.isEmpty((String)queryInfo.getPackage())) {
            type = queryInfo.getPackage() + ".";
        }
        type = type + queryInfo.getName();
        doInfo.setType(type);
        doInfo.setObjectType(queryInfo.getBOSType().toString());
        model.getDataObjects().add(doInfo);
        return doName;
    }

    private String bindingDataObjectForEntity(WebUIObjectInfo model, EntityObjectInfo entityInfo) {
        DataObjectInfo doInfo;
        if (model == null || entityInfo == null) {
            return null;
        }
        String doName = "";
        if (model.getDataObjects().size() > 0) {
            doInfo = model.getDataObjects().get(0);
        } else {
            doInfo = new DataObjectInfo();
            model.getDataObjects().add(doInfo);
        }
        doName = "entity" + entityInfo.getName();
        doInfo.setName(doName);
        String type = "";
        if (!StringUtils.isEmpty((String)entityInfo.getPackage())) {
            type = entityInfo.getPackage() + ".";
        }
        type = type + entityInfo.getName();
        doInfo.setType(type);
        doInfo.setObjectType(entityInfo.getBOSType().toString());
        doInfo.setHerited(true);
        doInfo.setOverride(true);
        return doName;
    }

    public String findDataObjectName(WebUIObjectInfo model, BizUnitInfo bizUnit, boolean isQuery) {
        DataObjectInfo dataObject = this.findDataObject(model, bizUnit, isQuery);
        if (dataObject != null) {
            return dataObject.getName();
        }
        return null;
    }

    public DataObjectInfo findDataObject(WebUIObjectInfo model, BizUnitInfo bizUnit, boolean isQuery) {
        if (model == null || bizUnit == null) {
            return null;
        }
        AbstractMetaDataValue metaData = isQuery ? bizUnit.getQuery() : bizUnit.getEntity();
        if (metaData == null) {
            return null;
        }
        String type = "";
        if (!StringUtils.isEmpty((String)metaData.getPackage())) {
            type = metaData.getPackage() + ".";
        }
        type = type + metaData.getName();
        DataObjectCollection collection = model.getDataObjects();
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            DataObjectInfo dataObj = collection.get(i);
            if (!type.equals(dataObj.getType()) || !metaData.getBOSType().toString().equals(dataObj.getObjectType())) continue;
            return dataObj;
        }
        return null;
    }

    public void createKDTableForQuery(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        this.initWebUIObjectInfo(model);
        this.listUIInstance.createKDTableForQuery(model, bizUnit, dataObjName);
    }

    public void updateKDTableForQuery(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName, boolean needAdd) {
        this.listUIInstance.updateKDTableForQuery(model, bizUnit, dataObjName, needAdd);
    }

    void visitGroupField(BizGroupFieldInfo groupField, Vector bizFields, boolean checkState, ObjectStateType state, boolean recursive) {
        if (groupField == null || bizFields == null) {
            return;
        }
        if (checkState) assert (state != null);
        BizFieldCollection collection = groupField.getFields();
        if (collection == null || collection.size() == 0) {
            return;
        }
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            BizFieldInfo bizField = collection.get(i);
            if (!checkState || !state.equals((Object)bizField.getObjectState()) || !bizField.isGenControl()) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                if (!recursive) continue;
                this.visitGroupField((BizGroupFieldInfo)bizField, bizFields, checkState, state, recursive);
                continue;
            }
            bizFields.add(bizField);
        }
    }

    public void delKDTableColumn(WebUIObjectInfo model, ComponentInfo kdTable, BizFieldInfo[] delBizFields, boolean isEntity) {
        if (kdTable == null || delBizFields == null) {
            return;
        }
        for (int i = 0; i < delBizFields.length; ++i) {
            BizFieldInfo field = delBizFields[i];
            String colName = null;
            colName = isEntity ? field.getWebControlName() : field.getWebListItemName();
            ComponentInfo column = WebUIProxyHelper.findColumn(kdTable, colName);
            if (column == null) continue;
            kdTable.removeChild(model, column);
            if (StringUtils.isEmpty((String)colName)) continue;
            StatusCollection statuses = model.getStatuses();
            int m = statuses.size();
            for (int j = 0; j < m; ++j) {
                StatusInfo status = statuses.get(j);
                StatusItemCollection items = status.getStatusItems();
                for (int k = items.size() - 1; k >= 0; --k) {
                    StatusItemInfo statusItem = items.get(k);
                    if (!colName.equals(statusItem.getName())) continue;
                    items.removeObject(k);
                }
            }
        }
    }

    public static ComponentInfo findColumn(ComponentInfo table, String columnName) {
        if (table == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        ComponentCollection col = table.getComponents();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo cInfo = col.get(i);
            if (!columnName.equals(cInfo.getName())) continue;
            return cInfo;
        }
        return null;
    }

    public static ComponentInfo findBindingKDTable(ComponentInfo panel, String dataObjName, String classType) {
        ComponentInfo bindingKDTable = null;
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (int m = 0; m < n; ++m) {
            ComponentInfo componentInfo = children.get(m);
            if (classType.equals(componentInfo.getClassType())) {
                ComponentCollection columns = componentInfo.getComponents();
                int size = columns.size();
                for (int h = 0; h < size; ++h) {
                    ComponentInfo column = columns.get(h);
                    PropertyBindingInfo propBinding = column.getPropertyBindings().get("value");
                    if (propBinding == null || !dataObjName.equals(propBinding.getBindingObject())) continue;
                    return componentInfo;
                }
            }
            if ((bindingKDTable = WebUIProxyHelper.findBindingKDTable(componentInfo, dataObjName, classType)) == null) continue;
            return bindingKDTable;
        }
        return bindingKDTable;
    }

    public static ComponentInfo findBindingKDTable(ComponentCollection col, String dataObjName, String classType) {
        int n = col.size();
        for (int m = 0; m < n; ++m) {
            ComponentInfo componentInfo = col.get(m);
            if (!classType.equals(componentInfo.getClassType())) continue;
            ComponentCollection columns = componentInfo.getComponents();
            int size = columns.size();
            for (int h = 0; h < size; ++h) {
                ComponentInfo column = columns.get(h);
                PropertyBindingInfo propBinding = column.getPropertyBindings().get("value");
                if (propBinding == null || !dataObjName.equals(propBinding.getBindingObject())) continue;
                return componentInfo;
            }
        }
        return null;
    }

    public static ComponentInfo findBindingKDTable4Entry(ComponentCollection col, String bindingProperty, String classType) {
        int n = col.size();
        for (int m = 0; m < n; ++m) {
            ComponentInfo componentInfo = col.get(m);
            if (!classType.equals(componentInfo.getClassType())) continue;
            ComponentCollection columns = componentInfo.getComponents();
            int size = columns.size();
            for (int h = 0; h < size; ++h) {
                ComponentInfo column = columns.get(h);
                PropertyBindingInfo propBinding = column.getPropertyBindings().get("value");
                String bfield = propBinding.getBingdingField();
                if (bfield.indexOf(".") > 0) {
                    bfield = bfield.substring(0, bfield.indexOf("."));
                }
                if (propBinding == null || !bindingProperty.equals(bfield)) continue;
                return componentInfo;
            }
        }
        return null;
    }

    public static ComponentInfo findInnerWindowUserTag(ComponentCollection col) {
        int n = col.size();
        for (int m = 0; m < n; ++m) {
            ComponentInfo componentInfo = col.get(m);
            if (!"com.kingdee.bos.ctrl.web.UserTag".equals(componentInfo.getClassType()) || !"innerWindowUserTag".equals(componentInfo.getName())) continue;
            return componentInfo;
        }
        return null;
    }

    ComponentInfo findFirstTabbedPane(ComponentInfo panel) {
        ComponentInfo componentInfo;
        int m;
        if (panel == null) {
            return null;
        }
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            if (!"com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(componentInfo.getClassType())) continue;
            return componentInfo;
        }
        n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            ComponentInfo control = this.findFirstTabbedPane(componentInfo);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    public static ComponentInfo findControlByName(WebUIObjectInfo model, String controlName) {
        if (model == null || StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo control = WebUIProxyHelper.findControlByName(collection.get(i), controlName);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    public static ComponentInfo findControlByName(ComponentInfo panel, String controlName) {
        ComponentInfo componentInfo;
        int m;
        if (StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        if (controlName.equals(panel.getName())) {
            return panel;
        }
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            if (!controlName.equals(componentInfo.getName())) continue;
            return componentInfo;
        }
        n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            ComponentInfo control = WebUIProxyHelper.findControlByName(componentInfo, controlName);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    ComponentInfo findParentControl(ComponentInfo fromPanel, BizFieldInfo bizFieldInfo) {
        BizFieldViewInfo viewInfo = bizFieldInfo.getFieldView();
        if (viewInfo == null) {
            return null;
        }
        BizFieldInfo parentField = bizFieldInfo.getParent();
        ComponentInfo container = null;
        if (parentField != null) {
            container = WebUIProxyHelper.findControlByName(fromPanel, parentField.getControlName());
        }
        return container;
    }

    boolean deleteControlByName(ComponentInfo panel, String controlName) {
        if (StringUtils.isEmpty((String)controlName)) {
            return false;
        }
        ComponentInfo control = WebUIProxyHelper.findControlByName(panel, controlName);
        if (control != null) {
            ComponentInfo parent = control.getParent();
            if (parent == null) {
                return false;
            }
            control.setParent(null);
            return parent.getComponents().remove(control);
        }
        return false;
    }

    public void createEditUI(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        this.initWebUIObjectInfo(model);
        this.editUIInstance.createEditUI(model, bizUnit, dataObjName);
    }

    public void updateEditUI(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        this.editUIInstance.updateEditUI(model, bizUnit, dataObjName);
    }

    public void updateBizMethod(WebUIObjectInfo model, BizUnitInfo bizUnit, boolean isEditUI) {
        if (model == null || bizUnit == null) {
            return;
        }
        BizMethodCollection methods = bizUnit.getMethods();
        if (methods == null || methods.isEmpty()) {
            return;
        }
        Vector<BizMethodInfo> newMethods = new Vector<BizMethodInfo>();
        Vector<BizMethodInfo> updMethods = new Vector<BizMethodInfo>();
        Vector<BizMethodInfo> delMethods = new Vector<BizMethodInfo>();
        int j = methods.size();
        for (int i = 0; i < j; ++i) {
            BizMethodInfo methodInfo = methods.get(i);
            if (ObjectStateType.NEW.equals((Object)methodInfo.getObjectState()) || StringUtils.isEmpty((String)methodInfo.getWebActionName()) && isEditUI && "generateEditUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction()) && "generateAllUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction()) || StringUtils.isEmpty((String)methodInfo.getWebListActionName()) && !isEditUI && "generateListUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction()) && "generateAllUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction())) {
                newMethods.add(methodInfo);
                continue;
            }
            if (ObjectStateType.DELETING.equals((Object)methodInfo.getObjectState())) {
                delMethods.add(methodInfo);
                continue;
            }
            if (!ObjectStateType.CHANGED.equals((Object)methodInfo.getObjectState())) continue;
            updMethods.add(methodInfo);
        }
        BizMethodInfo[] tempMethods = new BizMethodInfo[delMethods.size()];
        System.arraycopy(delMethods.toArray(), 0, tempMethods, 0, delMethods.size());
        this.deleteAction(model, tempMethods, isEditUI);
        tempMethods = new BizMethodInfo[newMethods.size()];
        System.arraycopy(newMethods.toArray(), 0, tempMethods, 0, newMethods.size());
        this.createAction(model, tempMethods, isEditUI);
        tempMethods = new BizMethodInfo[updMethods.size()];
        System.arraycopy(updMethods.toArray(), 0, tempMethods, 0, updMethods.size());
        this.updateAction(model, tempMethods, isEditUI);
    }

    public void createEditTemplateUI(WebUIObjectInfo model, BizTemplateInfo template, String dataObjName) {
        this.editUIInstance.createEditUI(model, template, dataObjName);
    }

    void updateComponentRules(WebUIObjectInfo model, ComponentInfo component, BizFieldInfo bizField) {
        ConditionRuleCollection rules = bizField.getConditionRules();
        if (component == null || rules == null) {
            return;
        }
        RuleCollection collection = new RuleCollection();
        if (model.getRuleSet() != null) {
            int j = rules.size();
            for (int i = 0; i < j; ++i) {
                collection.add(rules.get(i));
            }
            if (bizField instanceof BizGroupFieldInfo) {
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizField;
                int n = groupField.getFields().size();
                for (int i = 0; i < n; ++i) {
                    BizFieldInfo subField = groupField.getFields().get(i);
                    if (ObjectStateType.DELETING.equals((Object)subField.getObjectState()) || ObjectStateType.DELETED.equals((Object)subField.getObjectState())) continue;
                    rules = subField.getConditionRules();
                    int m = rules.size();
                    for (int j2 = 0; j2 < m; ++j2) {
                        collection.add(rules.get(j2));
                    }
                }
            }
        }
        component.setRules(collection);
    }

    public void createListTemplateUI(WebUIObjectInfo model, BizTemplateInfo template, String dataObjName) {
        this.initWebUIObjectInfo(model);
        this.listUIInstance.createKDTableForQuery(model, template, dataObjName);
    }

    private void createAction(WebUIObjectInfo model, BizMethodInfo[] methods, boolean isEditUI) {
        assert (model != null && methods != null);
        if (methods.length == 0) {
            return;
        }
        ActionCollection actions = model.getActions();
        for (int i = 0; i < methods.length; ++i) {
            String tempStr;
            BizMethodInfo bizMethod = methods[i];
            String generateUIAction = bizMethod.getGenerateUIAction();
            if (!"generateAllUIAction".equalsIgnoreCase(generateUIAction) && (!isEditUI || !"generateEditUIAction".equalsIgnoreCase(generateUIAction)) && (isEditUI || !"generateListUIAction".equalsIgnoreCase(generateUIAction)) || StringUtils.isEmpty((String)(tempStr = methods[i].getName()))) continue;
            if (tempStr.length() < "action".length() || !"action".equalsIgnoreCase(tempStr.substring(0, "action".length()))) {
                tempStr = "action" + StringUtils.headCharUpperCase((String)tempStr);
            }
            ActionInfo action = new ActionInfo();
            action.setName(StringUtils.headCharLowerCase((String)tempStr));
            action.setClassName(StringUtils.headCharUpperCase((String)tempStr));
            action.setShortDesc(methods[i].getDescription());
            action.setControlName(methods[i].getAlias());
            action.setEnabled(true);
            action.setBindWorkFlow(methods[i].isBindWorkFlow());
            if (model.getDataObjects().size() > 0) {
                IObjectValue objVal = model.getDataObjects().get(0).getInstance();
                if (objVal != null) {
                    String actionCode;
                    if (objVal instanceof EntityObjectInfo && !StringUtils.isEmpty((String)(actionCode = ((EntityObjectInfo)objVal).getBusinessImplFactory()))) {
                        actionCode = actionCode + ".getRemoteInstance()." + methods[i].getMethodName() + "(editData);";
                        action.setActionPerformed(actionCode);
                    }
                } else {
                    objVal = model.getDataObjects().get(0).getInstanceOfQueryForBim();
                    if (objVal != null) {
                        try {
                            String actionCode;
                            EntityObjectInfo entity;
                            if (((JoinQueryInfo)objVal).getMainObject() != null && ((JoinQueryInfo)objVal).getMainObject() instanceof SubEntityInfo && (entity = ((SubEntityInfo)((JoinQueryInfo)objVal).getMainObject()).getEntityRef()) != null && !StringUtils.isEmpty((String)(actionCode = entity.getBusinessImplFactory()))) {
                                actionCode = "if (getSelectedKeyValue() == null) return;\n";
                                actionCode = actionCode + entity.getBusinessImplName() + "Info editData = (" + entity.getBusinessImplName() + "Info)getBizInterface().getValue(new com.kingdee.bos.dao.ormapping.ObjectUuidPK(BOSUuid.read(getSelectedKeyValue())));\n";
                                actionCode = actionCode + entity.getBusinessImplFactory() + ".getRemoteInstance()." + methods[i].getMethodName() + "(editData);";
                                action.setActionPerformed(actionCode);
                            }
                        }
                        catch (BOSException e) {
                            // empty catch block
                        }
                    }
                }
            }
            ActionExtendPropertyHelper actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty());
            actionHelper.setValue("isObjectUpdateLock", String.valueOf(methods[i].isObjectUpdateLock()));
            String mutexValue = methods[i].getMutexValue();
            if (!StringUtils.isEmpty((String)mutexValue)) {
                actionHelper.setValue("Mutex", mutexValue);
            } else {
                actionHelper.removeItem("Mutex");
            }
            actionHelper.setValue("userDefined", String.valueOf(methods[i].isUserDefined()));
            actionHelper.setValue("canForewarn", "true");
            ArrayList<ServiceItem> serviceList = new ArrayList<ServiceItem>();
            serviceList.add(ServiceItemConstants.PermissionService);
            serviceList.add(ServiceItemConstants.ForewarnService);
            if (!StringUtils.isEmpty((String)mutexValue)) {
                serviceList.add(ServiceItemConstants.MutexService);
            }
            if (methods[i].isBindWorkFlow()) {
                serviceList.add(ServiceItemConstants.WorkFlowService);
            }
            action.setServices(ActionServicePropertyHelper.toXmlString(serviceList));
            actions.add(action);
            if (isEditUI) {
                methods[i].setWebActionName(action.getName());
                methods[i].setWebActionClassName(action.getClassName());
            } else {
                methods[i].setWebListActionName(action.getName());
                methods[i].setWebListActionClassName(action.getClassName());
            }
            if (isEditUI) {
                this.updateActionRules(model, action, methods[i].getConditionRules());
            }
            if (isEditUI) {
                String bizStatusFieldValue;
                if (methods[i].getBizStatusFieldValue() != null) {
                    actionHelper.setValue("BizStatusFieldValue", methods[i].getBizStatusFieldValue().getName());
                } else if (action.getExtendedProperty("BizStatusFieldValue") != null && !StringUtils.isEmpty((String)actionHelper.getValue(bizStatusFieldValue = action.getExtendedProperty("BizStatusFieldValue")))) {
                    actionHelper.removeItem("BizStatusFieldValue");
                }
            }
            action.setActionExtendProperty(actionHelper.toXmlString());
        }
    }

    private ComponentInfo createMenuItemByAction(WebUIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        ComponentInfo menu = WebUIProxyHelper.findControlByName(model, "bizMenu");
        if (menu == null) {
            menu = this.createBizMethodMenu(model);
        }
        if (menu == null) {
            return null;
        }
        ComponentInfo bizMenuItem = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDMenuItem");
        bizMenuItem.setName(ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDMenuItem") + StringUtils.headCharUpperCase((String)action.getName()));
        menu.addChild(bizMenuItem);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("action");
        prop.setType("javax.swing.Action");
        prop.setMultiLanguage(false);
        prop.setValue(action.getName());
        bizMenuItem.getProperties().add(prop);
        method.setMenuItemName(bizMenuItem.getName());
        return bizMenuItem;
    }

    private ComponentInfo createToolbarBtnByAction(WebUIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        ComponentInfo toolBar;
        try {
            toolBar = model.getComponents().get(1);
        }
        catch (Exception ex) {
            return null;
        }
        ComponentInfo btn = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDWorkButton");
        btn.setName(ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDWorkButton") + StringUtils.headCharUpperCase((String)action.getName()));
        toolBar.addChild(btn);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("action");
        prop.setType("javax.swing.Action");
        prop.setMultiLanguage(false);
        prop.setValue(action.getName());
        btn.getProperties().add(prop);
        method.setToolBarButtonName(btn.getName());
        return btn;
    }

    private ComponentInfo createBizMethodMenu(WebUIObjectInfo model) {
        ComponentInfo menuBar;
        if (model == null) {
            return null;
        }
        try {
            menuBar = model.getComponents().get(2);
        }
        catch (Exception ex) {
            return null;
        }
        ComponentInfo bizMenu = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDMenu");
        bizMenu.setName("bizMenu");
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue("\u81ea\u5b9a\u4e49\u83dc\u5355");
        bizMenu.getProperties().add(prop);
        menuBar.addChild(bizMenu);
        return bizMenu;
    }

    private void updateActionRules(WebUIObjectInfo model, ActionInfo action, ConditionRuleCollection rules) {
        if (action == null || rules == null) {
            return;
        }
        RuleCollection collection = new RuleCollection();
        if (model.getRuleSet() != null) {
            int j = rules.size();
            for (int i = 0; i < j; ++i) {
                collection.add(rules.get(i));
            }
        }
        action.setRules(collection);
    }

    private void deleteAction(WebUIObjectInfo model, BizMethodInfo[] methods, boolean isEditUI) {
        assert (model != null && methods != null);
        if (methods.length == 0) {
            return;
        }
        ActionCollection actions = model.getActions();
        for (int i = 0; i < methods.length; ++i) {
            String tempStr = isEditUI ? methods[i].getWebActionName() : methods[i].getWebListActionName();
            if (StringUtils.isEmpty((String)tempStr)) continue;
            boolean ret = actions.removeActionByName(tempStr = StringUtils.headCharLowerCase((String)tempStr));
            if (ret) {
                actions.deleteActionProp(model.getComponents(), tempStr);
                actions.deleteActionStatus(model.getStatuses(), tempStr);
            }
            if (isEditUI) {
                methods[i].setWebActionName(null);
                continue;
            }
            methods[i].setWebListActionName(null);
        }
    }

    private void deleteMenuItemByAction(WebUIObjectInfo model, String menuItemName) {
        ComponentInfo menu = WebUIProxyHelper.findControlByName(model, "bizMenu");
        if (menu == null) {
            return;
        }
        this.deleteControlByName(menu, menuItemName);
    }

    private void deleteToolbarBtnByAction(WebUIObjectInfo model, String btnName) {
        ComponentInfo toolbar;
        try {
            toolbar = model.getComponents().get(1);
        }
        catch (Exception ex) {
            return;
        }
        this.deleteControlByName(toolbar, btnName);
    }

    private void updateAction(WebUIObjectInfo model, BizMethodInfo[] methods, boolean isEditUI) {
        assert (model != null && methods != null);
        if (methods.length == 0) {
            return;
        }
        ActionCollection actions = model.getActions();
        for (int i = 0; i < methods.length; ++i) {
            String tempStr = isEditUI ? methods[i].getWebActionName() : methods[i].getWebListActionName();
            if (StringUtils.isEmpty((String)tempStr)) continue;
            ActionInfo action = actions.getActionByName(StringUtils.headCharLowerCase((String)tempStr));
            if (action == null) {
                action = new ActionInfo();
                action.setName(StringUtils.headCharLowerCase((String)tempStr));
                actions.add(action);
            }
            action.setClassName(StringUtils.headCharUpperCase((String)tempStr));
            action.setShortDesc(methods[i].getDescription());
            action.setControlName(methods[i].getAlias());
            action.setEnabled(true);
            action.setBindWorkFlow(methods[i].isBindWorkFlow());
            ActionExtendPropertyHelper actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty());
            actionHelper.setValue("isObjectUpdateLock", String.valueOf(methods[i].isObjectUpdateLock()));
            String mutexValue = methods[i].getMutexValue();
            if (!StringUtils.isEmpty((String)mutexValue)) {
                actionHelper.setValue("Mutex", mutexValue);
            } else {
                actionHelper.removeItem("Mutex");
            }
            actionHelper.setValue("userDefined", String.valueOf(methods[i].isUserDefined()));
            if (action.isHerited()) {
                action.setOverride(true);
            }
            if (isEditUI) {
                methods[i].setWebActionName(action.getName());
            } else {
                methods[i].setWebListActionName(action.getName());
            }
            List serviceList = ActionServicePropertyHelper.parseServiceItems(action.getServices());
            ServiceItem workflowItem = null;
            ServiceItem mutexItem = null;
            int m = serviceList.size();
            for (int j = 0; j < m; ++j) {
                if (ServiceItemConstants.WorkFlowService.getServiceClass().equalsIgnoreCase(((ServiceItem)serviceList.get(j)).getServiceClass())) {
                    workflowItem = (ServiceItem)serviceList.get(j);
                    continue;
                }
                if (!ServiceItemConstants.MutexService.getServiceClass().equalsIgnoreCase(((ServiceItem)serviceList.get(j)).getServiceClass())) continue;
                mutexItem = (ServiceItem)serviceList.get(j);
            }
            if (StringUtils.isEmpty((String)mutexValue) && mutexItem != null) {
                serviceList.remove(mutexItem);
            } else if (!StringUtils.isEmpty((String)mutexValue) && mutexItem == null) {
                serviceList.add(ServiceItemConstants.MutexService);
            }
            if (!methods[i].isBindWorkFlow() && workflowItem != null) {
                serviceList.remove(workflowItem);
            } else if (methods[i].isBindWorkFlow() && workflowItem == null) {
                serviceList.add(ServiceItemConstants.WorkFlowService);
            }
            action.setServices(ActionServicePropertyHelper.toXmlString(serviceList));
            if (isEditUI) {
                this.updateActionRules(model, action, methods[i].getConditionRules());
            }
            if (isEditUI) {
                if (methods[i].getBizStatusFieldValue() != null) {
                    actionHelper.setValue("BizStatusFieldValue", methods[i].getBizStatusFieldValue().getName());
                } else if (action.getExtendedProperty("BizStatusFieldValue") != null && !StringUtils.isEmpty((String)actionHelper.getValue(action.getExtendedProperty("BizStatusFieldValue")))) {
                    actionHelper.removeItem("BizStatusFieldValue");
                }
            }
            action.setActionExtendProperty(actionHelper.toXmlString());
        }
    }

    private void updateMenuItemByAction(WebUIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        String menuItemName;
        ComponentInfo menuItem;
        ComponentInfo menu = WebUIProxyHelper.findControlByName(model, "bizMenu");
        if (menu == null) {
            menu = this.createBizMethodMenu(model);
        }
        if ((menuItem = WebUIProxyHelper.findControlByName(menu, menuItemName = method.getMenuItemName())) == null) {
            this.createMenuItemByAction(model, action, method);
        }
    }

    private void updateToobarBtnByAction(WebUIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        ComponentInfo toolbar;
        try {
            toolbar = model.getComponents().get(1);
        }
        catch (Exception ex) {
            return;
        }
        String btnName = method.getToolBarButtonName();
        ComponentInfo btn = WebUIProxyHelper.findControlByName(toolbar, btnName);
        if (btn == null) {
            this.createToolbarBtnByAction(model, action, method);
        }
    }

    public PropertyInfo getProperty(String className, String propertyName) {
        return EventInfoHelper.getInstance().getProperty(className, propertyName);
    }

    public PropertyInfo getDefaultProperty(String controlType) {
        if (StringUtils.isEmpty((String)controlType)) {
            return null;
        }
        PropertyInfo info = this.getValueProp();
        return info;
    }

    private PropertyInfo getValueProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("value");
        prop.setType(Object.class.getName());
        return prop;
    }

    public static String getClassType(com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        String classType = null;
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            DataType dataType = ownProp.getDataType();
            if (DataType.BOOLEAN.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.CheckBox";
            } else if (DataType.STRING.equals(dataType) || DataType.BOSUUID.equals(dataType) || DataType.UUID.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.TextField";
            } else if (DataType.FLOAT.equals(dataType) || DataType.DOUBLE.equals(dataType) || DataType.DECIMAL.equals(dataType) || DataType.INTEGER.equals(dataType) || DataType.SHORT.equals(dataType) || DataType.LONG.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.NumberField";
            } else if (DataType.ENUM.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.EnumCombo";
            } else if (DataType.DATE.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.DateField";
            } else if (DataType.TIMESTAMP.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.DateTimeField";
            } else if (DataType.TIME.equals(dataType)) {
                classType = "com.kingdee.bos.ctrl.web.TimeField";
            }
        } else if (prop instanceof LinkPropertyInfo) {
            CardinalityType cardinalType = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality();
            classType = CardinalityType.ONE_TO_UNBOUNDED.equals((Object)cardinalType) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)cardinalType) ? "com.kingdee.bos.ctrl.web.EditDataGrid" : "com.kingdee.bos.ctrl.web.PromptBox";
        }
        return classType;
    }

    public static List findControlsByClassType(ComponentInfo container, String classType) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        if (container == null || StringUtils.isEmpty((String)classType)) {
            return list;
        }
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if (classType.equalsIgnoreCase(component.getClassType())) {
                list.add(component);
            }
            if (component.getComponents() == null || component.getComponents().size() <= 0) continue;
            List subList = WebUIProxyHelper.findControlsByClassType(component, classType);
            list.addAll(subList);
        }
        return list;
    }

    public static List findControlsByClassType(WebUIObjectInfo model, String classType) {
        ArrayList list = new ArrayList();
        if (model == null || StringUtils.isEmpty((String)classType)) {
            return list;
        }
        return WebUIProxyHelper.findControlsByClassType(model.getMainPanelComponent(), classType);
    }

    private static Rectangle convertToRectangle(KDLayoutConstraint constraint) {
        return constraint.toRectangle();
    }

    private static KDLayoutConstraint convertToKDLayoutConstraint(Rectangle constraint) {
        return new KDLayoutConstraint(constraint);
    }

    public static void setLayout(ComponentInfo control, LayoutInfo layout) {
        block4: {
            String layoutType;
            block5: {
                if (control == null || layout == null) {
                    return;
                }
                String oldLayoutType = null;
                if (control.getLayoutInfo() != null) {
                    oldLayoutType = control.getLayoutInfo().getType();
                }
                layoutType = layout.getType();
                if (StringUtils.isEmpty((String)oldLayoutType) || StringUtils.isEmpty((String)layoutType) || oldLayoutType.equals(layoutType) || !"XYLayout".equals(oldLayoutType) && !"KDLayout".equals(oldLayoutType)) break block4;
                if (!"XYLayout".equals(layoutType)) break block5;
                control.setLayoutInfo(layout);
                control.getLayoutInfo().setOverride(true);
                int n = control.getComponents().size();
                for (int i = 0; i < n; ++i) {
                    if (!(control.getComponents().get(i).getConstraint() instanceof KDLayoutConstraint)) continue;
                    control.getComponents().get(i).setConstraint(WebUIProxyHelper.convertToRectangle((KDLayoutConstraint)control.getComponents().get(i).getConstraint()));
                }
                break block4;
            }
            if (!"KDLayout".equals(layoutType)) break block4;
            control.setLayoutInfo(layout);
            control.getLayoutInfo().setOverride(true);
            int n = control.getComponents().size();
            for (int i = 0; i < n; ++i) {
                if (!(control.getComponents().get(i).getConstraint() instanceof Rectangle)) continue;
                control.getComponents().get(i).setConstraint(WebUIProxyHelper.convertToKDLayoutConstraint((Rectangle)control.getComponents().get(i).getConstraint()));
            }
        }
    }

    public static DataObjectInfo findDataObjectByType(WebUIObjectInfo uiObject, String type) {
        if (uiObject == null || StringUtils.isEmpty((String)type)) {
            return null;
        }
        DataObjectCollection dataObjects = uiObject.getDataObjects();
        int n = dataObjects.size();
        for (int i = 0; i < n; ++i) {
            if (!type.equalsIgnoreCase(dataObjects.get(i).getType())) continue;
            return dataObjects.get(i);
        }
        return null;
    }

    private static boolean isBindDataObject(ComponentInfo component, DataObjectInfo dataObject) {
        PropertyBindingCollection propBindings = component.getPropertyBindings();
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            if (!dataObject.getName().equalsIgnoreCase(propBindings.get(i).getBindingObject())) continue;
            return true;
        }
        return false;
    }

    public static List findControlsByDataObject(ComponentInfo container, DataObjectInfo dataObject) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        if (container == null || dataObject == null) {
            return list;
        }
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if (WebUIProxyHelper.isBindDataObject(component, dataObject)) {
                list.add(component);
            }
            if (component.getComponents() == null || component.getComponents().size() <= 0) continue;
            List subList = WebUIProxyHelper.findControlsByDataObject(component, dataObject);
            list.addAll(subList);
        }
        return list;
    }

    public static List findControlsByDataObject(WebUIObjectInfo uiObject, DataObjectInfo dataObject) {
        ArrayList list = new ArrayList();
        if (uiObject == null || dataObject == null) {
            return list;
        }
        return WebUIProxyHelper.findControlsByDataObject(uiObject.getMainPanelComponent(), dataObject);
    }

    public static ComponentInfo findKDTableByDataObject(ComponentInfo container, DataObjectInfo dataObject) {
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if (!("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(component.getClassType()) ? WebUIProxyHelper.isBindDataObject(component, dataObject) : component.getComponents() != null && component.getComponents().size() > 0 && (component = WebUIProxyHelper.findKDTableByDataObject(component, dataObject)) != null)) continue;
            return component;
        }
        return null;
    }

    public static ComponentInfo findKDTableByDataObject(WebUIObjectInfo uiObject, DataObjectInfo dataObject) {
        if (uiObject == null || dataObject == null) {
            return null;
        }
        return WebUIProxyHelper.findKDTableByDataObject(uiObject.getMainPanelComponent(), dataObject);
    }

    public static DataObjectCollection getSubQuerys(WebUIObjectInfo uiObject) {
        DataObjectCollection subQuerys = new DataObjectCollection();
        if (uiObject == null) {
            return subQuerys;
        }
        DataObjectCollection dataObjects = uiObject.getDataObjects();
        int n = dataObjects.size();
        for (int i = 1; i < n; ++i) {
            if (!MetaDataTypeList.JOINQUERY.toString().equals(dataObjects.get(i).getObjectType())) continue;
            subQuerys.add(dataObjects.get(i));
        }
        return subQuerys;
    }

    public static String getTableColumnName(ComponentInfo kdTable, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        PropertyBindingCollection pbCol = kdTable.getPropertyBindings();
        int n = pbCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = pbCol.get(i);
            if (!pbInfo.getBingdingField().endsWith(fieldName) || StringUtils.isEmpty((String)pbInfo.getPropertyName())) continue;
            return StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
        }
        return null;
    }

    public static ComponentInfo findComponentByBindingField(WebUIObjectInfo uiObject, String bindingField) {
        if (uiObject == null || StringUtils.isEmpty((String)bindingField)) {
            return null;
        }
        return WebUIProxyHelper.findComponentByBindingField(uiObject.getMainPanelComponent(), bindingField);
    }

    public static ComponentInfo findComponentByBindingField(ComponentInfo container, String bindingField) {
        if (container == null || StringUtils.isEmpty((String)bindingField)) {
            return null;
        }
        PropertyBindingCollection pbCol = container.getPropertyBindings();
        int n = pbCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = pbCol.get(i);
            if (!bindingField.equalsIgnoreCase(pbInfo.getBingdingField())) continue;
            return container;
        }
        ComponentCollection collection = container.getComponents();
        int n2 = collection.size();
        for (int i = 0; i < n2; ++i) {
            ComponentInfo component = WebUIProxyHelper.findComponentByBindingField(collection.get(i), bindingField);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public static boolean addIdColumn(EntityObjectInfo entity, ComponentInfo table, WebUIObjectInfo model, String doName, String linkPropName) {
        com.kingdee.bos.metadata.entity.PropertyInfo pInfo = entity.getPropertyByName("id", true);
        if (pInfo != null && pInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo pId = (OwnPropertyInfo)pInfo;
            ComponentInfo column = new ComponentInfo("com.kingdee.bos.ctrl.web.EditableColumn");
            column.setContainer(true);
            column.setName(model.getNameManager().getNameByName("idColumn"));
            column.setConstraint("width=170;height=19;newLine=false");
            LayoutInfo layout = new LayoutInfo();
            layout.setType("WebLayout");
            layout.setName(model.getNameManager().getNameByName("WebLayout"));
            layout.setValue("0,1,false");
            column.setLayoutInfo(layout);
            PropertyCollection pcs = column.getProperties();
            PropertyInfo pheader = new PropertyInfo();
            pheader.setName("header");
            pheader.setType("java.lang.String");
            pheader.setValue("id");
            pcs.add(pheader);
            PropertyInfo pwidth = new PropertyInfo();
            pwidth.setName("width");
            pwidth.setType("int");
            pwidth.setValue("100");
            pcs.add(pwidth);
            PropertyInfo pIsId = new PropertyInfo();
            pIsId.setName("idColumn");
            pIsId.setType(Boolean.class.getName());
            pIsId.setValue("true");
            pcs.add(pIsId);
            PropertyInfo phidden = new PropertyInfo();
            phidden.setName("hidden");
            phidden.setType(Boolean.class.getName());
            phidden.setValue("true");
            pcs.add(phidden);
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName("value");
            propertyBindingInfo.setPropertyType(String.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(doName);
            propertyBindingInfo.setBingdingField(linkPropName + "." + pId.getName());
            propertyBindingInfo.setFieldType(pId.getJavaType());
            column.getPropertyBindings().add(propertyBindingInfo);
            column.setParent(table);
            table.getComponents().add(column);
            return true;
        }
        return false;
    }

    public static PropertyBindingInfo createPropBindInfo(String classType, String bindField, com.kingdee.bos.metadata.entity.PropertyInfo prop, String doName) {
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("value");
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(bindField);
        if ("com.kingdee.bos.ctrl.web.CheckBox".equals(classType)) {
            propertyBindingInfo.setPropertyType("boolean");
        } else if ("com.kingdee.bos.ctrl.web.EnumCombo".equals(classType) || "com.kingdee.bos.ctrl.web.ListBox".equals(classType) || "com.kingdee.bos.ctrl.web.DateField".equals(classType) || "com.kingdee.bos.ctrl.web.DateTimeField".equals(classType) || "com.kingdee.bos.ctrl.web.NumberField".equals(classType) || "com.kingdee.bos.ctrl.web.PromptBox".equals(classType)) {
            propertyBindingInfo.setPropertyType(Object.class.getName());
        } else {
            propertyBindingInfo.setPropertyType(String.class.getName());
        }
        if ("com.kingdee.bos.ctrl.web.EnumCombo".equals(classType) || "com.kingdee.bos.ctrl.web.ListBox".equals(classType)) {
            propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getEnumType().getClassName());
        } else if ("com.kingdee.bos.ctrl.web.PromptBox".equals(classType)) {
            propertyBindingInfo.setFieldType(((LinkPropertyInfo)prop).getRelationship().getSupplierObject().getObjectValueClass());
        } else {
            propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
        }
        return propertyBindingInfo;
    }

    public static ComponentInfo findRootForm(WebUIObjectInfo model) {
        ComponentInfo main;
        if (model != null && (main = model.getMainPanelComponent()) != null) {
            return WebUIProxyHelper.findComponentInfoByNameAndType(main.getComponents(), "rootForm", "com.kingdee.bos.ctrl.web.Form");
        }
        return null;
    }

    private static ComponentInfo findComponentInfoByNameAndType(ComponentCollection col, String name, String type) {
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo child;
                ComponentInfo cInfo = col.get(i);
                if (name.equals(cInfo.getName()) && type.equals(cInfo.getClassType())) {
                    return cInfo;
                }
                if (!cInfo.isContainer() || (child = WebUIProxyHelper.findComponentInfoByNameAndType(cInfo.getComponents(), name, type)) == null) continue;
                return child;
            }
        }
        return null;
    }

    public static boolean isEL(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.startsWith("#{") && str.endsWith("}");
    }

    public static String getWebUIShortPackage(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return packageName;
        }
        String shortName = packageName;
        if (shortName.startsWith("com.kingdee.eas.")) {
            shortName = shortName.substring("com.kingdee.eas.".length());
        }
        if (shortName.endsWith(".web")) {
            shortName = shortName.substring(0, shortName.length() - ".web".length());
        }
        return shortName;
    }
}

