/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp;

import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ActionServicePropertyHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.dtp.ActionServicePropertyHelper");
    private static final String SERVICE_NAME = "name";
    private static final String SERVICE_CLASS = "class";
    private static final String ROOT_ELEMENT = "root";
    private static final String ITEM_ELEMENT = "service";

    private ActionServicePropertyHelper() {
    }

    public static final List parseServiceItems(String xmlString) {
        return ActionServicePropertyHelper.parseXml(xmlString);
    }

    public static final String toXmlString(ServiceItem[] services) {
        return ActionServicePropertyHelper.genXmlString(services);
    }

    public static final String toXmlString(List services) {
        if (services == null) {
            return "";
        }
        int size = services.size();
        ServiceItem[] items = new ServiceItem[size];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            Object obj = services.get(i);
            if (!(obj instanceof ServiceItem)) continue;
            items[j] = (ServiceItem)obj;
            ++j;
        }
        return ActionServicePropertyHelper.toXmlString(items);
    }

    private static List parseXml(String xml) {
        Vector<ServiceItem> services = new Vector<ServiceItem>();
        if (StringUtils.isEmpty((String)xml)) {
            return services;
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build((Reader)new StringReader(xml));
            Element root = doc.getRootElement();
            for (Element element : root.getChildren()) {
                String serviceClass = element.getAttributeValue(SERVICE_CLASS);
                services.add(new ServiceItem(serviceClass));
            }
        }
        catch (JDOMException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return services;
    }

    private static String genXmlString(ServiceItem[] services) {
        String rv = "";
        if (services == null || services.length == 0) {
            return rv;
        }
        Element rootElement = new Element(ROOT_ELEMENT);
        Document document = new Document(rootElement);
        XMLOutputter outputter = new XMLOutputter();
        int j = services.length;
        for (int i = 0; i < j; ++i) {
            if (services[i] == null) continue;
            Element element = new Element(ITEM_ELEMENT);
            element.setAttribute(SERVICE_CLASS, services[i].getServiceClass());
            rootElement.addContent(element);
        }
        rv = outputter.outputString(document);
        return rv;
    }
}

