/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.kdlayout;

import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutUtil;
import java.awt.Rectangle;
import java.io.Serializable;

public class KDLayoutConstraint
implements Serializable,
Cloneable {
    public int x;
    public int y;
    public int width;
    public int height;
    public int anchor;

    public KDLayoutConstraint() {
    }

    public KDLayoutConstraint(KDLayoutConstraint constraint) {
        if (constraint != null) {
            this.x = constraint.x;
            this.y = constraint.y;
            this.width = constraint.width;
            this.height = constraint.height;
            this.anchor = constraint.anchor;
        }
    }

    public KDLayoutConstraint(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = rectangle.width;
            this.height = rectangle.height;
        }
    }

    public KDLayoutConstraint(Rectangle rectangle, int anchor) {
        if (rectangle != null) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = rectangle.width;
            this.height = rectangle.height;
        }
        this.anchor = anchor;
    }

    public KDLayoutConstraint(int x, int y, int width, int height) {
        this(x, y, width, height, 0);
    }

    public KDLayoutConstraint(int x, int y, int width, int height, int anchor) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.anchor = anchor;
    }

    public boolean equalsSize(KDLayoutConstraint other) {
        return this.width == other.width && this.height == other.height;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.anchor + ",";
    }

    public String toJavaCode() {
        return "new KDLayout.Constraints(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", " + this.getAnchorCode() + ")";
    }

    private String getAnchorCode() {
        int[] sideAnchor = KDLayoutUtil.getSideAnchor(this.anchor);
        int top = sideAnchor[0];
        int bottom = sideAnchor[1];
        int left = sideAnchor[2];
        int right = sideAnchor[3];
        boolean center = sideAnchor[4] == 1;
        boolean hasSet = false;
        String ret = "";
        if ((top | bottom | left | right) == 0 && !center) {
            return "0";
        }
        if (center) {
            ret = "KDLayout.Constraints.ANCHOR_CENTRE";
            hasSet = true;
        }
        if (top == 1) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_TOP";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_TOP";
                hasSet = true;
            }
        } else if (top == 32) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_TOP_SCALE";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_TOP_SCALE";
                hasSet = true;
            }
        }
        if (bottom == 2) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_BOTTOM";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_BOTTOM";
                hasSet = true;
            }
        } else if (bottom == 64) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_BOTTOM_SCALE";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_BOTTOM_SCALE";
                hasSet = true;
            }
        }
        if (left == 4) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_LEFT";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_LEFT";
                hasSet = true;
            }
        } else if (left == 128) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_LEFT_SCALE";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_LEFT_SCALE";
                hasSet = true;
            }
        }
        if (right == 8) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_RIGHT";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_RIGHT";
                hasSet = true;
            }
        } else if (right == 256) {
            if (hasSet) {
                ret = ret + " | KDLayout.Constraints.ANCHOR_RIGHT_SCALE";
            } else {
                ret = "KDLayout.Constraints.ANCHOR_RIGHT_SCALE";
                hasSet = true;
            }
        }
        if (hasSet) {
            return ret;
        }
        return "0";
    }

    public Object clone() {
        return new KDLayoutConstraint(this);
    }
}

