/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.kdtable;

import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.MergeBlockInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableInfoHelper {
    private static Logger logger = Logger.getLogger(TableInfoHelper.class);

    public static void addColumn(TableInfo tblNew, TableInfo tblOld, int oldIndex) {
        ColumnInfo colOld = (ColumnInfo)tblOld.getColumns().get(oldIndex);
        List cols = tblNew.getColumns();
        colOld.setParent(tblNew);
        int maxIndex = cols.size();
        int newIndex = colOld.getIndex() != -1 ? (colOld.getIndex() > maxIndex ? maxIndex : colOld.getIndex()) : (oldIndex > maxIndex ? maxIndex : oldIndex);
        cols.add(newIndex, colOld);
        List rowsNew = tblNew.getHeaders();
        if (rowsNew.size() != tblOld.getHeaderCount()) {
            logger.info((Object)("Table header rows are not equal : tblNew " + rowsNew.size() + "    tblOld " + tblOld.getHeaderCount()));
        }
        for (int i = 0; i < rowsNew.size(); ++i) {
            CellInfo cell = TableInfoHelper.getCellInfo(tblOld, i, oldIndex);
            if (cell == null) continue;
            HeaderInfo hi = (HeaderInfo)rowsNew.get(i);
            ArrayList rowNew = hi.getCells();
            cell.setParent(hi);
            rowNew.add(newIndex, cell);
        }
        TableInfoHelper.adjustMergeInfo(tblNew, newIndex);
    }

    private static CellInfo getCellInfo(TableInfo tbl, int rowIndex, int colIndex) {
        HeaderInfo hi;
        ArrayList cells;
        List rows = tbl.getHeaders();
        if (rows != null && rows.size() > rowIndex && (cells = (hi = (HeaderInfo)rows.get(rowIndex)).getCells()) != null && cells.size() > colIndex) {
            return (CellInfo)cells.get(colIndex);
        }
        return null;
    }

    private static void adjustMergeInfo(TableInfo tbl, int index) {
        List blocks = tbl.getMergeBlocks();
        if (blocks != null) {
            for (MergeBlockInfo mb : blocks) {
                if (index <= mb.getLeft()) {
                    mb.setLeft(mb.getLeft() + 1);
                    mb.setRight(mb.getRight() + 1);
                    continue;
                }
                if (index > mb.getRight()) continue;
                mb.setRight(mb.getRight() + 1);
            }
        }
    }

    public static String toFormatXmlExt(TableInfo tbl) {
        StringBuffer buf = new StringBuffer();
        List columns = tbl.getColumns();
        boolean isFirstItem = true;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (!(columns.get(i) instanceof ColumnInfo)) continue;
            ColumnInfo column = (ColumnInfo)columns.get(i);
            Map extendProperties = column.getExtendProperties();
            Iterator iter = extendProperties.keySet().iterator();
            while (iter.hasNext()) {
                if (!isFirstItem) {
                    buf.append(";");
                }
                String key = (String)iter.next();
                buf.append(column.getName() + "." + key);
                buf.append("=");
                buf.append(extendProperties.get(key));
                isFirstItem = false;
            }
        }
        return buf.toString();
    }

    public static void parseFormatXmlExt(TableInfo tbl, String formatXmlExt) {
        if (StringUtils.isEmpty((String)formatXmlExt)) {
            return;
        }
        String[] array = StringUtils.split((String)formatXmlExt, (String)";");
        ArrayList<String> list = new ArrayList<String>();
        int m = array.length;
        for (int j = 0; j < m; ++j) {
            if (StringUtils.isEmpty((String)array[j]) || array[j].indexOf("=") <= 0) continue;
            list.add(array[j]);
        }
        List columns = tbl.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (!(columns.get(i) instanceof ColumnInfo)) continue;
            ColumnInfo column = (ColumnInfo)columns.get(i);
            for (int j = list.size() - 1; j >= 0; --j) {
                String item = (String)list.get(j);
                if (!item.startsWith(column.getName() + ".")) continue;
                String key = item.substring((column.getName() + ".").length());
                key = key.substring(0, key.indexOf("="));
                String value = item.substring(item.indexOf("=") + 1);
                column.getExtendProperties().put(key, value);
                list.remove(j);
            }
        }
    }

    public static void main(String[] args) {
        TableInfo table = new TableInfo();
        ColumnInfo column = new ColumnInfo();
        column.setName("column1");
        column.getExtendProperties().put("defaultF7Query", "XXXQuery");
        column.getExtendProperties().put("dataType", "String");
        table.addColumn(column);
        column = new ColumnInfo();
        column.setName("column2");
        column.getExtendProperties().put("defaultF7Query", "YYYQuery");
        column.getExtendProperties().put("dataType", "Date");
        table.addColumn(column);
        System.out.println(TableInfoHelper.toFormatXmlExt(table));
        String formatXmlExt = "column1.dataType=String;column1.defaultF7Query=XXXQuery;column2.dataType=Date;column2.defaultF7Query=YYYQuery";
        ((ColumnInfo)table.getColumns().get(0)).getExtendProperties().clear();
        ((ColumnInfo)table.getColumns().get(1)).getExtendProperties().clear();
        TableInfoHelper.parseFormatXmlExt(table, formatXmlExt);
        System.out.println(TableInfoHelper.toFormatXmlExt(table));
    }
}

