/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.smartlayout;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Properties;

public class SmartLayoutData
implements Serializable,
Cloneable {
    public int x;
    public int y;
    public int width;
    public int height;
    public int autoSize;

    public SmartLayoutData(SmartLayoutData sld) {
        this(sld.x, sld.y, sld.width, sld.height, sld.autoSize);
    }

    public SmartLayoutData(int x, int y, int width, int height, int autoSize) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.autoSize = autoSize;
    }

    public SmartLayoutData() {
    }

    public static SmartLayoutData parse(String s) {
        if (s == null) {
            return null;
        }
        byte[] buffer = s.replace(';', '\n').getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        Properties prop = new Properties();
        try {
            prop.load(is);
            int width = Integer.parseInt(prop.getProperty("width"));
            int height = Integer.parseInt(prop.getProperty("height"));
            int x = 0;
            try {
                x = Integer.parseInt(prop.getProperty("x"));
            }
            catch (Exception e) {
                x = 0;
            }
            int y = 0;
            try {
                y = Integer.parseInt(prop.getProperty("y"));
            }
            catch (Exception e) {
                y = 0;
            }
            int autoSize = 0;
            try {
                autoSize = Integer.valueOf(prop.getProperty("autoSize"));
            }
            catch (Exception e) {
                autoSize = 0;
            }
            SmartLayoutData data = new SmartLayoutData();
            data.x = x;
            data.y = y;
            data.width = width;
            data.height = height;
            data.autoSize = autoSize;
            return data;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error format");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("x=" + this.x);
        sb.append(";y=" + this.y);
        sb.append(";width=" + this.width);
        sb.append(";height=" + this.height);
        sb.append(";autoSize=" + this.autoSize);
        return sb.toString();
    }

    public boolean equals(Object data) {
        if (!(data instanceof SmartLayoutData)) {
            return false;
        }
        SmartLayoutData sld = (SmartLayoutData)data;
        return this.x == sld.x && this.y == sld.y && this.width == sld.width && this.height == sld.height && this.autoSize == sld.autoSize;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException();
        }
    }
}

