/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.tablelayout;

import java.io.Serializable;
import org.apache.log4j.Logger;

public class TableData
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(TableData.class);
    public int verticalAlignment = 2;
    public int horizontalAlignment = 1;
    public int widthHint = -1;
    public int heightHint = -1;
    public static final int PIXEL = 0;
    public static final int PERCENTAGE = 1;
    public static final int STAR = 2;
    public static final String PIXEL_TEXT = "pixel";
    public static final String PERCENTAGE_TEXT = "percentage";
    public static final String STAR_TEXT = "*";
    public int widthType = 0;
    public String width = "";
    public String height = "";
    public int horizontalIndent = 0;
    public int horizontalSpan = 1;
    public int verticalSpan = 1;
    public boolean grabExcessHorizontalSpace = false;
    public boolean grabExcessVerticalSpace = false;
    public static final int BEGINNING = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int FILL = 4;
    public static final int VERTICAL_ALIGN_BEGINNING = 2;
    public static final int VERTICAL_ALIGN_CENTER = 4;
    public static final int VERTICAL_ALIGN_END = 8;
    public static final int VERTICAL_ALIGN_FILL = 16;
    public static final int HORIZONTAL_ALIGN_BEGINNING = 32;
    public static final int HORIZONTAL_ALIGN_CENTER = 64;
    public static final int HORIZONTAL_ALIGN_END = 128;
    public static final int HORIZONTAL_ALIGN_FILL = 256;
    public static final int GRAB_HORIZONTAL = 512;
    public static final int GRAB_VERTICAL = 1024;
    public static final int FILL_VERTICAL = 1040;
    public static final int FILL_HORIZONTAL = 768;
    public static final int FILL_BOTH = 1808;
    public int cacheWidth = -1;
    public int cacheHeight = -1;
    public int[][] cache = new int[2][4];
    public int cacheIndex = -1;

    public TableData() {
        this.setStyle(272);
    }

    public TableData(int wHint, int hHint, int hSpan, int vSpan, String width, String height, int widthType) {
        this.setStyle(272);
        this.setData(wHint, hHint, hSpan, vSpan, width, height, widthType);
    }

    public void setData(int wHint, int hHint, int hSpan, int vSpan, String width, String height, int widthType) {
        this.widthHint = wHint;
        this.heightHint = hHint;
        this.horizontalSpan = hSpan;
        this.verticalSpan = vSpan;
        this.width = width;
        this.height = height;
        this.widthType = widthType;
    }

    public void setStyle(int style) {
        if ((style & 2) != 0) {
            this.verticalAlignment = 1;
        }
        if ((style & 4) != 0) {
            this.verticalAlignment = 2;
        }
        if ((style & 0x10) != 0) {
            this.verticalAlignment = 4;
        }
        if ((style & 8) != 0) {
            this.verticalAlignment = 3;
        }
        if ((style & 0x20) != 0) {
            this.horizontalAlignment = 1;
        }
        if ((style & 0x40) != 0) {
            this.horizontalAlignment = 2;
        }
        if ((style & 0x100) != 0) {
            this.horizontalAlignment = 4;
        }
        if ((style & 0x80) != 0) {
            this.horizontalAlignment = 3;
        }
        this.grabExcessHorizontalSpace = (style & 0x200) != 0;
        this.grabExcessVerticalSpace = (style & 0x400) != 0;
    }

    public void flushCache() {
        this.cacheHeight = -1;
        this.cacheWidth = -1;
        this.cacheIndex = -1;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public static TableData parse(String data) {
        String[] parm;
        if (data != null && !data.trim().equals("") && (parm = data.split(",")).length == 7) {
            try {
                TableData tableData = new TableData();
                tableData.width = parm[0].substring(parm[0].indexOf("=") + 1).trim();
                tableData.height = parm[1].substring(parm[1].indexOf("=") + 1).trim();
                tableData.horizontalSpan = Integer.valueOf(parm[2].substring(parm[2].indexOf("=") + 1).trim());
                tableData.verticalSpan = Integer.valueOf(parm[3].substring(parm[3].indexOf("=") + 1).trim());
                tableData.widthHint = Integer.valueOf(parm[4].substring(parm[4].indexOf("=") + 1).trim());
                tableData.heightHint = Integer.valueOf(parm[5].substring(parm[5].indexOf("=") + 1).trim());
                tableData.widthType = TableData.convertWidthType2Int(parm[6].substring(parm[6].indexOf("=") + 1).trim());
                return tableData;
            }
            catch (Exception e) {
                logger.warn((Object)"warn: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static int convertWidthType2Int(String type) {
        if (PIXEL_TEXT.equals(type)) {
            return 0;
        }
        if (PERCENTAGE_TEXT.equals(type)) {
            return 1;
        }
        if (STAR_TEXT.equals(type)) {
            return 2;
        }
        return 0;
    }

    public static String convertWidthType2String(int type) {
        switch (type) {
            case 0: {
                return PIXEL_TEXT;
            }
            case 1: {
                return PERCENTAGE_TEXT;
            }
            case 2: {
                return STAR_TEXT;
            }
        }
        return PIXEL_TEXT;
    }

    public String toString() {
        String wtype = "widthType=" + TableData.convertWidthType2String(this.widthType);
        String ts = "width=" + this.width + ",height=" + this.height + ",hspan=" + this.horizontalSpan + ",vspan=" + this.verticalSpan + ",wHint=" + this.widthHint + ",hHint=" + this.heightHint + "," + wtype;
        return ts;
    }
}

