/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.layout;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.layout.JSONUtils;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.bos.ui.layout.StringPropertyValue;
import com.kingdee.bos.ui.layout.UIComponentConfigInfo;
import com.kingdee.bos.ui.layout.UIKDMenuConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTabbedPaneConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTableConfigInfo;
import com.kingdee.bos.ui.layout.UIKDToolbarConfigInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UILayoutConfigInfo
implements Serializable {
    StringPropertyValue packagepath = new StringPropertyValue("package");
    StringPropertyValue name = new StringPropertyValue("name");
    StringPropertyValue alias = new StringPropertyValue("alias");
    StringPropertyValue title = new StringPropertyValue("title");
    List mainpanel;
    List kdtables;
    List kdtabbedpanes;
    List kdtoolbars;
    List kdmenus;

    public UILayoutConfigInfo(String packagepath, String name, String alias) {
        this.packagepath.setValue(packagepath);
        this.name.setValue(name);
        this.alias.setValue(alias);
        this.mainpanel = new ArrayList();
        this.kdtables = new ArrayList();
        this.kdtabbedpanes = new ArrayList();
        this.kdtoolbars = new ArrayList();
        this.kdmenus = new ArrayList();
    }

    public void addMainPanelComponentConfig(UIComponentConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.mainpanel.iterator();
        while (iter.hasNext()) {
            UIComponentConfigInfo info = (UIComponentConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.mainpanel.add(com);
    }

    public List getMainPanelComponentConfig() {
        return this.mainpanel;
    }

    public void addKDTableConfig(UIKDTableConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.kdtables.iterator();
        while (iter.hasNext()) {
            UIKDTableConfigInfo info = (UIKDTableConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.kdtables.add(com);
    }

    public List getKDTableConfigInfo() {
        return this.kdtables;
    }

    public void addKDTabbedPaneConfig(UIKDTabbedPaneConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.kdtabbedpanes.iterator();
        while (iter.hasNext()) {
            UIKDTabbedPaneConfigInfo info = (UIKDTabbedPaneConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.kdtabbedpanes.add(com);
    }

    public List getKDTabbedPaneConfigInfo() {
        return this.kdtabbedpanes;
    }

    public void addKDToolbarConfig(UIKDToolbarConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.kdtoolbars.iterator();
        while (iter.hasNext()) {
            UIKDToolbarConfigInfo info = (UIKDToolbarConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.kdtoolbars.add(com);
    }

    public List getKDToolbarConfigInfo() {
        return this.kdtoolbars;
    }

    public void addKDMenuConfig(UIKDMenuConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.kdmenus.iterator();
        while (iter.hasNext()) {
            UIKDMenuConfigInfo info = (UIKDMenuConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.kdmenus.add(com);
    }

    public List getKDMenuConfigInfo() {
        return this.kdmenus;
    }

    public UIComponentConfigInfo getUIComponentConfigInfo(String name) {
        int size = this.mainpanel.size();
        for (int i = 0; i < size; ++i) {
            UIComponentConfigInfo com = (UIComponentConfigInfo)this.mainpanel.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public UIKDTableConfigInfo getKDTableConfigInfo(String name) {
        int size = this.kdtables.size();
        for (int i = 0; i < size; ++i) {
            UIKDTableConfigInfo com = (UIKDTableConfigInfo)this.kdtables.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public UIKDTabbedPaneConfigInfo getKDTabbedPaneConfig(String name) {
        int size = this.kdtabbedpanes.size();
        for (int i = 0; i < size; ++i) {
            UIKDTabbedPaneConfigInfo com = (UIKDTabbedPaneConfigInfo)this.kdtabbedpanes.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public UIKDToolbarConfigInfo getKDToolbarConfig(String name) {
        int size = this.kdtoolbars.size();
        for (int i = 0; i < size; ++i) {
            UIKDToolbarConfigInfo com = (UIKDToolbarConfigInfo)this.kdtoolbars.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public UIKDMenuConfigInfo getKDMenuConfig(String name) {
        int size = this.kdmenus.size();
        for (int i = 0; i < size; ++i) {
            UIKDMenuConfigInfo com = (UIKDMenuConfigInfo)this.kdmenus.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public JSONObject toJSONObject() throws Exception {
        JSONObject base = new JSONObject();
        if (!this.packagepath.isNull()) {
            base.put(this.packagepath.getKey(), this.packagepath.getStringValue());
        }
        if (!this.name.isNull()) {
            base.put(this.name.getKey(), this.name.getStringValue());
        }
        if (!this.alias.isNull()) {
            base.put(this.alias.getKey(), this.alias.getStringValue());
        }
        if (!this.title.isNull()) {
            base.put(this.title.getKey(), this.title.getStringValue());
        }
        ArrayList<Map> list = new ArrayList<Map>(this.mainpanel.size());
        for (UIComponentConfigInfo com : this.mainpanel) {
            list.add(com.toMap());
        }
        base.put("mainpanel", list);
        ArrayList<Map> list2 = new ArrayList<Map>(this.kdtables.size());
        for (UIKDTableConfigInfo com : this.kdtables) {
            list2.add(com.toMap());
        }
        base.put("kdtables", list2);
        ArrayList<Map> list3 = new ArrayList<Map>(this.kdtabbedpanes.size());
        for (UIKDTabbedPaneConfigInfo com : this.kdtabbedpanes) {
            list3.add(com.toMap());
        }
        base.put("kdtabbedpanes", list3);
        ArrayList<Map> list4 = new ArrayList<Map>(this.kdtoolbars.size());
        for (UIKDToolbarConfigInfo com : this.kdtoolbars) {
            list4.add(com.toMap());
        }
        base.put("kdtoolbars", list4);
        ArrayList<Map> list5 = new ArrayList<Map>(this.kdmenus.size());
        for (UIKDMenuConfigInfo com : this.kdmenus) {
            list5.add(com.toMap());
        }
        base.put("kdmenus", list5);
        return base;
    }

    public boolean isEmpty() {
        return this.kdmenus.isEmpty() && this.kdtabbedpanes.isEmpty() && this.kdtables.isEmpty() && this.kdtoolbars.isEmpty() && this.mainpanel.isEmpty();
    }

    public static UILayoutConfigInfo toUILayoutConfigInfo(String json) throws Exception {
        String name;
        Serializable com;
        JSONObject obj;
        int i;
        int size;
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        JSONObject base = new JSONObject(json);
        UILayoutConfigInfo info = new UILayoutConfigInfo(JSONUtils.getString(base, "package"), JSONUtils.getString(base, "name"), JSONUtils.getString(base, "alias"));
        info.setTitle(JSONUtils.getString(base, "title"));
        JSONArray array = JSONUtils.getJSONArray(base, "mainpanel");
        if (array != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new UIComponentConfigInfo();
                name = JSONUtils.getString(obj, ((UIComponentConfigInfo)com).getName().getKey());
                String container = JSONUtils.getString(obj, ((UIComponentConfigInfo)com).getContainer().getKey());
                String constraint = JSONUtils.getString(obj, ((UIComponentConfigInfo)com).getConstraint().getKey());
                String labelText = JSONUtils.getString(obj, ((UIComponentConfigInfo)com).getLabelText().getKey());
                Integer labelLength = JSONUtils.getIntger(obj, ((UIComponentConfigInfo)com).getLabelLength().getKey());
                Integer labelAlign = JSONUtils.getIntger(obj, ((UIComponentConfigInfo)com).getLabelAlign().getKey());
                Boolean labelUnderline = JSONUtils.getBoolean(obj, ((UIComponentConfigInfo)com).getLabelUnderline().getKey());
                if (name == null) continue;
                ((UIComponentConfigInfo)com).setName(name);
                if (container != null) {
                    ((UIComponentConfigInfo)com).setContainer(container);
                }
                if (constraint != null) {
                    ((UIComponentConfigInfo)com).setConstraint(KDRectangle.toKDRectangle(constraint));
                }
                if (labelText != null) {
                    ((UIComponentConfigInfo)com).setLabelText(labelText);
                }
                if (labelLength != null) {
                    ((UIComponentConfigInfo)com).setLabelLength(labelLength);
                }
                if (labelAlign != null) {
                    ((UIComponentConfigInfo)com).setLabelAlign(labelAlign);
                }
                if (labelUnderline != null) {
                    ((UIComponentConfigInfo)com).setLabelUnderline(labelUnderline);
                }
                info.addMainPanelComponentConfig((UIComponentConfigInfo)com);
            }
        }
        if ((array = JSONUtils.getJSONArray(base, "kdtables")) != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new UIKDTableConfigInfo();
                name = JSONUtils.getString(obj, ((UIKDTableConfigInfo)com).getName().getKey());
                String columnOrder = JSONUtils.getString(obj, ((UIKDTableConfigInfo)com).getColumnOrder().getKey());
                if (name == null) continue;
                ((UIKDTableConfigInfo)com).setName(name);
                if (columnOrder != null) {
                    ((UIKDTableConfigInfo)com).setColumnOrder(columnOrder);
                }
                info.addKDTableConfig((UIKDTableConfigInfo)com);
            }
        }
        if ((array = JSONUtils.getJSONArray(base, "kdtabbedpanes")) != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new UIKDTabbedPaneConfigInfo();
                name = JSONUtils.getString(obj, ((UIKDTabbedPaneConfigInfo)com).getName().getKey());
                String tabOrder = JSONUtils.getString(obj, ((UIKDTabbedPaneConfigInfo)com).getTabOrder().getKey());
                if (name == null) continue;
                ((UIKDTabbedPaneConfigInfo)com).setName(name);
                if (tabOrder != null) {
                    ((UIKDTabbedPaneConfigInfo)com).setTabOrder(tabOrder);
                }
                info.addKDTabbedPaneConfig((UIKDTabbedPaneConfigInfo)com);
            }
        }
        if ((array = JSONUtils.getJSONArray(base, "kdtoolbars")) != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new UIKDToolbarConfigInfo();
                name = JSONUtils.getString(obj, ((UIKDToolbarConfigInfo)com).getName().getKey());
                String toolbarOrder = JSONUtils.getString(obj, ((UIKDToolbarConfigInfo)com).getToolbarOrder().getKey());
                if (name == null) continue;
                ((UIKDToolbarConfigInfo)com).setName(name);
                if (toolbarOrder != null) {
                    ((UIKDToolbarConfigInfo)com).setToolbarOrder(toolbarOrder);
                }
                info.addKDToolbarConfig((UIKDToolbarConfigInfo)com);
            }
        }
        if ((array = JSONUtils.getJSONArray(base, "kdmenus")) != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new UIKDMenuConfigInfo();
                name = JSONUtils.getString(obj, ((UIKDMenuConfigInfo)com).getName().getKey());
                String menuOrder = JSONUtils.getString(obj, ((UIKDMenuConfigInfo)com).getMenuOrder().getKey());
                if (name == null) continue;
                ((UIKDMenuConfigInfo)com).setName(name);
                if (menuOrder != null) {
                    ((UIKDMenuConfigInfo)com).setMenuOrder(menuOrder);
                }
                info.addKDMenuConfig((UIKDMenuConfigInfo)com);
            }
        }
        return info;
    }

    public String getTitle() {
        return this.title.getValue();
    }

    public void setTitle(String title) {
        this.title.setValue(title);
    }
}

