/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.layout;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.layout.JSONUtils;
import com.kingdee.bos.ui.layout.StringPropertyValue;
import com.kingdee.bos.ui.layout.WebDataGridConfigInfo;
import com.kingdee.bos.ui.layout.WebTabbedPaneConfigInfo;
import com.kingdee.bos.ui.layout.WebUIComponentConfigInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebUILayoutConfigInfo
implements Serializable {
    StringPropertyValue packagepath = new StringPropertyValue("package");
    StringPropertyValue name = new StringPropertyValue("name");
    StringPropertyValue alias = new StringPropertyValue("alias");
    List mainpanel;
    List datagrids;
    List tabbedpanes;

    public WebUILayoutConfigInfo(String packagepath, String name, String alias) {
        this.packagepath.setValue(packagepath);
        this.name.setValue(name);
        this.alias.setValue(alias);
        this.mainpanel = new ArrayList();
        this.datagrids = new ArrayList();
        this.tabbedpanes = new ArrayList();
    }

    public void addMainPanelComponentConfig(WebUIComponentConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.mainpanel.iterator();
        while (iter.hasNext()) {
            WebUIComponentConfigInfo info = (WebUIComponentConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.mainpanel.add(com);
    }

    public List getMainPanelComponentConfig() {
        return this.mainpanel;
    }

    public void addDataGridConfig(WebDataGridConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.datagrids.iterator();
        while (iter.hasNext()) {
            WebDataGridConfigInfo info = (WebDataGridConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.datagrids.add(com);
    }

    public List getDataGridConfigInfo() {
        return this.datagrids;
    }

    public void addTabbedPaneConfig(WebTabbedPaneConfigInfo com) {
        if (com == null) {
            return;
        }
        Iterator iter = this.tabbedpanes.iterator();
        while (iter.hasNext()) {
            WebTabbedPaneConfigInfo info = (WebTabbedPaneConfigInfo)iter.next();
            if (info.getName().isNull() || !info.getName().getValue().equals(com.getName().getValue())) continue;
            iter.remove();
        }
        this.tabbedpanes.add(com);
    }

    public List getKDTabbedPaneConfigInfo() {
        return this.tabbedpanes;
    }

    public WebUIComponentConfigInfo getWebUIComponentConfigInfo(String name) {
        int size = this.mainpanel.size();
        for (int i = 0; i < size; ++i) {
            WebUIComponentConfigInfo com = (WebUIComponentConfigInfo)this.mainpanel.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public WebDataGridConfigInfo getDataGridConfigInfo(String name) {
        int size = this.datagrids.size();
        for (int i = 0; i < size; ++i) {
            WebDataGridConfigInfo com = (WebDataGridConfigInfo)this.datagrids.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public WebTabbedPaneConfigInfo getTabbedPaneConfig(String name) {
        int size = this.tabbedpanes.size();
        for (int i = 0; i < size; ++i) {
            WebTabbedPaneConfigInfo com = (WebTabbedPaneConfigInfo)this.tabbedpanes.get(i);
            if (com.getName().isNull() || !com.getName().getStringValue().equals(name)) continue;
            return com;
        }
        return null;
    }

    public JSONObject toJSONObject() throws Exception {
        JSONObject base = new JSONObject();
        if (!this.packagepath.isNull()) {
            base.put(this.packagepath.getKey(), this.packagepath.getStringValue());
        }
        if (!this.name.isNull()) {
            base.put(this.name.getKey(), this.name.getStringValue());
        }
        if (!this.alias.isNull()) {
            base.put(this.alias.getKey(), this.alias.getStringValue());
        }
        ArrayList<Map> list = new ArrayList<Map>(this.mainpanel.size());
        for (WebUIComponentConfigInfo com : this.mainpanel) {
            list.add(com.toMap());
        }
        base.put("mainpanel", list);
        ArrayList<Map> list2 = new ArrayList<Map>(this.datagrids.size());
        for (WebDataGridConfigInfo com : this.datagrids) {
            list2.add(com.toMap());
        }
        base.put("datagrids", list2);
        ArrayList<Map> list3 = new ArrayList<Map>(this.tabbedpanes.size());
        for (WebTabbedPaneConfigInfo com : this.tabbedpanes) {
            list3.add(com.toMap());
        }
        base.put("tabbedpanes", list3);
        return base;
    }

    public static WebUILayoutConfigInfo toUILayoutConfigInfo(String json) throws Exception {
        String name;
        Serializable com;
        JSONObject obj;
        int i;
        int size;
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        JSONObject base = new JSONObject(json);
        WebUILayoutConfigInfo info = new WebUILayoutConfigInfo(JSONUtils.getString(base, "package"), JSONUtils.getString(base, "name"), JSONUtils.getString(base, "alias"));
        JSONArray array = JSONUtils.getJSONArray(base, "mainpanel");
        if (array != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new WebUIComponentConfigInfo();
                name = JSONUtils.getString(obj, ((WebUIComponentConfigInfo)com).getName().getKey());
                String container = JSONUtils.getString(obj, ((WebUIComponentConfigInfo)com).getContainer().getKey());
                String constraint = JSONUtils.getString(obj, ((WebUIComponentConfigInfo)com).getConstraint().getKey());
                String labelText = JSONUtils.getString(obj, ((WebUIComponentConfigInfo)com).getLabelText().getKey());
                Integer labelLength = JSONUtils.getIntger(obj, ((WebUIComponentConfigInfo)com).getLabelLength().getKey());
                if (JSONUtils.getBoolean(obj, ((WebUIComponentConfigInfo)com).isVisable().getKey()) != null) {
                    boolean visable = JSONUtils.getBoolean(obj, ((WebUIComponentConfigInfo)com).isVisable().getKey());
                    ((WebUIComponentConfigInfo)com).setVisable(visable);
                }
                if (name == null) continue;
                ((WebUIComponentConfigInfo)com).setName(name);
                if (container != null) {
                    ((WebUIComponentConfigInfo)com).setContainer(container);
                }
                if (constraint != null) {
                    ((WebUIComponentConfigInfo)com).setConstraint(constraint);
                }
                if (labelText != null) {
                    ((WebUIComponentConfigInfo)com).setLabelText(labelText);
                }
                if (labelLength != null) {
                    ((WebUIComponentConfigInfo)com).setLabelLength(labelLength);
                }
                info.addMainPanelComponentConfig((WebUIComponentConfigInfo)com);
            }
        }
        if ((array = JSONUtils.getJSONArray(base, "datagrids")) != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new WebDataGridConfigInfo();
                name = JSONUtils.getString(obj, ((WebDataGridConfigInfo)com).getName().getKey());
                String columnOrder = JSONUtils.getString(obj, ((WebDataGridConfigInfo)com).getColumnOrder().getKey());
                if (name == null) continue;
                ((WebDataGridConfigInfo)com).setName(name);
                if (columnOrder != null) {
                    ((WebDataGridConfigInfo)com).setColumnOrder(columnOrder);
                }
                info.addDataGridConfig((WebDataGridConfigInfo)com);
            }
        }
        if ((array = JSONUtils.getJSONArray(base, "tabbedpanes")) != null) {
            size = array.length();
            for (i = 0; i < size; ++i) {
                obj = array.getJSONObject(i);
                com = new WebTabbedPaneConfigInfo();
                name = JSONUtils.getString(obj, ((WebTabbedPaneConfigInfo)com).getName().getKey());
                String tabOrder = JSONUtils.getString(obj, ((WebTabbedPaneConfigInfo)com).getTabOrder().getKey());
                if (name == null) continue;
                ((WebTabbedPaneConfigInfo)com).setName(name);
                if (tabOrder != null) {
                    ((WebTabbedPaneConfigInfo)com).setTabOrder(tabOrder);
                }
                info.addTabbedPaneConfig((WebTabbedPaneConfigInfo)com);
            }
        }
        return info;
    }
}

