/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import java.security.InvalidKeyException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import kd.bos.ksql.DbType;
import kd.bos.ksql.dom.SqlCaseItem;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlAllColumnExpr;
import kd.bos.ksql.dom.expr.SqlBetweenExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCaseExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNotExpr;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.DrSQLFormater;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.parser.KeyWord;
import kd.bos.ksql.parser.SelectParser;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.util.Base64;
import kd.bos.ksql.util.Rijndael_Util;
import kd.bos.ksql.util.XUtil;
import kd.bos.util.DisCardUtil;
import org.apache.log4j.Logger;

public class KSqlUtil {
    public static final int KEY_WORD = 1;
    public static final int FUNCTION_NAME = 0;
    public static final int NOT_KW_FN = -1;
    public static final int OPTIMIZE_MODE_DISABLED = -1;
    public static final int OPTIMIZE_MODE_UNUSED = 0;
    public static final int OPTIMIZE_MODE_OUTER_JOIN = 1;
    public static final int OPTIMIZE_MODE_INNER_JOIN = 2;
    private static Logger log = Logger.getLogger((String)"kd.bos.ksql.KSqlUtil");
    private static final String BASE_KEY = "VUVvSjFBWUF0RjFaMEYyQXBFb0IyRllCMEVvSjBGWTMyRW5aMEJIRW1CMTYr";
    private static final byte[] kb = XUtil.hex2byte(XUtil.xDecode(Base64.decodeToString("VUVvSjFBWUF0RjFaMEYyQXBFb0IyRllCMEVvSjBGWTMyRW5aMEJIRW1CMTYr")));
    private static int optimizeMode = 1;
    private static boolean enableAutoChineseSort = false;
    private static List autoChineseSortFieldList = new ArrayList();
    private static boolean icuEnableInDb2 = false;
    private static boolean alterTableWithProcedureInDB2 = false;
    private static boolean autoReorgWhenAlterTableInDB2 = false;
    private static boolean icuInDb2UseCOLLATION_KEY_BIT = false;
    private static boolean supportPurge = true;
    private static Map methodTypeMap = new HashMap();
    public static final String OPTIONS_DBTYPE = "dbtype";
    public static final String OPTIONS_TRANSLATE = "translate";
    public static final String OPTIONS_TRACE = "trace";
    public static final String OPTIONS_FILTER = "filter";
    public static final String OPTIONS_TRACEFILE = "file";
    public static final String OPTIONS_NOLOGGING = "noLogging";
    public static final String OPTIONS_BINDPORT = "bindport";
    public static final String OPTIONS_OPTIMIZE = "optimize";
    public static final String OPTIONS_TEMPTABLESPACE = "temptablespace";
    public static final String OPTIONS_DBSCHEMA = "dbSchema";
    public static final String OPTIONS_TABLESCHEMA = "tableSchema";
    public static final int DEFAULT_LIFECYCLE = 0x6DDD00;

    public static void setOptimizeMode(int mode) {
    }

    public static int getOptimizeMode() {
        return optimizeMode;
    }

    public static void setEnableAutoChineseSort(boolean isEnableAutoChineseSort) {
        enableAutoChineseSort = isEnableAutoChineseSort;
    }

    public static boolean isEnableAutoChineseSort() {
        return enableAutoChineseSort;
    }

    public static List getAutoChineseSortFieldList() {
        return autoChineseSortFieldList;
    }

    public static void setAutoChineseSortFieldList(List autoChineseSortFiledList) {
        if (autoChineseSortFiledList == null) {
            autoChineseSortFieldList.clear();
        } else {
            autoChineseSortFieldList = autoChineseSortFiledList;
        }
    }

    public static void clearAutoChineseSortFieldList() {
        autoChineseSortFieldList.clear();
    }

    public static void addAutoChineseSortFieldList(String str) {
        if ((str = str.trim().toLowerCase()).length() == 0) {
            return;
        }
        if (!autoChineseSortFieldList.contains(str)) {
            autoChineseSortFieldList.add(str);
        }
    }

    public static void delAutoChineseSortFieldList(String str) {
        if ((str = str.trim().toLowerCase()).length() == 0) {
            return;
        }
        if (autoChineseSortFieldList.contains(str)) {
            autoChineseSortFieldList.remove(str);
        }
    }

    public static String AutoChineseSortField(String sql) throws ParserException {
        SelectParser parser = new SelectParser(sql);
        SqlSelectBase selectBase = parser.select();
        KSqlUtil.AutoChineseSortField(selectBase);
        return selectBase.toString();
    }

    public static void AutoChineseSortField(SqlSelectBase selectBase) {
        if (!KSqlUtil.isEnableAutoChineseSort() || autoChineseSortFieldList == null || autoChineseSortFieldList.size() == 0) {
            return;
        }
        if (selectBase == null || selectBase.orderBy == null || selectBase.orderBy.size() == 0) {
            return;
        }
        KSqlUtil.innerAutoChineseSortField(selectBase);
    }

    private static void innerAutoChineseSortField(SqlSelectBase selectBase) {
        if (selectBase instanceof SqlUnionSelect) {
            return;
        }
        if (selectBase instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)selectBase;
            HashMap<String, SqlExpr> selectItemAliasMap = new HashMap<String, SqlExpr>();
            for (SqlSelectItem selectItem : sqlSelect.selectList) {
                if (selectItem.alias == null || selectItem.alias.length() <= 0) continue;
                selectItemAliasMap.put(selectItem.alias.toLowerCase(), selectItem.expr);
            }
            HashMap tableItemAliasMap = new HashMap();
            String mainTable = KSqlUtil.innerAutoChineseSortField_tableSource(tableItemAliasMap, sqlSelect.tableSource);
            int len = sqlSelect.orderBy.size();
            for (int i = 0; i < len; ++i) {
                String name;
                Object expr2;
                Object val = sqlSelect.orderBy.get(i);
                if (!(val instanceof SqlOrderByItem)) continue;
                SqlOrderByItem sqlOrderByItem = (SqlOrderByItem)val;
                SqlExpr expr = sqlOrderByItem.expr;
                if (!KSqlUtil.isPropExpr(expr) && (expr2 = selectItemAliasMap.get(name = expr.toString().toLowerCase())) != null) {
                    expr = (SqlExpr)expr2;
                }
                String field = expr.toString();
                if (expr instanceof SqlBinaryOpExpr) {
                    SqlExpr expr22;
                    Object n2;
                    SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
                    if (binaryExpr.operator == 20 && (n2 = tableItemAliasMap.get((expr22 = binaryExpr.left).toString().toLowerCase())) != null) {
                        field = n2 + "." + binaryExpr.right;
                    }
                }
                if (field.indexOf(".") < 0 && mainTable != null && tableItemAliasMap.size() <= 1) {
                    field = mainTable + "." + field;
                }
                if (!autoChineseSortFieldList.contains(field.toLowerCase())) continue;
                sqlOrderByItem.chineseOrderByMode = 2;
                sqlOrderByItem.setOrgChineseOrderByType("SCHINESE_PINYIN");
            }
        }
    }

    private static String innerAutoChineseSortField_tableSource(Map tableItemAliasMap, SqlTableSourceBase tableSource) {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource sqlTableSource = (SqlTableSource)tableSource;
            if (sqlTableSource.alias != null && sqlTableSource.alias.length() > 0) {
                tableItemAliasMap.put(sqlTableSource.alias.toLowerCase(), sqlTableSource.name);
            }
            return sqlTableSource.name;
        }
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource sqlJoinedTableSource = (SqlJoinedTableSource)tableSource;
            KSqlUtil.innerAutoChineseSortField_tableSource(tableItemAliasMap, sqlJoinedTableSource.left);
            KSqlUtil.innerAutoChineseSortField_tableSource(tableItemAliasMap, sqlJoinedTableSource.right);
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            DisCardUtil.discard();
        }
        return null;
    }

    public static void printResultSet(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colLen = rsMeta.getColumnCount();
        for (i = 1; i <= colLen; ++i) {
            String colName = rsMeta.getColumnName(i);
            if (i != 1) {
                log.info((Object)"    ");
            }
            log.info((Object)colName);
        }
        log.info((Object)"");
        while (rs.next()) {
            for (i = 1; i <= colLen; ++i) {
                int dateType = rsMeta.getColumnType(i);
                Object o = rs.getObject(i);
                if (i != 1) {
                    log.info((Object)"    ");
                }
                if (dateType == 93) {
                    Timestamp time = rs.getTimestamp(i);
                    if (time != null) {
                        log.info((Object)DateFormat.getDateTimeInstance().format(time));
                        continue;
                    }
                    log.info((Object)"<NULL>");
                    continue;
                }
                log.info(o);
            }
            log.info((Object)"");
        }
    }

    public static String optimize(String sql, int optimizeMode) throws SqlTranslateException {
        String oSql = KSqlUtil.singleOptimize(sql, optimizeMode);
        String nSql = KSqlUtil.singleOptimize(oSql, optimizeMode);
        while (!nSql.equals(oSql)) {
            oSql = nSql;
            nSql = KSqlUtil.singleOptimize(oSql, optimizeMode);
        }
        return nSql;
    }

    public static String optimize(String sql) throws SqlTranslateException {
        return KSqlUtil.optimize(sql, optimizeMode);
    }

    public static String optimize(Object sqlObject) throws SqlTranslateException {
        return KSqlUtil.optimize(String.valueOf(sqlObject));
    }

    public static String optimize(Object sqlObject, int optimizeMode) throws SqlTranslateException {
        return KSqlUtil.optimize(String.valueOf(sqlObject), optimizeMode);
    }

    private static String singleOptimize(String sql, int mode) throws SqlTranslateException {
        if (mode == -1) {
            return sql;
        }
        SelectParser parser = new SelectParser(sql);
        SqlSelectBase selectBase = parser.select();
        KSqlUtil.optimize_selectbase(selectBase, mode);
        StringBuilder buff = new StringBuilder();
        new DrSQLFormater(buff).formatSelectBase(selectBase);
        return buff.toString();
    }

    public static Map adjust(SqlSelect select) throws ParserException {
        return KSqlUtil.adjust(select, optimizeMode);
    }

    static Map adjust(SqlSelect select, int mode) throws ParserException {
        int i;
        HashMap<String, SqlExpr> selectItemAliasMap = new HashMap<String, SqlExpr>();
        for (SqlSelectItem selectItem : select.selectList) {
            if (selectItem.alias == null || selectItem.alias.length() <= 0) continue;
            selectItemAliasMap.put(selectItem.alias, selectItem.expr);
        }
        select.condition = KSqlUtil.adjust_replace(selectItemAliasMap, select.condition);
        for (SqlOrderByItem orderByItem : select.orderBy) {
            orderByItem.expr = KSqlUtil.adjust_replace(selectItemAliasMap, orderByItem.expr);
        }
        HashMap joinConditionExprCanReplaceMap = new HashMap();
        KSqlUtil.computeJoinConditionCanReplaceExprMap(joinConditionExprCanReplaceMap, select.tableSource, mode);
        int size = select.selectList.size();
        for (i = 0; i < size; ++i) {
            SqlSelectItem item = (SqlSelectItem)select.selectList.get(i);
            item.expr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, item.expr);
        }
        size = select.groupBy.size();
        for (i = 0; i < size; ++i) {
            SqlExpr expr = (SqlExpr)select.groupBy.get(i);
            expr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, expr);
            select.groupBy.set(i, expr);
        }
        select.having = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, select.having);
        KSqlUtil.replaceTableSourceJoinCondition(joinConditionExprCanReplaceMap, select.tableSource);
        select.condition = KSqlUtil.replace_for_Select_condition(joinConditionExprCanReplaceMap, select.condition);
        for (SqlOrderByItem orderByItem : select.orderBy) {
            orderByItem.expr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, orderByItem.expr);
            orderByItem.expr = KSqlUtil.replace_for_join_condition(selectItemAliasMap, orderByItem.expr);
        }
        return selectItemAliasMap;
    }

    private static SqlExpr replace_for_join_condition(Map joinConditionExprCanReplaceMap, SqlExpr expr) throws ParserException {
        if (expr == null) {
            return null;
        }
        if (expr instanceof SqlAllColumnExpr) {
            return expr;
        }
        if (expr instanceof SqlIdentifierExpr) {
            String exprStr = expr.toString();
            Object replaceToExprStr = joinConditionExprCanReplaceMap.get(exprStr.toUpperCase());
            if (replaceToExprStr != null) {
                return new SqlExprParser(replaceToExprStr.toString()).expr();
            }
        } else if (KSqlUtil.isPropExpr(expr)) {
            String exprStr = expr.toString();
            Object replaceToExprStr = joinConditionExprCanReplaceMap.get(exprStr.toUpperCase());
            if (replaceToExprStr != null) {
                return new SqlExprParser(replaceToExprStr.toString()).expr();
            }
        } else if (expr instanceof SqlBinaryOpExpr) {
            String rightStr;
            String leftStr;
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator != 20 && !(leftStr = binaryExpr.left.toString()).equalsIgnoreCase((String)joinConditionExprCanReplaceMap.get((rightStr = binaryExpr.right.toString()).toUpperCase())) && !rightStr.equalsIgnoreCase((String)joinConditionExprCanReplaceMap.get(leftStr.toUpperCase()))) {
                binaryExpr.left = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, binaryExpr.left);
            }
        } else if (expr instanceof SqlMethodInvokeExpr) {
            SqlMethodInvokeExpr methodInvokeExpr = (SqlMethodInvokeExpr)expr;
            int size = methodInvokeExpr.parameters.size();
            for (int i = 0; i < size; ++i) {
                SqlExpr pramExpr = (SqlExpr)methodInvokeExpr.parameters.get(i);
                pramExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, pramExpr);
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
        } else if (expr instanceof SqlAggregateExpr) {
            SqlAggregateExpr aggregateExpr = (SqlAggregateExpr)expr;
            int size = aggregateExpr.paramList.size();
            for (int i = 0; i < size; ++i) {
                SqlExpr pramExpr = (SqlExpr)aggregateExpr.paramList.get(i);
                pramExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, pramExpr);
                aggregateExpr.paramList.set(i, pramExpr);
            }
        } else if (expr instanceof SqlBetweenExpr) {
            SqlBetweenExpr betweenExpr = (SqlBetweenExpr)expr;
            betweenExpr.testExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, betweenExpr.testExpr);
            betweenExpr.beginExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, betweenExpr.beginExpr);
            betweenExpr.endExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, betweenExpr.endExpr);
        } else if (expr instanceof SqlCaseExpr) {
            SqlCaseExpr caseExpr = (SqlCaseExpr)expr;
            int size = caseExpr.itemList.size();
            for (int i = 0; i < size; ++i) {
                SqlCaseItem caseItem = (SqlCaseItem)caseExpr.itemList.get(i);
                caseItem.conditionExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, caseItem.conditionExpr);
                caseItem.valueExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, caseItem.valueExpr);
            }
            caseExpr.valueExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, caseExpr.valueExpr);
            caseExpr.elseExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, caseExpr.elseExpr);
        } else if (expr instanceof SqlInListExpr) {
            SqlInListExpr inListExpr = (SqlInListExpr)expr;
            inListExpr.expr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, inListExpr.expr);
            int size = inListExpr.targetList.size();
            for (int i = 0; i < size; ++i) {
                SqlExpr targetExpr = (SqlExpr)inListExpr.targetList.get(i);
                targetExpr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, targetExpr);
                inListExpr.targetList.set(i, targetExpr);
            }
        } else if (expr instanceof SqlInSubQueryExpr) {
            SqlInSubQueryExpr inExpr = (SqlInSubQueryExpr)expr;
            inExpr.expr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, inExpr.expr);
        } else if (expr instanceof SqlNotExpr) {
            SqlNotExpr notExpr = (SqlNotExpr)expr;
            notExpr.expr = KSqlUtil.replace_for_join_condition(joinConditionExprCanReplaceMap, notExpr.expr);
        }
        return expr;
    }

    private static void replaceTableSourceJoinCondition(Map joinConditionExprMap, SqlTableSourceBase tabSrcBase) throws ParserException {
        if (tabSrcBase instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinTabSrc = (SqlJoinedTableSource)tabSrcBase;
            joinTabSrc.condition = KSqlUtil.replace_for_join_condition(joinConditionExprMap, joinTabSrc.condition);
            KSqlUtil.replaceTableSourceJoinCondition(joinConditionExprMap, joinTabSrc.left);
            KSqlUtil.replaceTableSourceJoinCondition(joinConditionExprMap, joinTabSrc.right);
        }
    }

    private static void computeJoinConditionCanReplaceExprMap(Map joinConditionExprCanReplaceMap, SqlTableSourceBase tabSrcBase, int mode) {
        if (tabSrcBase instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinTabSrc = (SqlJoinedTableSource)tabSrcBase;
            if (joinTabSrc.joinType == 1) {
                KSqlUtil.computeLeftJoinConditionCanReplaceExprMap(joinConditionExprCanReplaceMap, joinTabSrc);
            }
            if (joinTabSrc.joinType == 0 && mode > 1) {
                KSqlUtil.computeInnerJoinConditionCanReplaceExprMap(joinConditionExprCanReplaceMap, joinTabSrc);
            }
            KSqlUtil.computeJoinConditionCanReplaceExprMap(joinConditionExprCanReplaceMap, joinTabSrc.left, mode);
            KSqlUtil.computeJoinConditionCanReplaceExprMap(joinConditionExprCanReplaceMap, joinTabSrc.right, mode);
        }
    }

    private static void computeLeftJoinConditionCanReplaceExprMap(Map joinConditionExprCanReplaceMap, SqlJoinedTableSource joinTabSrc) {
        if (KSqlUtil.isSimpleJoinCondition(joinTabSrc.condition)) {
            String canReplaceToExprStr;
            String exprStr;
            String rightTabName;
            SqlExpr left = ((SqlBinaryOpExpr)joinTabSrc.condition).left;
            SqlExpr right = ((SqlBinaryOpExpr)joinTabSrc.condition).right;
            String alias = joinTabSrc.right.alias;
            if (alias == null && joinTabSrc.right instanceof SqlTableSource && (alias = ((SqlTableSource)joinTabSrc.right).alias) == null) {
                alias = ((SqlTableSource)joinTabSrc.right).name;
            }
            if ((rightTabName = KSqlUtil.getProperOwnerString(right)) != null && rightTabName.equalsIgnoreCase(alias)) {
                exprStr = right.toString();
                canReplaceToExprStr = left.toString();
            } else {
                exprStr = left.toString();
                canReplaceToExprStr = right.toString();
            }
            String str = (String)joinConditionExprCanReplaceMap.get(canReplaceToExprStr);
            if (str != null) {
                canReplaceToExprStr = str;
            }
            HashMap<String, String> newMap = new HashMap<String, String>();
            Iterator iter = joinConditionExprCanReplaceMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (!val.equalsIgnoreCase(exprStr)) continue;
                newMap.put(key.toUpperCase(), canReplaceToExprStr);
                iter.remove();
            }
            joinConditionExprCanReplaceMap.put(exprStr.toUpperCase(), canReplaceToExprStr);
            joinConditionExprCanReplaceMap.putAll(newMap);
        }
    }

    private static void computeInnerJoinConditionCanReplaceExprMap(Map joinConditionExprCanReplaceMap, SqlJoinedTableSource joinTabSrc) {
        if (KSqlUtil.isSimpleJoinCondition(joinTabSrc.condition)) {
            String canReplaceToExprStr;
            String exprStr;
            String rightTabName;
            SqlExpr left = ((SqlBinaryOpExpr)joinTabSrc.condition).left;
            SqlExpr right = ((SqlBinaryOpExpr)joinTabSrc.condition).right;
            String alias = joinTabSrc.right.alias;
            if (alias == null && joinTabSrc.right instanceof SqlTableSource && (alias = ((SqlTableSource)joinTabSrc.right).alias) == null) {
                alias = ((SqlTableSource)joinTabSrc.right).name;
            }
            if ((rightTabName = KSqlUtil.getProperOwnerString(right)) != null && rightTabName.equalsIgnoreCase(alias)) {
                exprStr = right.toString();
                canReplaceToExprStr = left.toString();
            } else {
                exprStr = left.toString();
                canReplaceToExprStr = right.toString();
            }
            String str = (String)joinConditionExprCanReplaceMap.get(canReplaceToExprStr);
            if (str != null) {
                canReplaceToExprStr = str;
            }
            HashMap<String, String> newMap = new HashMap<String, String>();
            Iterator iter = joinConditionExprCanReplaceMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (!val.equalsIgnoreCase(exprStr)) continue;
                newMap.put(key.toUpperCase(), canReplaceToExprStr);
                iter.remove();
            }
            joinConditionExprCanReplaceMap.put(exprStr.toUpperCase(), canReplaceToExprStr);
            joinConditionExprCanReplaceMap.putAll(newMap);
        }
    }

    private static boolean isSimpleJoinCondition(SqlExpr expr) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator == 10) {
                SqlExpr left = binaryExpr.left;
                SqlExpr right = binaryExpr.right;
                return KSqlUtil.isPropExpr(left) && KSqlUtil.isPropExpr(right);
            }
        }
        return false;
    }

    private static boolean isPropExpr(SqlExpr expr) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator == 20) {
                return true;
            }
        }
        return false;
    }

    private static String getProperOwnerString(SqlExpr expr) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator == 20 && binaryExpr.left instanceof SqlIdentifierExpr) {
                SqlIdentifierExpr identExpr = (SqlIdentifierExpr)binaryExpr.left;
                return identExpr.value;
            }
        }
        return null;
    }

    private static SqlExpr adjust_replace(Map exprAliasMap, SqlExpr expr) {
        String ident;
        SqlExpr sqlexpr;
        if (expr == null) {
            return null;
        }
        if (expr instanceof SqlAllColumnExpr) {
            return expr;
        }
        if (expr instanceof SqlIdentifierExpr && (sqlexpr = (SqlExpr)exprAliasMap.get(ident = ((SqlIdentifierExpr)expr).value)) != null) {
            return sqlexpr;
        }
        return expr;
    }

    public static void optimize(SqlSelect select) {
        KSqlUtil.optimize(select, optimizeMode);
    }

    private static void optimize(SqlSelect select, int mode) {
        Map selectItemAliasMap = null;
        try {
            selectItemAliasMap = KSqlUtil.adjust(select, mode);
            KSqlUtil.optimize_table_source(select.tableSource, mode);
        }
        catch (ParserException e) {
            log.warn((Object)e.getMessage());
        }
        HashSet usedTableAliasSet = new HashSet();
        Iterator iter = select.selectList.iterator();
        boolean hasCanNotOptimizeExpr = false;
        while (iter.hasNext()) {
            SqlSelectItem selectItem = (SqlSelectItem)iter.next();
            hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, selectItem.expr);
            if (!hasCanNotOptimizeExpr) continue;
            return;
        }
        hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, select.condition);
        if (hasCanNotOptimizeExpr) {
            return;
        }
        for (SqlExpr groupExpr : select.groupBy) {
            hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, groupExpr);
            if (!hasCanNotOptimizeExpr) continue;
            return;
        }
        hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, select.having);
        if (hasCanNotOptimizeExpr) {
            return;
        }
        for (SqlOrderByItem orderByItem : select.orderBy) {
            hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, orderByItem.expr);
            if (!hasCanNotOptimizeExpr) continue;
            return;
        }
        SqlTableSourceBase tableSource = select.tableSource;
        HashMap joinConditionUsedAliasMap = new HashMap();
        KSqlUtil.computeJoinConditionUsedAlias(joinConditionUsedAliasMap, tableSource);
        select.tableSource = tableSource = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, tableSource, mode);
        if (selectItemAliasMap != null) {
            block7: for (SqlOrderByItem orderByItem : select.orderBy) {
                String orderExprString = orderByItem.expr.toString();
                for (Map.Entry entry : selectItemAliasMap.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!orderExprString.equalsIgnoreCase(value.toString())) continue;
                    try {
                        orderByItem.expr = new SqlExprParser(key.toString()).expr();
                        continue block7;
                    }
                    catch (Exception ex) {
                        log.warn((Object)ex.getMessage());
                    }
                }
            }
        }
    }

    static void optimize_table_source(SqlTableSourceBase tableSource, int mode) throws ParserException {
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinTabSrc = (SqlJoinedTableSource)tableSource;
            KSqlUtil.optimize_table_source(joinTabSrc.left, mode);
            KSqlUtil.optimize_table_source(joinTabSrc.right, mode);
        }
        if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource queryTabSrc = (SqlSubQueryTableSource)tableSource;
            KSqlUtil.optimize_selectbase(queryTabSrc.subQuery, mode);
        }
    }

    static void optimize_selectbase(SqlSelectBase selectBase, int mode) throws ParserException {
        if (selectBase instanceof SqlSelect) {
            KSqlUtil.optimize((SqlSelect)selectBase, mode);
        } else if (selectBase instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)selectBase;
            KSqlUtil.optimize_selectbase(unionSelect.left, mode);
            KSqlUtil.optimize_selectbase(unionSelect.right, mode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean computeUsedTableAlias(Set usedTableAliasSet, SqlExpr expr) {
        SqlCaseItem caseItem;
        if (expr == null) {
            return false;
        }
        if (expr instanceof SqlAllColumnExpr) {
            return true;
        }
        if (expr instanceof SqlIdentifierExpr) {
            return true;
        }
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator != 20) {
                if (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, binaryExpr.left)) return KSqlUtil.computeUsedTableAlias(usedTableAliasSet, binaryExpr.right);
                return true;
            }
            SqlExpr rootExpr = KSqlUtil.getRootExpr(binaryExpr);
            String ident = ((SqlIdentifierExpr)rootExpr).value;
            if (ident == null) return false;
            if (ident.length() == 0) return false;
            String tableAlias = ident.charAt(0) == '\"' ? ident.substring(1, ident.length() - 1) : ident;
            usedTableAliasSet.add(tableAlias.toUpperCase());
            return false;
        }
        if (expr instanceof SqlMethodInvokeExpr) {
            SqlExpr pramExpr;
            SqlMethodInvokeExpr methodInvokeExpr = (SqlMethodInvokeExpr)expr;
            Iterator iter = methodInvokeExpr.parameters.iterator();
            do {
                if (!iter.hasNext()) return false;
            } while (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, pramExpr = (SqlExpr)iter.next()));
            return true;
        }
        if (expr instanceof SqlAggregateExpr) {
            SqlExpr pramExpr;
            SqlAggregateExpr aggregateExpr = (SqlAggregateExpr)expr;
            Iterator iter = aggregateExpr.paramList.iterator();
            do {
                if (!iter.hasNext()) return false;
            } while (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, pramExpr = (SqlExpr)iter.next()));
            return true;
        }
        if (expr instanceof SqlBetweenExpr) {
            SqlBetweenExpr betweenExpr = (SqlBetweenExpr)expr;
            if (KSqlUtil.computeUsedTableAlias(usedTableAliasSet, betweenExpr.testExpr)) {
                return true;
            }
            if (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, betweenExpr.beginExpr)) return KSqlUtil.computeUsedTableAlias(usedTableAliasSet, betweenExpr.endExpr);
            return true;
        }
        if (!(expr instanceof SqlCaseExpr)) {
            if (expr instanceof SqlInListExpr) {
                SqlExpr targetExpr;
                SqlInListExpr inListExpr = (SqlInListExpr)expr;
                if (KSqlUtil.computeUsedTableAlias(usedTableAliasSet, inListExpr.expr)) {
                    return true;
                }
                Iterator iter = inListExpr.targetList.iterator();
                do {
                    if (!iter.hasNext()) return false;
                } while (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, targetExpr = (SqlExpr)iter.next()));
                return true;
            }
            if (expr instanceof SqlInSubQueryExpr) {
                SqlInSubQueryExpr inExpr = (SqlInSubQueryExpr)expr;
                return KSqlUtil.computeUsedTableAlias(usedTableAliasSet, inExpr.expr);
            }
            if (!(expr instanceof SqlNotExpr)) return false;
            SqlNotExpr notExpr = (SqlNotExpr)expr;
            return KSqlUtil.computeUsedTableAlias(usedTableAliasSet, notExpr.expr);
        }
        SqlCaseExpr caseExpr = (SqlCaseExpr)expr;
        Iterator iter = caseExpr.itemList.iterator();
        do {
            if (!iter.hasNext()) {
                KSqlUtil.computeUsedTableAlias(usedTableAliasSet, caseExpr.valueExpr);
                KSqlUtil.computeUsedTableAlias(usedTableAliasSet, caseExpr.elseExpr);
                return false;
            }
            caseItem = (SqlCaseItem)iter.next();
            if (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, caseItem.conditionExpr)) continue;
            return true;
        } while (!KSqlUtil.computeUsedTableAlias(usedTableAliasSet, caseItem.valueExpr));
        return true;
    }

    static void computeJoinConditionUsedAlias(Map usedAliasMap, SqlTableSourceBase tableSource) {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            HashSet set = new HashSet();
            KSqlUtil.computeUsedTableAlias(set, joinedTable.condition);
            for (Object alias : set) {
                Integer usedCountObj = (Integer)usedAliasMap.get(alias);
                if (usedCountObj != null) {
                    usedCountObj = usedCountObj + 1;
                    usedAliasMap.put(alias, usedCountObj);
                    continue;
                }
                usedAliasMap.put(alias, 1);
            }
            KSqlUtil.computeJoinConditionUsedAlias(usedAliasMap, joinedTable.left);
            KSqlUtil.computeJoinConditionUsedAlias(usedAliasMap, joinedTable.right);
        }
    }

    static SqlTableSourceBase cleanTableSource(HashSet usedTableAliasSet, Map joinConditionUsedAliasMap, SqlTableSourceBase tableSource, int mode) {
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            if (joinedTable.joinType == 1) {
                String originalAlias = joinedTable.right.alias;
                String tableAlias = originalAlias != null && originalAlias.length() != 0 && originalAlias.charAt(0) == '\"' ? originalAlias.substring(1, joinedTable.right.alias.length() - 1) : originalAlias;
                int useInJoinConditionCount = 0;
                if (tableAlias != null) {
                    Integer intObj = (Integer)joinConditionUsedAliasMap.get(tableAlias = tableAlias.toUpperCase());
                    useInJoinConditionCount = intObj == null ? 0 : intObj;
                } else if (joinedTable.right instanceof SqlTableSource) {
                    tableAlias = ((SqlTableSource)joinedTable.right).name.toUpperCase();
                    Integer intObj = (Integer)joinConditionUsedAliasMap.get(tableAlias);
                    useInJoinConditionCount = intObj == null ? 0 : intObj;
                }
                joinedTable.left = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                if (joinedTable.right instanceof SqlTableSource) {
                    if (!usedTableAliasSet.contains(tableAlias) && useInJoinConditionCount <= 1) {
                        return KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                    }
                } else if (joinedTable.right instanceof SqlSubQueryTableSource) {
                    if (!usedTableAliasSet.contains(tableAlias) && useInJoinConditionCount <= 1) {
                        return KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                    }
                } else if (joinedTable.right instanceof SqlJoinedTableSource) {
                    joinedTable.right = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.right, mode);
                }
            } else if (joinedTable.joinType == 0 && mode > 1) {
                String originalAlias = joinedTable.right.alias;
                String tableAlias = originalAlias != null && originalAlias.length() != 0 && originalAlias.charAt(0) == '\"' ? originalAlias.substring(1, joinedTable.right.alias.length() - 1) : originalAlias;
                int useInJoinConditionCount = 0;
                if (tableAlias != null) {
                    Integer intObj = (Integer)joinConditionUsedAliasMap.get(tableAlias = tableAlias.toUpperCase());
                    useInJoinConditionCount = intObj == null ? 0 : intObj;
                } else if (joinedTable.right instanceof SqlTableSource) {
                    tableAlias = ((SqlTableSource)joinedTable.right).name.toUpperCase();
                    Integer intObj = (Integer)joinConditionUsedAliasMap.get(tableAlias);
                    useInJoinConditionCount = intObj == null ? 0 : intObj;
                }
                joinedTable.left = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                if (joinedTable.right instanceof SqlTableSource) {
                    if (!usedTableAliasSet.contains(tableAlias) && useInJoinConditionCount <= 1) {
                        return KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                    }
                } else if (joinedTable.right instanceof SqlSubQueryTableSource) {
                    if (!usedTableAliasSet.contains(tableAlias) && useInJoinConditionCount <= 1) {
                        return KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                    }
                } else if (joinedTable.right instanceof SqlJoinedTableSource) {
                    joinedTable.right = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.right, mode);
                }
            } else {
                joinedTable.left = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.left, mode);
                joinedTable.right = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, joinedTable.right, mode);
            }
        }
        return tableSource;
    }

    public static SqlExpr getRootExpr(SqlExpr expr) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator == 20) {
                return KSqlUtil.getRootExpr(binaryExpr.left);
            }
        }
        return expr;
    }

    public static void cleanUp(Connection conn, Statement stmt) throws SQLException {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanUp(Connection conn, Statement stmt, ResultSet rs) throws SQLException {
        try {
            if (rs == null) return;
            rs.close();
            return;
        }
        finally {
            block16: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn == null) break block16;
                }
                catch (Throwable throwable) {
                    if (conn == null) throw throwable;
                    try {
                        conn.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                }
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void cleanUp(Statement stmt, ResultSet rs) throws SQLException {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception t) {
                    DisCardUtil.discard();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOracleCurrentUser(Connection conn) throws SQLException {
        String currentUser = null;
        String sql = "SELECT TOP 1 B.OWNER FROM USER_TABLES A INNER JOIN ALL_TABLES B ON A.TABLE_NAME = B.TABLE_NAME WHERE B.OWNER != 'SYS'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                currentUser = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(stmt, rs);
        if (currentUser == null) {
            DisCardUtil.discard();
        }
        return currentUser;
    }

    public static String buildKSqlDateString(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        SimpleDateFormat sdf = new SimpleDateFormat("{yyyy-MM-dd HH:mm:ss}");
        return sdf.format(cal.getTime());
    }

    public static int getSqlType(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        Integer val = (Integer)methodTypeMap.get(methodName = methodName.toUpperCase());
        if (val == null) {
            return 0;
        }
        return val;
    }

    public static int getNameType(String name) {
        if (name == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        Integer val = (Integer)methodTypeMap.get(name = name.toUpperCase());
        if (val != null) {
            return 0;
        }
        if (KeyWord.instance.isKeyWord(name)) {
            return 1;
        }
        return -1;
    }

    public static String encodeUrl(String url) {
        String cipher;
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (url.startsWith("jdbc:ksqle:")) {
            return url;
        }
        if (!url.startsWith("jdbc:ksql:")) {
            throw new IllegalArgumentException("invalid ksql driver url");
        }
        String clear = url.substring("jdbc:ksql:".length());
        try {
            cipher = Rijndael_Util.encode(kb, clear);
        }
        catch (InvalidKeyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return "jdbc:ksqle:" + cipher;
    }

    public static String decodeUrl(String url) {
        String clearText;
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (url.startsWith("jdbc:ksql:")) {
            return url;
        }
        if (!url.startsWith("jdbc:ksqle:")) {
            throw new IllegalArgumentException("invalid encoded ksql driver url");
        }
        String cipher = url.substring("jdbc:ksqle:".length());
        try {
            clearText = Rijndael_Util.decode(kb, cipher);
        }
        catch (InvalidKeyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return "jdbc:ksql:" + clearText;
    }

    public static String encodePassword(String src) {
        if (src == null) {
            return null;
        }
        if (src.startsWith("ksqle:")) {
            return src;
        }
        try {
            return "ksqle:" + Rijndael_Util.encode(kb, src);
        }
        catch (InvalidKeyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String decodePassword(String src) {
        String clearText;
        if (src == null) {
            return null;
        }
        if (!src.startsWith("ksqle:")) {
            return src;
        }
        String cipher = src.substring("ksqle:".length());
        try {
            clearText = Rijndael_Util.decode(kb, cipher);
        }
        catch (InvalidKeyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return clearText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(Connection conn) throws SQLException {
        String val;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("/*ksql_internal*/SELECT URL FROM KSQL_ENV");
            rs.next();
            val = rs.getString(1);
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(null, stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(null, stmt, rs);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDbType(Connection conn) throws SQLException {
        int result;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("/*ksql_internal*/SELECT DBTYPE FROM KSQL_ENV");
            rs.next();
            result = rs.getInt(1);
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(null, stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(null, stmt, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDbTypeName(Connection conn) throws SQLException {
        String result;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("/*ksql_internal*/SELECT DBTYPE_NAME FROM KSQL_ENV");
            rs.next();
            result = rs.getString(1);
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(null, stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(null, stmt, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConnectStackTrace(Connection conn) throws SQLException {
        String result;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("/*ksql_internal*/SELECT CONNECT_STACKTRACE FROM KSQL_ENV");
            rs.next();
            result = rs.getString(1);
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(null, stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(null, stmt, rs);
        return result;
    }

    private static SqlExpr replace_for_Select_condition(Map conditionExprCanReplaceMap, SqlExpr expr) throws ParserException {
        if (expr == null) {
            return null;
        }
        if (expr instanceof SqlAllColumnExpr) {
            return expr;
        }
        if (expr instanceof SqlIdentifierExpr) {
            String exprStr = expr.toString();
            String replaceToExprStr = (String)conditionExprCanReplaceMap.get(exprStr.toUpperCase());
            if (replaceToExprStr != null) {
                return new SqlExprParser(replaceToExprStr).expr();
            }
        } else if (KSqlUtil.isPropExpr(expr)) {
            String exprStr = expr.toString();
            String replaceToExprStr = (String)conditionExprCanReplaceMap.get(exprStr.toUpperCase());
            if (replaceToExprStr != null) {
                return new SqlExprParser(replaceToExprStr).expr();
            }
        } else if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            LinkedList<SqlExpr> que = new LinkedList<SqlExpr>();
            que.add(binaryExpr);
            while (!que.isEmpty()) {
                String rightStr;
                String leftStr;
                SqlExpr epr = (SqlExpr)que.remove(0);
                if (!(epr instanceof SqlBinaryOpExpr)) continue;
                SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)epr;
                if (binaryOpExpr.operator == 41 || binaryOpExpr.operator == 20 || (leftStr = binaryOpExpr.left.toString()).equalsIgnoreCase((String)conditionExprCanReplaceMap.get((rightStr = binaryOpExpr.right.toString()).toUpperCase())) || rightStr.equalsIgnoreCase((String)conditionExprCanReplaceMap.get(leftStr.toUpperCase()))) continue;
                if (!(binaryOpExpr.left instanceof SqlBinaryOpExpr) || KSqlUtil.isPropExpr(binaryOpExpr.left)) {
                    binaryOpExpr.left = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, binaryOpExpr.left);
                } else {
                    que.add(binaryOpExpr.left);
                }
                if (!(binaryOpExpr.right instanceof SqlBinaryOpExpr) || KSqlUtil.isPropExpr(binaryOpExpr.right)) {
                    binaryOpExpr.right = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, binaryOpExpr.right);
                    continue;
                }
                que.add(binaryOpExpr.right);
            }
        } else if (expr instanceof SqlMethodInvokeExpr) {
            SqlMethodInvokeExpr methodInvokeExpr = (SqlMethodInvokeExpr)expr;
            int size = methodInvokeExpr.parameters.size();
            for (int i = 0; i < size; ++i) {
                SqlExpr pramExpr = (SqlExpr)methodInvokeExpr.parameters.get(i);
                pramExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, pramExpr);
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
        } else if (expr instanceof SqlAggregateExpr) {
            SqlAggregateExpr aggregateExpr = (SqlAggregateExpr)expr;
            int size = aggregateExpr.paramList.size();
            for (int i = 0; i < size; ++i) {
                SqlExpr pramExpr = (SqlExpr)aggregateExpr.paramList.get(i);
                pramExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, pramExpr);
                aggregateExpr.paramList.set(i, pramExpr);
            }
        } else if (expr instanceof SqlBetweenExpr) {
            SqlBetweenExpr betweenExpr = (SqlBetweenExpr)expr;
            betweenExpr.testExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, betweenExpr.testExpr);
            betweenExpr.beginExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, betweenExpr.beginExpr);
            betweenExpr.endExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, betweenExpr.endExpr);
        } else if (expr instanceof SqlCaseExpr) {
            SqlCaseExpr caseExpr = (SqlCaseExpr)expr;
            int size = caseExpr.itemList.size();
            for (int i = 0; i < size; ++i) {
                SqlCaseItem caseItem = (SqlCaseItem)caseExpr.itemList.get(i);
                caseItem.conditionExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, caseItem.conditionExpr);
                caseItem.valueExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, caseItem.valueExpr);
            }
            caseExpr.valueExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, caseExpr.valueExpr);
            caseExpr.elseExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, caseExpr.elseExpr);
        } else if (expr instanceof SqlInListExpr) {
            SqlInListExpr inListExpr = (SqlInListExpr)expr;
            inListExpr.expr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, inListExpr.expr);
            int size = inListExpr.targetList.size();
            for (int i = 0; i < size; ++i) {
                SqlExpr targetExpr = (SqlExpr)inListExpr.targetList.get(i);
                targetExpr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, targetExpr);
                inListExpr.targetList.set(i, targetExpr);
            }
        } else if (expr instanceof SqlInSubQueryExpr) {
            SqlInSubQueryExpr inExpr = (SqlInSubQueryExpr)expr;
            inExpr.expr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, inExpr.expr);
        } else if (expr instanceof SqlNotExpr) {
            SqlNotExpr notExpr = (SqlNotExpr)expr;
            notExpr.expr = KSqlUtil.replace_for_Select_condition(conditionExprCanReplaceMap, notExpr.expr);
        }
        return expr;
    }

    public static TraceInfo parseURL(String url) throws SQLException {
        return KSqlUtil.parseURL(url, 0x6DDD00);
    }

    public static TraceInfo parseURL(String url, int lifecycle) throws SQLException {
        StringTokenizer tokens = new StringTokenizer(url, ":");
        String str = tokens.nextToken();
        if (!str.equalsIgnoreCase("jdbc")) {
            throw new SQLException("invalid url");
        }
        str = tokens.nextToken();
        if (!str.equalsIgnoreCase("ksql")) {
            throw new SQLException("invalid url");
        }
        String driverName = tokens.nextToken();
        String dbTypeStr = KSqlUtil.getOption(url, OPTIONS_DBTYPE);
        if (dbTypeStr == null) {
            throw new SQLException("you must set dbtype");
        }
        int dbType = DbType.getValue(dbTypeStr);
        int bindPort = KSqlUtil.getIntOption(url, OPTIONS_BINDPORT, -1);
        int optimizeMode = KSqlUtil.getIntOption(url, OPTIONS_OPTIMIZE, 1);
        boolean translate = KSqlUtil.getBoolOption(url, OPTIONS_TRANSLATE, true);
        boolean nologging = KSqlUtil.getBoolOption(url, OPTIONS_NOLOGGING, false);
        String schema = KSqlUtil.getOption(url, OPTIONS_DBSCHEMA);
        String trace = KSqlUtil.getOption(url, OPTIONS_TRACE);
        String filter = KSqlUtil.getOption(url, OPTIONS_FILTER);
        String traceFile = KSqlUtil.getOption(url, OPTIONS_TRACEFILE);
        String[] tempTableSpaces = KSqlUtil.getArrayOption(url, OPTIONS_TEMPTABLESPACE, ",");
        String originalURL = url.substring(url.indexOf(":jdbc:") + 1);
        TraceInfo info = new TraceInfo(driverName, dbType, originalURL, "on".equalsIgnoreCase(trace), traceFile, filter, translate, bindPort, optimizeMode, tempTableSpaces, url, lifecycle);
        FormatOptions options = new FormatOptions();
        options.setDbSchema(schema);
        options.setNologging(nologging);
        options.setTableSchema(KSqlUtil.getOption(url, OPTIONS_TABLESCHEMA));
        options.setTempTableSpaces(tempTableSpaces);
        info.setFormatOptions(options);
        return info;
    }

    private static String getOption(String oUrl, String name) {
        if (name == null || oUrl == null) {
            return null;
        }
        String url = oUrl.toLowerCase();
        name = name.toLowerCase();
        int sPos = url.indexOf(":" + name + "=");
        if (sPos == -1) {
            return null;
        }
        int ePos = url.indexOf(":", sPos += name.length() + 2);
        if (ePos == -1) {
            return null;
        }
        String options = oUrl.substring(sPos, ePos);
        return options.replaceAll("\\|", ":");
    }

    private static boolean getBoolOption(String url, String name, boolean defValue) {
        String value = KSqlUtil.getOption(url, name);
        if (value == null) {
            return defValue;
        }
        return "true".equals(value);
    }

    private static int getIntOption(String url, String name, int defValue) {
        String value = KSqlUtil.getOption(url, name);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            return defValue;
        }
    }

    private static String[] getArrayOption(String url, String name, String separator) {
        String value = KSqlUtil.getOption(url, name);
        if (value == null) {
            return null;
        }
        return value.split(separator);
    }

    public static String getSID(String ip, String port) {
        String[] nIPs = ip.split("\\.");
        if (nIPs.length == 4) {
            boolean flag = false;
            int pValue = 0;
            try {
                pValue = Integer.parseInt(port);
                flag = true;
            }
            catch (Exception ex) {
                log.error((Object)"getSID error", (Throwable)ex);
            }
            if (flag) {
                int iValue = 0;
                for (int i = 0; i < 4; ++i) {
                    int off = (4 - i) * 8;
                    iValue = Integer.parseInt(nIPs[i]) << off | iValue;
                }
                return KSqlUtil.normalize(iValue) + KSqlUtil.normalize(pValue);
            }
        }
        return KSqlUtil.normalize((ip + ":" + port).hashCode());
    }

    private static final String normalize(long l) {
        return Long.toString(l, 35).toUpperCase().replaceAll("-", "Z");
    }

    public static boolean isICUEnableInDb2() {
        return icuEnableInDb2;
    }

    public static void setICUEnableInDb2(boolean isICUEnableInDb2) {
        icuEnableInDb2 = isICUEnableInDb2;
    }

    public static boolean isICUinDb2UseCOLLATION_KEY_BIT() {
        return icuInDb2UseCOLLATION_KEY_BIT;
    }

    public static void setICUinDb2UseCOLLATION_KEY_BIT(boolean isICUnDb2UseCOLLATION_KEY_BIT) {
        icuInDb2UseCOLLATION_KEY_BIT = isICUnDb2UseCOLLATION_KEY_BIT;
    }

    public static boolean isAlterTableWithProcedureInDB2() {
        return alterTableWithProcedureInDB2;
    }

    public static void setAlterTableWithProcedureInDB2(boolean use) {
        alterTableWithProcedureInDB2 = use;
    }

    public static boolean isAutoReorgWhenAlterTableInDB2() {
        return autoReorgWhenAlterTableInDB2;
    }

    public static void setAutoReorgWhenAlterTableInDB2(boolean use) {
        autoReorgWhenAlterTableInDB2 = use;
    }

    public static boolean isSupportPurge() {
        return supportPurge;
    }

    public static void setSupportPurge(boolean supportPurge) {
        KSqlUtil.supportPurge = supportPurge;
    }

    static {
        methodTypeMap.put("ABS", 3);
        methodTypeMap.put("ACOS", 3);
        methodTypeMap.put("ASIN", 3);
        methodTypeMap.put("ATAN", 3);
        methodTypeMap.put("ATN2", 3);
        methodTypeMap.put("CEILING", 4);
        methodTypeMap.put("COS", 3);
        methodTypeMap.put("EXP", 3);
        methodTypeMap.put("FLOOR", 4);
        methodTypeMap.put("MOD", 4);
        methodTypeMap.put("LOG", 3);
        methodTypeMap.put("POWER", 3);
        methodTypeMap.put("ROUND", 3);
        methodTypeMap.put("SIGN", 3);
        methodTypeMap.put("SIN", 3);
        methodTypeMap.put("SQRT", 3);
        methodTypeMap.put("TAN", 3);
        methodTypeMap.put("CURDATE", 93);
        methodTypeMap.put("CURTIME", 92);
        methodTypeMap.put("DATEADD", 93);
        methodTypeMap.put("DATEDIFF", 4);
        methodTypeMap.put("DAYNAME", 12);
        methodTypeMap.put("DAYOFMONTH", 4);
        methodTypeMap.put("DAYOFWEEK", 4);
        methodTypeMap.put("DAYOFYEAR", 4);
        methodTypeMap.put("GETDATE", 93);
        methodTypeMap.put("HOUR", 4);
        methodTypeMap.put("MINUTE", 4);
        methodTypeMap.put("MONTH", 4);
        methodTypeMap.put("MONTHNAME", 12);
        methodTypeMap.put("NOW", 93);
        methodTypeMap.put("QUARTER", 4);
        methodTypeMap.put("SECOND", 4);
        methodTypeMap.put("WEEK", 4);
        methodTypeMap.put("YEAR", 4);
        methodTypeMap.put("TO_DATE", 93);
        methodTypeMap.put("MONTHS_BETWEEN", 4);
        methodTypeMap.put("DAYS_BETWEEN", 4);
        methodTypeMap.put("ADD_MONTHS", 93);
        methodTypeMap.put("ADD_YEARS", 93);
        methodTypeMap.put("ADD_DAYS", 93);
        methodTypeMap.put("ADD_HOURS", 93);
        methodTypeMap.put("ADD_MINUTES", 93);
        methodTypeMap.put("ADD_SECONDS", 93);
        methodTypeMap.put("ASCII", 4);
        methodTypeMap.put("CHAR", 12);
        methodTypeMap.put("CHARINDEX", 4);
        methodTypeMap.put("CONCAT", 12);
        methodTypeMap.put("LEFT", 12);
        methodTypeMap.put("LEN", 4);
        methodTypeMap.put("LENGTH", 4);
        methodTypeMap.put("LOWER", 12);
        methodTypeMap.put("LCASE", 12);
        methodTypeMap.put("LTRIM", 12);
        methodTypeMap.put("REPLACE", 12);
        methodTypeMap.put("RIGHT", 12);
        methodTypeMap.put("RTRIM", 12);
        methodTypeMap.put("SOUNDEX", 4);
        methodTypeMap.put("SUBSTRING", 12);
        methodTypeMap.put("TRIM", 12);
        methodTypeMap.put("UCASE", 12);
        methodTypeMap.put("UPPER", 12);
        methodTypeMap.put("TOCHAR", 12);
        methodTypeMap.put("DATENAME", 12);
        methodTypeMap.put("TO_NUMBER", 3);
        methodTypeMap.put("TO_INT", 4);
        methodTypeMap.put("NEWID", 12);
        methodTypeMap.put("COUNT", 4);
        methodTypeMap.put("AVG", 3);
        methodTypeMap.put("SUM", 3);
        methodTypeMap.put("MAX", 3);
        methodTypeMap.put("MIN", 3);
    }
}

