/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.ksql.CONSTANT;
import kd.bos.ksql.DbType;
import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.formater.FormaterFactory;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.ksql.rebuild.SqlReBuilderManager;
import kd.bos.ksql.schema.KSQLSchemaContext;
import kd.bos.ksql.util.LRUCacheMap;
import kd.bos.ksql.visitor.SharedConnectionVisitor;
import org.apache.log4j.Logger;

public class TransInner {
    private static Logger log;
    private static int ksql_trans_cache_size;
    private static int ksql_trans_nocache_sql_length;
    private static final boolean WARN_DIALECT_SQL;
    private static final Map<String, TransResult>[] cacheMaps;
    private static final Map<String, List<SqlStmt>> dtsStatementMap;
    static final AtomicLong transCount;

    static boolean isWarnDialectSQL() {
        return WARN_DIALECT_SQL;
    }

    static void warnDialectSQL(String sql) {
        log.warn((Object)("Dialect SQL: " + sql));
    }

    static String transSQL(String ksql, int targetDbType, FormatOptions options, FormaterContext formaterContext, boolean throwExWhenNameTooLong) {
        KSQLSchemaContext schemaContext;
        String key;
        if (ksql.length() > ksql_trans_nocache_sql_length) {
            return TransInner.doTransSQL(ksql, targetDbType, options, formaterContext, throwExWhenNameTooLong);
        }
        Map<String, TransResult> cacheMap = cacheMaps[targetDbType];
        String string = key = SqlReBuilderManager.isEnable() ? SqlReBuilderManager.getReBuilder().getColumnValueProvider().get() + ksql : ksql;
        if (CONSTANT.CONNECTION_SHARD && (schemaContext = KSQLSchemaContext.get()) != null) {
            key = schemaContext.getDbType() + schemaContext.getSchema() + key;
        }
        if (key.length() > ksql_trans_nocache_sql_length) {
            return TransInner.doTransSQL(ksql, targetDbType, options, formaterContext, throwExWhenNameTooLong);
        }
        TransResult result = cacheMap.get(key);
        if (result != null) {
            result.cloneContext(formaterContext);
            return result.getSql();
        }
        String sql = TransInner.doTransSQL(ksql, targetDbType, options, formaterContext, throwExWhenNameTooLong);
        cacheMap.put(key, new TransResult(sql, formaterContext));
        return sql;
    }

    private static String doTransSQL(String ksql, int targetDbType, FormatOptions options, FormaterContext formaterContext, boolean throwExWhenNameTooLong) {
        try {
            KSQLSchemaContext schemaContext;
            Lexer lexer = new Lexer(ksql);
            SqlParser parser = new SqlParser(lexer);
            parser.setThrowExWhenNameTooLong(throwExWhenNameTooLong);
            List stmtCol = (List)parser.parseStmtList();
            if (stmtCol == null || stmtCol.size() <= 0) {
                return "";
            }
            if (CONSTANT.CONNECTION_SHARD && (targetDbType == 6 || targetDbType == 5) && (schemaContext = KSQLSchemaContext.get()) != null) {
                SharedConnectionVisitor shardConnectionVisitor = new SharedConnectionVisitor(schemaContext.getSchema());
                for (Object o : stmtCol) {
                    SqlObject sqlObject = (SqlObject)o;
                    sqlObject.accept(shardConnectionVisitor);
                }
            }
            SQLFormater formater = FormaterFactory.getFormater(targetDbType);
            if (formaterContext != null) {
                formater.setFormaterContext(formaterContext);
            }
            if (options != null) {
                formater.setOptions(options);
            }
            transCount.incrementAndGet();
            formater.format(stmtCol);
            return formater.getBuffer().toString();
        }
        catch (RuntimeException ex) {
            TransInner.logFormatError(ex, ksql, targetDbType);
            throw ex;
        }
        catch (Exception ex) {
            TransInner.logFormatError(ex, ksql, targetDbType);
            throw new RuntimeException(new ParserException(ex, ksql, targetDbType));
        }
        catch (Error e) {
            TransInner.logFormatError(e, ksql, targetDbType);
            throw e;
        }
    }

    public static List<SqlStmt> parseStatement(String ksql) {
        String key;
        String string = key = SqlReBuilderManager.isEnable() ? SqlReBuilderManager.getReBuilder().getColumnValueProvider().get() + ksql : ksql;
        if (key.length() > ksql_trans_nocache_sql_length) {
            return TransInner.parseStmt(ksql);
        }
        List<SqlStmt> result = dtsStatementMap.get(key);
        if (result != null) {
            return result;
        }
        result = TransInner.parseStmt(ksql);
        dtsStatementMap.put(key, result);
        return result;
    }

    private static List<SqlStmt> parseStmt(String ksql) {
        try {
            Lexer lexer = new Lexer(ksql);
            SqlParser parser = new SqlParser(lexer);
            parser.setThrowExWhenNameTooLong(TransUtil.isThrowExWhenNameTooLong());
            return (List)parser.parseStmtList();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(new ParserException(ex, ksql));
        }
        catch (Error e) {
            throw e;
        }
    }

    private static void logFormatError(Throwable ex, String kSql, int targetDbType) {
        log.info((Object)("Format sql error, target database is '" + DbType.getName(targetDbType) + "' detail message is :\n" + ex.getMessage() + "\nsource sql is : \n" + kSql), ex);
    }

    private static void logParseError(Throwable ex, String kSql) {
        log.info((Object)("Parse sql error, detail message is :\n" + ex.getMessage() + "\nsource sql is : \n" + kSql), ex);
    }

    static {
        String length;
        log = Logger.getLogger((String)"KSQL-TRANS");
        ksql_trans_cache_size = 512;
        ksql_trans_nocache_sql_length = 4096;
        WARN_DIALECT_SQL = Boolean.getBoolean("ksql.warnDialectSQL");
        transCount = new AtomicLong();
        String size = System.getProperty("ksql.trans.cache.size");
        if (size != null && size.matches("\\d+")) {
            ksql_trans_cache_size = Integer.parseInt(size);
        }
        if ((length = System.getProperty("ksql.trans.no_cache_sql_length")) != null && length.matches("\\d+")) {
            ksql_trans_nocache_sql_length = Integer.parseInt(length);
        }
        int n = DbType.getAllTypes().length;
        cacheMaps = new Map[n];
        for (int i = 0; i < n; ++i) {
            TransInner.cacheMaps[i] = Collections.synchronizedMap(new LRUCacheMap(ksql_trans_cache_size));
        }
        dtsStatementMap = Collections.synchronizedMap(new LRUCacheMap(ksql_trans_cache_size));
        SqlReBuilderManager.init();
    }

    private static class TransResult {
        private final String sql;
        private final FormaterContext formaterContext;

        public TransResult(String sql, FormaterContext formaterContext) {
            this.sql = sql;
            this.formaterContext = formaterContext;
        }

        public String getSql() {
            return this.sql;
        }

        public void cloneContext(FormaterContext context) {
            if (context == null) {
                return;
            }
            this.formaterContext.copyProperty(context);
        }
    }
}

