/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.dom;

import java.io.Serializable;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.visitor.ASTVisitor;

public class SqlSelectItem
extends SqlObject
implements Serializable {
    public SqlExpr expr;
    public String alias;
    private String asWord = "";
    private String orgAliasWord;
    private boolean equalMark = false;

    public SqlSelectItem() {
    }

    public SqlSelectItem(SqlExpr expr, String alias) {
        this(expr, alias, alias);
    }

    public SqlSelectItem(SqlExpr expr, String alias, String orgAlias) {
        this(expr, alias, orgAlias, "");
    }

    public SqlSelectItem(SqlExpr expr, String alias, String orgAlias, String asWord) {
        this(expr, alias, orgAlias, asWord, false);
    }

    public SqlSelectItem(SqlExpr expr, String alias, String orgAlias, String asWord, boolean mark) {
        this.expr = expr;
        this.alias = alias;
        this.setOrgAliasWord(orgAlias);
        this.setAsWord(asWord);
        this.setEqualMark(mark);
    }

    public void output(StringBuilder buff) {
        if (this.expr != null) {
            this.expr.output(buff);
        } else {
            buff.append("null");
        }
        if (this.alias != null && this.alias.length() != 0) {
            buff.append(' ');
            buff.append(this.alias);
        }
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        this.output(bf);
        return bf.toString();
    }

    @Override
    public Object clone() {
        if (this.expr != null) {
            return new SqlSelectItem((SqlExpr)this.expr.clone(), this.alias, this.orgAliasWord, this.asWord, this.equalMark);
        }
        return new SqlSelectItem(null, this.alias, this.orgAliasWord, this.asWord, this.equalMark);
    }

    public String getOrgAliasWord() {
        if (this.orgAliasWord == null || this.orgAliasWord.trim().length() == 0) {
            return this.alias;
        }
        return this.orgAliasWord;
    }

    public void setOrgAliasWord(String orgAliasWord) {
        this.orgAliasWord = orgAliasWord;
    }

    public String getAsWord() {
        return this.asWord;
    }

    public void setAsWord(String asWord) {
        this.asWord = asWord;
    }

    public boolean isEqualMark() {
        return this.equalMark;
    }

    public void setEqualMark(boolean isEqualMark) {
        this.equalMark = isEqualMark;
    }

    @Override
    protected void collectChildren() {
        this.addChild(this.expr);
    }

    @Override
    public <T> T accept(ASTVisitor<? extends T> visitor) {
        return visitor.visitSqlSelectItem(this);
    }
}

