/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.Collection;
import java.util.Iterator;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlPriorIdentifierExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.util.DisCardUtil;

public class DerbySQLFormater
extends SQLFormater {
    protected DerbySQLFormater() {
        super(null);
    }

    public DerbySQLFormater(StringBuilder sb) {
        super(sb);
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "SELECT TABLENAME, TABLEID, SCHEMAID FROM SYS.SYSTABLES WHERE TYPE = 'T' ORDER BY NAME";
        this.buffer.append(sql);
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String sql = "SELECT C.COLUMNNAME, C.COLUMNDATATYPE, T.TABLENAME, T.TABLEID FROM SYS.SYSCOLUMNS C INNER JOIN SYS.SYSTABLES T ON C.REFERENCEID = T.TABLEID ORDER BY T.TABLENAME, C.COLUMNNUMBER WHERE T.TABLENAME = '" + stmt.tableName + "'";
        this.buffer.append(sql);
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        this.buffer.append("CALL ");
        this.buffer.append(stmt.processName);
        if (stmt.paramList.size() != 0) {
            this.buffer.append(" (");
            boolean flag = false;
            Iterator iter = stmt.paramList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iter.next();
                this.formatExpr(expr);
                flag = true;
            }
            this.buffer.append(')');
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        if (column.name.indexOf(" ") >= 0) {
            this.buffer.append("\"");
            this.buffer.append(column.name);
            this.buffer.append("\" ");
        } else {
            this.buffer.append(column.name);
            this.buffer.append(" ");
        }
        if (column.dataType.equalsIgnoreCase("BIGINT")) {
            this.buffer.append("BIGINT");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("FLOAT")) {
            this.buffer.append("FLOAT");
        } else if (column.dataType.equalsIgnoreCase("IMAGE")) {
            this.buffer.append("BLOB (1G)");
        } else if (column.dataType.equalsIgnoreCase("INT")) {
            this.buffer.append("INT");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NTEXT")) {
            this.buffer.append("CLOB (1G)");
        } else if (column.dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("REAL")) {
            this.buffer.append("REAL");
        } else if (column.dataType.equalsIgnoreCase("TEXT")) {
            this.buffer.append("CLOB (1G)");
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMP")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("TIME")) {
            this.buffer.append("TIME");
        } else if (column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("DATE");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.autoIncrement) {
            this.buffer.append(" GENERATED ALWAYS AS IDENTITY");
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected final void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(stmt.tableName);
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD COLUMN ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                try {
                    this.formatTableConstraint(constraint);
                }
                catch (FormaterException ex) {
                    throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("COLUMN ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.formatColumnDef(alterColumnDefItem.columnDef);
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        this.buffer.append("SELECT ");
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            this.buffer.append("ALL ");
        } else {
            if (select.distinct == 2) {
                throw new FormaterException("NOT SUPPORT.");
            }
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.alias != null && item.alias.length() != 0) {
                this.formatExpr(item.expr);
                this.buffer.append(" ");
                this.buffer.append(item.alias);
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            this.buffer.append(" LIMIT 0, ");
            this.buffer.append(select.limit.rowCount);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
        }
    }

    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if (this.formatMathFunc(methodNameI = expr.methodName.toUpperCase(), expr)) {
            return;
        }
        if (this.formatDateTimeFunc(methodNameI, expr)) {
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ASCII(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("LOCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() == 3) {
                this.buffer.append("LOCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" || ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("LEFT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LEN") == 0 || methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LENGTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LENGTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LOWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LOWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            throw new FormaterException("NOT SUPPORT" + expr.toString());
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("RIGHT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("RTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            throw new FormaterException("NOT SUPPORT" + expr.toString());
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            if (expr.parameters.size() == 3) {
                this.buffer.append("SUBSTR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0), false);
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1), false);
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(2), false);
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LTRIM(RTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append("))");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("UPPER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("UPPER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("('' || ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("COALESCE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("NULLIF(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CONVERT(FLOAT, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("FLOOR(CONVERT(FLOAT, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append("))");
                return;
            }
            throw new FormaterException("ERROR");
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    private boolean formatDateTimeFunc(String methodNameI, SqlMethodInvokeExpr expr) throws FormaterException {
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("CURDATE()");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("CONCAT('', CURTIME())");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DATEADD") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" SECOND)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATEDIFF(SS, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("DAYNAME(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("DAYOFMONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0 || methodNameI.compareTo("WEEKDAY") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("((WEEKDAY(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(") + 1) % 7 + 1)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("TO_DAYS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("NOW()");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("HOUR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("MINUTE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("MONTHNAME(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("NOW()");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("QUARTER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SECOND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("WEEK(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(") + 1");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("((YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(") - YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 12 + ");
                this.buffer.append("MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(") - MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" MONTH)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" YEAR)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" DAY)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" HOUR)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" MINUTE)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ADD_SECONDS") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" SECOND)");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        return false;
    }

    private boolean formatMathFunc(String methodNameI, SqlMethodInvokeExpr expr) throws FormaterException {
        if (methodNameI.compareTo("ABS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ABS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ACOS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ASIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ATAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ATN2") == 0 || methodNameI.compareTo("ATAN2") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ATAN2(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CEILING(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("COS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("COT") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("COT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DEGREE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("DEGREE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("EXP(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("FLOOR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("GREATEAST") == 0) {
            if (expr.parameters.size() > 0) {
                this.buffer.append("GREATEAST(");
                for (int i = 0; i < expr.parameters.size(); ++i) {
                    if (i != 0) {
                        this.buffer.append(", ");
                    }
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                }
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LEAST") == 0) {
            if (expr.parameters.size() > 0) {
                this.buffer.append("LEAST(");
                for (int i = 0; i < expr.parameters.size(); ++i) {
                    if (i != 0) {
                        this.buffer.append(", ");
                    }
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                }
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("MOD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LOG(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LOG10") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LOG10(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("PI") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("PI()");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("POW") == 0 || methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("POWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("RADIANS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("RADIANS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("RAND") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("RAND()");
                return true;
            }
            if (expr.parameters.size() == 1) {
                this.buffer.append("RAND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SIGN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SQRT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("TAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TRUNCATE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("TRUNCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        return false;
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 21) {
            this.buffer.append("MOD(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 42) {
            this.buffer.append("CONCAT(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 0) {
            SqlBinaryOpExpr binaryOpExpr;
            SqlMethodInvokeExpr funcExpr;
            if (expr.left instanceof SqlCharExpr || expr.left instanceof SqlNCharExpr || expr.right instanceof SqlCharExpr || expr.right instanceof SqlNCharExpr) {
                this.buffer.append("CONCAT(");
                this.formatExpr(expr.left);
                this.buffer.append(", ");
                this.formatExpr(expr.right);
                this.buffer.append(")");
                return;
            }
            if (expr.left instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.left;
                if (funcExpr.methodName.equals("CHAR") || funcExpr.methodName.equals("LTRIM") || funcExpr.methodName.equals("RTRIM") || funcExpr.methodName.equals("LCASE") || funcExpr.methodName.equals("LOWER") || funcExpr.methodName.equals("UPPER") || funcExpr.methodName.equals("UCASE") || funcExpr.methodName.equals("SUBSTR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.right;
                if (funcExpr.methodName.equals("CHAR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.left;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.right;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 1) {
            String alias;
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                alias = ((SqlIdentifierExpr)expr.right).value.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                alias = ((SqlCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                alias = ((SqlNCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 40: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        if (stmt.name.indexOf(" ") >= 0) {
            this.buffer.append("CREATE TABLE [");
            this.buffer.append(stmt.name);
            this.buffer.append("] (");
        } else {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(stmt.name);
            this.buffer.append(" (");
        }
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            if (primaryKey.clustered) {
                this.buffer.append(" PRIMARY KEY (");
            } else {
                this.buffer.append(" PRIMARY KEY NONCLUSTERED (");
            }
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected final void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            this.buffer.append(simpleTableSource.name);
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias);
            }
            if (simpleTableSource.lockingHint != null && simpleTableSource.lockingHint.length() > 0 && "holdlock".equalsIgnoreCase(simpleTableSource.lockingHint)) {
                this.buffer.append(" FOR UPDATE");
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(" CROSS JOIN ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    throw new FormaterException("not supported.");
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias);
            }
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        throw new FormaterException("Not Support. PriorIdentifierExpr");
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatIdentity(SqlExpr stmt) {
    }
}

