/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.parser;

import kd.bos.ksql.dom.expr.SqlDeclareVariantExpr;
import kd.bos.ksql.dom.stmt.SqlDeclareVariantStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParserBase;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.parser.TokenList;
import kd.bos.util.DisCardUtil;

public class DeclareParser
extends SqlParserBase {
    private final TokenList _tokenList;

    public DeclareParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
    }

    public DeclareParser(TokenList tokenList) {
        this._tokenList = tokenList;
    }

    public final SqlStmt parse() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.DeclareToken)) {
            this._tokenList.match();
        }
        if (this._tokenList.lookup((int)0).type == 2) {
            SqlDeclareVariantStmt declVarStmt = new SqlDeclareVariantStmt();
            SqlDeclareVariantExpr expr = this.parseDeclVarExpr();
            declVarStmt.itemList.add(expr);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                expr = this.parseDeclVarExpr();
                declVarStmt.itemList.add(expr);
            }
            return declVarStmt;
        }
        throw new ParserException("not support token:" + this._tokenList.lookup(0));
    }

    public final SqlDeclareVariantExpr parseDeclVarExpr() throws ParserException {
        String varName = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        String dataType = this._tokenList.lookup((int)0).value.toUpperCase();
        this._tokenList.match();
        if (varName.charAt(0) != '@') {
            throw new ParserException("ERROR DECLARE VARIANT EXPR.");
        }
        SqlDeclareVariantExpr declVarExpr = new SqlDeclareVariantExpr();
        declVarExpr.variantName = varName;
        declVarExpr.dataType = dataType;
        if (dataType.equals("INT")) {
            declVarExpr.length = 4;
        } else if (dataType.equals("SMALLINT")) {
            declVarExpr.length = 2;
        } else if (dataType.equals("DECIMAL")) {
            declVarExpr.length = 9;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match();
                declVarExpr.precision = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    declVarExpr.scale = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    this._tokenList.match(8);
                }
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("CHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (declVarExpr.length > 254) {
                throw new ParserException("the max lenght of the data type 'char' is 254.");
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("NCHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (declVarExpr.length > 254) {
                throw new ParserException("the max lenght of the data type 'nchar' is 254.");
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("VARCHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (declVarExpr.length > 4000) {
                throw new ParserException("the max lenght of the data type 'varchar' is 4000.");
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("NVARCHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (declVarExpr.length > 2000) {
                throw new ParserException("the max lenght of the data type 'nvarchar' is 2000.");
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("DATETIME")) {
            DisCardUtil.discard();
        } else if (dataType.equals("TIMESTAMP")) {
            declVarExpr.dataType = "DATETIME";
        } else if (dataType.equals("BINARY")) {
            this._tokenList.match(Token.OpenBraceToken);
            declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (declVarExpr.length > 2000) {
                throw new ParserException("the max lenght of the data type 'binary' is 2000.");
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("VARBINARY")) {
            this._tokenList.match(Token.OpenBraceToken);
            declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (declVarExpr.length > 2000) {
                throw new ParserException("the max lenght of the data type 'varbinary' is 2000.");
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("BLOG")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("CLOB")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                if (declVarExpr.length > 0x40000000) {
                    throw new ParserException("the max lenght of the data type 'CLOB' is 1073741824.");
                }
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("NCLOB")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("BLOB")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                declVarExpr.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else {
            throw new ParserException("NOT SUPPORT DATA TYPE '" + dataType + "'");
        }
        return declVarExpr;
    }
}

