/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.parser;

import java.util.Collection;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.parser.SqlParserBase;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.parser.TokenList;
import kd.bos.ksql.rebuild.SqlStmtRebuilder;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;
import org.apache.log4j.Logger;

public class SqlCreateTableParser
extends SqlParserBase {
    private final TokenList _tokenList;
    private static Logger logger = Logger.getLogger(SqlCreateTableParser.class);

    public SqlCreateTableParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
    }

    public SqlCreateTableParser(TokenList tokenList) {
        this._tokenList = tokenList;
    }

    public final SqlCreateTableStmt parse() throws ParserException {
        this._tokenList.match(Token.TableToken);
        String tableName = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
            tableName = tableName + ".";
            this._tokenList.match();
            String trueName = this._tokenList.lookup((int)0).value;
            tableName = tableName + trueName;
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                tableName = tableName + ".";
                this._tokenList.match();
                trueName = this._tokenList.lookup((int)0).value;
                tableName = tableName + trueName;
                this._tokenList.match(1);
                if (trueName.length() > 30) {
                    String message = "table name is too long. max length is 30, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn;
                    logger.debug((Object)message);
                    if (!UUTN.isTempTable(trueName) && !UUTN.isGlobalTempTable(trueName) && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
                        throw new ParserException(message, this._tokenList.lookup((int)0).beginLine, this._tokenList.lookup((int)0).beginColumn);
                    }
                }
            } else if (trueName.length() > 30) {
                String message = "table name is too long. max length is 30, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn;
                logger.debug((Object)message);
                if (!UUTN.isTempTable(trueName) && !UUTN.isGlobalTempTable(trueName) && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
                    throw new ParserException(message, this._tokenList.lookup((int)0).beginLine, this._tokenList.lookup((int)0).beginColumn);
                }
            }
        } else if (tableName.length() > 30) {
            String message = "table name is too long. max length is 30, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn;
            logger.debug((Object)message);
            if (!UUTN.isTempTable(tableName) && !UUTN.isGlobalTempTable(tableName) && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
                throw new ParserException(message, this._tokenList.lookup((int)0).beginLine, this._tokenList.lookup((int)0).beginColumn);
            }
        }
        this._tokenList.match(Token.OpenBraceToken);
        SqlCreateTableStmt stmt = new SqlCreateTableStmt(tableName);
        this.parseColumnDefList(stmt.columnList);
        this.tableConstraintList(stmt.constraintList);
        this._tokenList.match(Token.CloseBraceToken);
        this.parseTableSpace(stmt);
        SqlStmtRebuilder.rebuild(stmt);
        return stmt;
    }

    private void parseTableSpace(SqlCreateTableStmt stmt) throws ParserException {
        if (Token.OnToken.equals(this._tokenList.lookup(0))) {
            this._tokenList.match(Token.OnToken);
            stmt.tableSpace = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
        }
    }

    private void tableConstraintList(Collection constraintList) throws ParserException {
        while (this._tokenList.lookup(0).equals(Token.ConstraintToken)) {
            SqlTableConstraint constraint = this.tableConstraint();
            constraintList.add(constraint);
            if (!this._tokenList.lookup(0).equals(Token.CommaToken) || !this._tokenList.lookup(1).equals(Token.ConstraintToken)) continue;
            this._tokenList.match();
        }
    }

    public final SqlTableConstraint tableConstraint() throws ParserException {
        String constraintName = null;
        String constraintWord = null;
        if (this._tokenList.lookup(0).equals(Token.ConstraintToken)) {
            constraintWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            constraintName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            if (constraintName.length() > 18 && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
                throw new ParserException("constraintName name is too long. max length is 18, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
        }
        if (this._tokenList.lookup(0).equals(Token.PrimaryToken)) {
            String primaryKeyWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            primaryKeyWord = primaryKeyWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.KeyToken);
            SqlTablePrimaryKey primaryKey = new SqlTablePrimaryKey(constraintName);
            primaryKey.setConstraintWord(constraintWord);
            primaryKey.setPrimaryKeyWord(primaryKeyWord);
            if (this._tokenList.lookup(0).equals(Token.NonClusteredToken)) {
                primaryKey.setClusteredWord(this._tokenList.lookup(0).getOrgValue());
                primaryKey.clustered = false;
                this._tokenList.match();
            } else if (this._tokenList.lookup(0).equals(Token.ClusteredToken)) {
                primaryKey.setClusteredWord(this._tokenList.lookup(0).getOrgValue());
                primaryKey.clustered = true;
                this._tokenList.match();
            }
            this._tokenList.match(Token.OpenBraceToken);
            String columnName = this._tokenList.lookup((int)0).value;
            primaryKey.columnList.add(columnName);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                columnName = this._tokenList.lookup((int)0).value;
                primaryKey.columnList.add(columnName);
                this._tokenList.match(1);
            }
            this._tokenList.match(Token.CloseBraceToken);
            return primaryKey;
        }
        if (this._tokenList.lookup(0).equals(Token.UniqueToken)) {
            String uniqueWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlTableUnique unique = new SqlTableUnique(constraintName);
            unique.setConstraintWord(constraintWord);
            unique.setUniqueWord(uniqueWord);
            if (this._tokenList.lookup(0).equals(Token.NonClusteredToken)) {
                unique.setClusteredWord(this._tokenList.lookup(0).getOrgValue());
                unique.clustered = false;
                this._tokenList.match();
            } else if (this._tokenList.lookup(0).equals(Token.ClusteredToken)) {
                unique.setClusteredWord(this._tokenList.lookup(0).getOrgValue());
                unique.clustered = true;
                this._tokenList.match();
            }
            this._tokenList.match(Token.OpenBraceToken);
            String columnName = this._tokenList.lookup((int)0).value;
            unique.columnList.add(columnName);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                columnName = this._tokenList.lookup((int)0).value;
                unique.columnList.add(columnName);
                this._tokenList.match(1);
            }
            this._tokenList.match(Token.CloseBraceToken);
            return unique;
        }
        if (this._tokenList.lookup(0).equals(Token.ForeignToken)) {
            String foreignWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            foreignWord = foreignWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.KeyToken);
            SqlTableForeignKey foreignKey = new SqlTableForeignKey(constraintName);
            foreignKey.setConstraintWord(constraintWord);
            foreignKey.setForeignWord(foreignWord);
            this._tokenList.match(Token.OpenBraceToken);
            String columnName = this._tokenList.lookup((int)0).value;
            foreignKey.columnList.add(columnName);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                columnName = this._tokenList.lookup((int)0).value;
                foreignKey.columnList.add(columnName);
                this._tokenList.match(1);
            }
            this._tokenList.match(Token.CloseBraceToken);
            foreignKey.setForeignWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(Token.ReferencesToken);
            foreignKey.refTableName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            this._tokenList.match(Token.OpenBraceToken);
            String refColumnName = this._tokenList.lookup((int)0).value;
            foreignKey.refColumnList.add(refColumnName);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                refColumnName = this._tokenList.lookup((int)0).value;
                foreignKey.refColumnList.add(refColumnName);
                this._tokenList.match(1);
            }
            this._tokenList.match(Token.CloseBraceToken);
            return foreignKey;
        }
        if (this._tokenList.lookup(0).equals(Token.CheckToken)) {
            String checkWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlTableCheck check = new SqlTableCheck(constraintName);
            check.setCheckWord(checkWord);
            check.setConstraintWord(constraintWord);
            this._tokenList.match(Token.OpenBraceToken);
            SqlExprParser exprParser = new SqlExprParser(this._tokenList);
            check.expr = exprParser.expr();
            this._tokenList.match(Token.CloseBraceToken);
            return check;
        }
        return null;
    }

    public final void parseColumnDefList(Collection columnList) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
            return;
        }
        SqlColumnDef columnItem = this.parseColumnDef();
        columnList.add(columnItem);
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.ConstraintToken) || this._tokenList.lookup(0).equals(Token.PrimaryToken) || this._tokenList.lookup(0).equals(Token.UnionToken) || this._tokenList.lookup(0).equals(Token.ForeignToken) || this._tokenList.lookup(0).equals(Token.CheckToken)) {
                return;
            }
            columnItem = this.parseColumnDef();
            columnList.add(columnItem);
        }
    }

    public final SqlColumnDef parseColumnDef() throws ParserException {
        String nullWord;
        String columnName = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        String dataType = this._tokenList.lookup((int)0).value.toUpperCase();
        String orgDataTypeWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match();
        SqlColumnDef column = new SqlColumnDef();
        column.name = columnName;
        column.dataType = dataType;
        column.setOrgDataTypeWord(orgDataTypeWord);
        if (dataType.equals("INT") || dataType.equals("INTEGER")) {
            if (this._tokenList.lookup(0).equals(Token.IdentityToken)) {
                this._tokenList.match(3);
                this._tokenList.match(5);
                this._tokenList.match(8);
                this._tokenList.match(5);
                this._tokenList.match(8);
                this._tokenList.match(5);
                column.dataType = "INT";
                column.autoIncrement = true;
            } else {
                column.dataType = "INT";
            }
            column.length = 4;
        } else if (dataType.equals("BIGINT")) {
            column.length = 20;
            column.dataType = "BIGINT";
        } else if (dataType.equalsIgnoreCase("GEOMETRY")) {
            column.dataType = "GEOMETRY";
        } else if (dataType.equalsIgnoreCase("GEOGRAPHY")) {
            column.dataType = "GEOGRAPHY";
        } else if (dataType.equals("SMALLINT")) {
            column.length = 2;
        } else if (dataType.equals("DECIMAL") || dataType.equals("NUMBER") || dataType.equals("NUMERIC")) {
            column.dataType = "DECIMAL";
            column.length = 9;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match();
                column.precision = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    column.scale = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    this._tokenList.match(8);
                }
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("CHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (column.length > 254) {
                throw new ParserException("the max lenght of the data type 'char' is 254, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("NCHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (column.length > 254) {
                throw new ParserException("the max lenght of the data type 'nchar' is 254, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("VARCHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (column.length > 4000) {
                throw new ParserException("the max lenght of the data type 'varchar' is 4000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("NVARCHAR")) {
            this._tokenList.match(Token.OpenBraceToken);
            column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (column.length > 2000) {
                throw new ParserException("the max lenght of the data type 'nvarchar' is 2000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("DATETIME")) {
            DisCardUtil.discard();
        } else if (dataType.equals("TIMESTAMP")) {
            column.dataType = "DATETIME";
        } else if (dataType.equals("BINARY")) {
            this._tokenList.match(Token.OpenBraceToken);
            column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (column.length > 2000) {
                throw new ParserException("the max lenght of the data type 'binary' is 2000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("VARBINARY")) {
            this._tokenList.match(Token.OpenBraceToken);
            column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
            if (column.length > 2000) {
                throw new ParserException("the max lenght of the data type 'varbinary' is 2000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(8);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (dataType.equals("BLOG")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("CLOB")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                if (column.length > 0x40000000) {
                    throw new ParserException("the max lenght of the data type 'CLOB' is 1073741824, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                }
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("NCLOB")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("SMALLINT")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                column.length = 1;
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else if (dataType.equals("BLOB")) {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                column.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match(8);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else {
            throw new ParserException("NOT SUPPORT DATA TYPE '" + dataType + "', at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
        }
        if (this._tokenList.lookup(0).equals(Token.CollateToken)) {
            column.setCollateWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(Token.CollateToken);
            column.collateName = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
        }
        if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            nullWord = this._tokenList.lookup(0).getOrgValue() + " " + this._tokenList.lookup(1).getOrgValue();
            column.setNullWord(nullWord);
            this._tokenList.match();
            this._tokenList.match(Token.NullToken);
            column.allowNull = Boolean.FALSE;
        } else if (this._tokenList.lookup(0).equals(Token.NullToken)) {
            column.setNullWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.allowNull = Boolean.TRUE;
        }
        if (this._tokenList.lookup(0).equals(Token.DefaultToken)) {
            column.setDefaultWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            boolean braceFlag = false;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                braceFlag = true;
            }
            SqlExprParser exprParser = new SqlExprParser(this._tokenList);
            column.defaultValueExpr = exprParser.expr();
            if (braceFlag) {
                this._tokenList.match(Token.CloseBraceToken);
            }
        }
        if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            nullWord = this._tokenList.lookup(0).getOrgValue() + " " + this._tokenList.lookup(1).getOrgValue();
            column.setNullWord(nullWord);
            this._tokenList.match();
            this._tokenList.match(Token.NullToken);
            column.allowNull = Boolean.FALSE;
        } else if (this._tokenList.lookup(0).equals(Token.NullToken)) {
            column.setNullWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.allowNull = Boolean.TRUE;
        }
        if (this._tokenList.lookup(0).equals(Token.ConstraintToken)) {
            column.setConstraintWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.containtName = this._tokenList.lookup((int)0).value;
            if (column.containtName.length() > 18 && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
                throw new ParserException("constraintName name is too long. max length is 18, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
            this._tokenList.match(1);
        }
        if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            nullWord = this._tokenList.lookup(0).getOrgValue() + " " + this._tokenList.lookup(1).getOrgValue();
            column.setNullWord(nullWord);
            this._tokenList.match();
            this._tokenList.match(Token.NullToken);
            column.allowNull = Boolean.FALSE;
        } else if (this._tokenList.lookup(0).equals(Token.NullToken)) {
            column.setNullWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.allowNull = Boolean.TRUE;
        }
        if (this._tokenList.lookup((int)0).value.equalsIgnoreCase("AUTO_INCREMENT")) {
            column.autoIncrement = true;
            this._tokenList.match();
        }
        if (column.containtName == null && this._tokenList.lookup(0).equals(Token.ConstraintToken)) {
            column.setConstraintWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.containtName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
        }
        if (this._tokenList.lookup(0).equals(Token.PrimaryToken)) {
            String primaryWord = this._tokenList.lookup(0).getOrgValue() + " " + this._tokenList.lookup(1).getOrgValue();
            column.setPrimaryWord(primaryWord);
            this._tokenList.match();
            this._tokenList.match(Token.KeyToken);
            column.isPrimaryKey = true;
            column.clustered = true;
            if (this._tokenList.lookup(0).equals(Token.NonClusteredToken)) {
                column.setClusteredWord(this._tokenList.lookup(0).getOrgValue());
                column.clustered = false;
                this._tokenList.match();
            }
        }
        if (this._tokenList.lookup(0).equals(Token.UniqueToken)) {
            column.setUniqueWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.isUnique = true;
            column.clustered = false;
            if (this._tokenList.lookup(0).equals(Token.ClusteredToken)) {
                column.setClusteredWord(this._tokenList.lookup(0).getOrgValue());
                column.clustered = true;
                this._tokenList.match();
            }
        }
        if (this._tokenList.lookup(0).equals(Token.ForeignToken)) {
            column.setForeignWord(this._tokenList.lookup(0).getOrgValue() + " " + this._tokenList.lookup(1).getOrgValue());
            this._tokenList.match();
            this._tokenList.match(Token.KeyToken);
            column.setReferencesWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(Token.ReferencesToken);
            column.refTableName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            this._tokenList.match(Token.OpenBraceToken);
            column.refColumnName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            this._tokenList.match(Token.CloseBraceToken);
        } else if (this._tokenList.lookup(0).equals(Token.ReferencesToken)) {
            column.setReferencesWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            column.refTableName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            this._tokenList.match(Token.OpenBraceToken);
            column.refColumnName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            this._tokenList.match(Token.CloseBraceToken);
        }
        if (this._tokenList.lookup(0).equals(Token.CheckToken)) {
            column.setCheckWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            SqlExprParser exprParser = new SqlExprParser(this._tokenList);
            column.checkExpr = exprParser.expr();
            this._tokenList.match(Token.CloseBraceToken);
        }
        return column;
    }
}

