/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.parser;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.ksql.dom.SqlDelete;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlVarRefExpr;
import kd.bos.ksql.dom.stmt.CallStmt;
import kd.bos.ksql.dom.stmt.SqlAlterViewStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCreateViewStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropFunctionStmt;
import kd.bos.ksql.dom.stmt.SqlDropIndexStmt;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.dom.stmt.SqlDropTriggerStmt;
import kd.bos.ksql.dom.stmt.SqlDropViewStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSelectStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlTrancateTableStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.AlterTableParser;
import kd.bos.ksql.parser.DeleteParser;
import kd.bos.ksql.parser.InsertParser;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SelectParser;
import kd.bos.ksql.parser.SqlBlockParser;
import kd.bos.ksql.parser.SqlCreateTableParser;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.parser.SqlParserBase;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.parser.TokenList;
import kd.bos.ksql.parser.UpdateParser;
import kd.bos.util.DisCardUtil;

public class SqlStmtParser
extends SqlParserBase {
    private final TokenList _tokenList;

    public SqlStmtParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
    }

    public SqlStmtParser(TokenList tokenList) {
        this._tokenList = tokenList;
    }

    public final void stmtList(Collection stmtCol, Token tok) throws ParserException {
        SqlStmt stmt = this.stmt();
        if (stmt != null) {
            stmtCol.add(stmt);
        }
        if (this._tokenList.lookup(0).equals(Token.SemicolonToken)) {
            this._tokenList.match();
        }
        while (!this._tokenList.lookup(0).equals(tok) && this._tokenList.lookup((int)0).type != 12) {
            stmt = this.stmt();
            if (this._tokenList.lookup(0).equals(Token.SemicolonToken)) {
                this._tokenList.match();
            }
            if (stmt != null) {
                stmtCol.add(stmt);
                continue;
            }
            throw new ParserException("Error", 0, 0);
        }
    }

    public final SqlStmt stmt() throws ParserException {
        Token token = this._tokenList.lookup(0);
        if (token.type == 16) {
            this._tokenList.next();
            SqlStmt stmt = this.stmt();
            stmt.addReverseComments(token.value);
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.SelectToken) || this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            SqlSelectBase select = this.select();
            return new SqlSelectStmt(select);
        }
        if (this._tokenList.lookup(0).equals(Token.UpdateToken)) {
            SqlUpdate update = this.update();
            return new SqlUpdateStmt(update);
        }
        if (this._tokenList.lookup(0).equals(Token.InsertToken)) {
            InsertParser parser = new InsertParser(this._tokenList);
            SqlInsert sqlInsert = parser.insert();
            return new SqlInsertStmt(sqlInsert);
        }
        if (this._tokenList.lookup(0).equals(Token.DeleteToken)) {
            DeleteParser parser = new DeleteParser(this._tokenList);
            SqlDelete sqlDelete = parser.parse_delete();
            return new SqlDeleteStmt(sqlDelete);
        }
        if (this._tokenList.lookup(0).equals(Token.IfToken)) {
            return this.parseIf();
        }
        if (this._tokenList.lookup(0).equals(Token.WhileToken)) {
            return this.parseWhile();
        }
        if (this._tokenList.lookup(0).equals(Token.SetToken)) {
            return this.parseSet();
        }
        if (this._tokenList.lookup(0).equals(Token.CreateToken)) {
            return this.parseCreate();
        }
        if (this._tokenList.lookup(0).equals(Token.AlterToken)) {
            if (this._tokenList.lookup(1).equals(Token.TableToken)) {
                AlterTableParser parser = new AlterTableParser(this._tokenList);
                return parser.parse();
            }
            if (this._tokenList.lookup(1).equals(Token.ViewToken)) {
                this._tokenList.match();
                this._tokenList.match();
                String viewName = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
                this._tokenList.match(Token.AsToken);
                SelectParser selectParser = new SelectParser(this._tokenList);
                SqlSelectBase select = selectParser.select();
                return new SqlAlterViewStmt(select, viewName);
            }
            throw new ParserException("not support token:" + this._tokenList.lookup(1));
        }
        if (this._tokenList.lookup(0).equals(Token.CursorLoopToken)) {
            return this.ksql_cursor_loop();
        }
        if (this._tokenList.lookup(0).equals(Token.KSqlFetchToken)) {
            return this.ksql_fetch();
        }
        if (this._tokenList.lookup(0).equals(Token.DropToken)) {
            return this.drop();
        }
        if (this._tokenList.lookup(0).equals(Token.DeclareToken) || this._tokenList.lookup(0).equals(Token.BeginToken)) {
            SqlBlockParser blockParser = new SqlBlockParser(this._tokenList);
            return blockParser.block();
        }
        if (this._tokenList.lookup(0).equals(Token.KSqlBlockToken)) {
            SqlBlockParser blockParser = new SqlBlockParser(this._tokenList);
            return blockParser.block();
        }
        if (this._tokenList.lookup(0).equals(Token.CloseToken)) {
            this._tokenList.match();
            SqlCloseStmt stmt = new SqlCloseStmt();
            stmt.curName = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.OpenToken)) {
            this._tokenList.match();
            SqlOpenStmt stmt = new SqlOpenStmt();
            stmt.curName = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.DeallocateToken)) {
            this._tokenList.match();
            SqlDeallocateStmt stmt = new SqlDeallocateStmt();
            stmt.curName = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.BreakToken)) {
            this._tokenList.match();
            return new SqlBreakStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.ContinueToken)) {
            this._tokenList.match();
            return new SqlContinueStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.GotoToken)) {
            this._tokenList.match();
            SqlGotoStmt stmt = new SqlGotoStmt();
            stmt.name = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.LabelToken)) {
            this._tokenList.match();
            SqlLabelStmt stmt = new SqlLabelStmt();
            stmt.name = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            this._tokenList.match(Token.ColonToken);
            if (this._tokenList.lookup(0).equals(Token.NullToken)) {
                this._tokenList.match();
                this._tokenList.match(Token.SemicolonToken);
                stmt.isNullLable = true;
            }
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.ExecToken) || this._tokenList.lookup(0).equals(Token.ExecuteToken)) {
            String execWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlExecStmt execStmt = new SqlExecStmt();
            execStmt.processName = this._tokenList.lookup((int)0).value;
            execStmt.setOrgProcessName(this._tokenList.lookup(0).getOrgValue());
            execStmt.setExecWord(execWord);
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                execStmt.processName = execStmt.processName + "." + this._tokenList.lookup((int)0).value;
                execStmt.setOrgProcessName(execStmt.getOrgProcessName() + "." + this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match(1);
            }
            SqlExprParser exprParser = new SqlExprParser(this._tokenList);
            exprParser.exprList(execStmt.paramList);
            return execStmt;
        }
        if (this._tokenList.lookup(0).equals(Token.TruncateToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.TableToken);
            StringBuilder tableName = new StringBuilder();
            tableName.append(this._tokenList.lookup((int)0).value);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                tableName.append(this._tokenList.lookup((int)0).value);
                this._tokenList.match(1);
            }
            return new SqlTrancateTableStmt(tableName.toString());
        }
        if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
            this._tokenList.match();
            CallStmt callStmt = new CallStmt();
            if (this._tokenList.lookup((int)0).type == 2) {
                if (!this._tokenList.lookup((int)0).value.equals("?")) {
                    throw new ParserException("not support token:" + this._tokenList.lookup(0));
                }
                callStmt.returnExpr = new SqlVarRefExpr("?");
                this._tokenList.match();
                this._tokenList.match(Token.EqualToken);
            }
            this._tokenList.match(Token.CallToken);
            String procName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                procName = procName + '.' + this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
            }
            callStmt.procName = procName;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match();
                SqlExprParser exprParser = new SqlExprParser(this._tokenList);
                exprParser.exprList(callStmt.paramList);
                this._tokenList.match(Token.CloseBraceToken);
            }
            this._tokenList.match(Token.CloseCurlyBraceToken);
            return callStmt;
        }
        if (this._tokenList.lookup((int)0).type == 1 && "show".equalsIgnoreCase(this._tokenList.lookup((int)0).value)) {
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 1 && "tables".equalsIgnoreCase(this._tokenList.lookup((int)0).value)) {
                this._tokenList.match();
                return new SqlShowTablesStmt();
            }
            if (this._tokenList.lookup((int)0).type == 1 && "columns".equalsIgnoreCase(this._tokenList.lookup((int)0).value)) {
                this._tokenList.match();
                this._tokenList.match(Token.FromToken);
                if (this._tokenList.lookup((int)0).type == 1 || this._tokenList.lookup((int)0).type == 6 || this._tokenList.lookup((int)0).type == 7) {
                    String tableName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match();
                    return new SqlShowColumnsStmt(tableName);
                }
                if (this._tokenList.lookup(0).equals(Token.NullToken)) {
                    this._tokenList.match();
                    return new SqlShowColumnsStmt(null);
                }
            } else if (this._tokenList.lookup((int)0).type == 1) {
                DisCardUtil.discard();
            }
        }
        throw new ParserException("unexcept token. token is : '" + this._tokenList.lookup((int)0).value + "', at line " + this._tokenList.lookup((int)0).beginLine + " column " + this._tokenList.lookup((int)0).beginColumn + ", token type is '" + this._tokenList.lookup(0).typename() + "'");
    }

    private SqlStmt drop() throws ParserException {
        String dropWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match();
        if (this._tokenList.lookup(0).equals(Token.TableToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            String tableName = this._tokenList.lookup((int)0).value;
            String orgTalbeName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                tableName = tableName + '.' + this._tokenList.lookup((int)0).value;
                orgTalbeName = orgTalbeName + '.' + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(1);
            }
            return new SqlDropTableStmt(tableName, orgTalbeName, dropWord);
        }
        if (this._tokenList.lookup(0).equals(Token.ViewToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            String viewName = this._tokenList.lookup((int)0).value;
            String orgViewName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                viewName = viewName + '.' + this._tokenList.lookup((int)0).value;
                orgViewName = orgViewName + '.' + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(1);
            }
            return new SqlDropViewStmt(viewName, orgViewName, dropWord);
        }
        if (this._tokenList.lookup(0).equals(Token.TriggerToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            String triggerName = this._tokenList.lookup((int)0).value;
            String orgTriggerName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(1);
            return new SqlDropTriggerStmt(triggerName, orgTriggerName, dropWord);
        }
        if (this._tokenList.lookup(0).equals(Token.IndexToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            String tableName = this._tokenList.lookup((int)0).value;
            String orgTableName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                String indexName = this._tokenList.lookup((int)0).value;
                String orgIndexName = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(1);
                SqlDropIndexStmt sdis = new SqlDropIndexStmt(tableName, indexName);
                sdis.setDropWord(dropWord);
                sdis.setOrgIndexName(orgIndexName);
                sdis.setOrgTableName(orgTableName);
                return sdis;
            }
            throw new ParserException("ERROR");
        }
        if (this._tokenList.lookup(0).equals(Token.FunctionToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            String functionName = this._tokenList.lookup((int)0).value;
            String orgFunctionName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(1);
            SqlDropFunctionStmt sdfs = new SqlDropFunctionStmt(functionName);
            sdfs.setDropWord(dropWord);
            sdfs.setOrgFunctionName(orgFunctionName);
            return sdfs;
        }
        throw new ParserException("Not support '" + this._tokenList.lookup((int)0).value.toString() + "'");
    }

    private SqlStmt ksql_cursor_loop() throws ParserException {
        this._tokenList.match();
        SqlCursorLoopStmt stmt = new SqlCursorLoopStmt();
        stmt.curName = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        SqlExprParser exprParser = new SqlExprParser(this._tokenList);
        if (stmt.fieldList == null) {
            stmt.fieldList = new ArrayList();
        }
        this._tokenList.match(Token.OpenBraceToken);
        exprParser.exprList(stmt.fieldList);
        this._tokenList.match(Token.CloseBraceToken);
        this._tokenList.match(Token.IntoToken);
        if (stmt.intoList == null) {
            stmt.intoList = new ArrayList();
        }
        this._tokenList.match(Token.OpenBraceToken);
        exprParser.exprList(stmt.intoList);
        this._tokenList.match(Token.CloseBraceToken);
        this._tokenList.match(Token.DoToken);
        if (stmt.stmtList == null) {
            stmt.stmtList = new ArrayList();
        }
        this.stmtList(stmt.stmtList, Token.EndToken);
        this._tokenList.match();
        this._tokenList.match(Token.CursorLoopToken);
        this._tokenList.match(Token.SemicolonToken);
        return stmt;
    }

    private SqlStmt ksql_fetch() throws ParserException {
        this._tokenList.match();
        SqlFetchStmt stmt = new SqlFetchStmt();
        stmt.curName = this._tokenList.lookup((int)0).value;
        this._tokenList.match();
        SqlExprParser exprParser = new SqlExprParser(this._tokenList);
        if (stmt.fieldList == null) {
            stmt.fieldList = new ArrayList();
        }
        this._tokenList.match(Token.OpenBraceToken);
        exprParser.exprList(stmt.fieldList);
        this._tokenList.match(Token.CloseBraceToken);
        this._tokenList.match(Token.IntoToken);
        if (stmt.intoList == null) {
            stmt.intoList = new ArrayList();
        }
        this._tokenList.match(Token.OpenBraceToken);
        exprParser.exprList(stmt.intoList);
        this._tokenList.match(Token.CloseBraceToken);
        return stmt;
    }

    public final SqlSelectBase select() throws ParserException {
        SelectParser selectParser = new SelectParser(this._tokenList);
        SqlSelectBase select = selectParser.select();
        return select;
    }

    public final SqlUpdate update() throws ParserException {
        UpdateParser updateParser = new UpdateParser(this._tokenList);
        SqlUpdate update = updateParser.update();
        return update;
    }

    public final SqlIfStmt parseIf() throws ParserException {
        SqlStmt stmt;
        String ifWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.IfToken);
        SqlExprParser exprParser = new SqlExprParser(this._tokenList);
        SqlExpr expr = exprParser.expr();
        SqlIfStmt ifstmt = new SqlIfStmt(expr);
        ifstmt.setIfWord(ifWord);
        if (this._tokenList.lookup(0).equals(Token.BeginToken)) {
            ifstmt.setIfWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            this.stmtList(ifstmt.trueStmtList, Token.EndToken);
            ifstmt.setEndWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(Token.EndToken);
        } else {
            stmt = this.stmt();
            ifstmt.trueStmtList.add(stmt);
        }
        if (this._tokenList.lookup(0).equals(Token.ElseToken)) {
            ifstmt.setElseWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.BeginToken)) {
                ifstmt.setElseBeginWord(this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
                this.stmtList(ifstmt.falseStmtList, Token.EndToken);
                ifstmt.setElseEndWord(this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match(Token.EndToken);
            } else {
                stmt = this.stmt();
                ifstmt.falseStmtList.add(stmt);
            }
        }
        return ifstmt;
    }

    public final SqlStmt parseSet() throws ParserException {
        this._tokenList.match(Token.SetToken);
        if (this._tokenList.lookup((int)0).type == 2) {
            String varName = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            SqlVarRefExpr variant = new SqlVarRefExpr(varName);
            this._tokenList.match(Token.EqualToken);
            SqlExprParser exprParser = new SqlExprParser(this._tokenList);
            SqlExpr valueExpr = exprParser.expr();
            return new SqlSetLocalVariantStmt(variant, valueExpr);
        }
        throw new ParserException("not support token:" + this._tokenList.lookup(0), 0, 0);
    }

    public final SqlWhileStmt parseWhile() throws ParserException {
        this._tokenList.match(Token.WhileToken);
        SqlExprParser exprParser = new SqlExprParser(this._tokenList);
        SqlExpr expr = exprParser.expr();
        SqlWhileStmt whileStmt = new SqlWhileStmt(expr);
        if (whileStmt.stmtList == null) {
            whileStmt.stmtList = new ArrayList();
        }
        if (this._tokenList.lookup(0).equals(Token.BeginToken)) {
            this._tokenList.match();
            this.stmtList(whileStmt.stmtList, Token.EndToken);
            this._tokenList.match(Token.EndToken);
        } else {
            this._tokenList.match();
            SqlStmt stmt = this.stmt();
            whileStmt.stmtList.add(stmt);
        }
        return whileStmt;
    }

    public final SqlStmt parseCreate() throws ParserException {
        String createWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.CreateToken);
        if (this._tokenList.lookup(0).equals(Token.TableToken)) {
            createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
            SqlCreateTableParser parser = new SqlCreateTableParser(this._tokenList);
            SqlCreateTableStmt stmt = parser.parse();
            stmt.setCreateTableWord(createWord);
            return stmt;
        }
        if (this._tokenList.lookup(0).equals(Token.ViewToken)) {
            createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlCreateViewStmt createViewStmt = new SqlCreateViewStmt();
            createViewStmt.setCreateViewWord(createWord);
            String viewName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            createViewStmt.name = viewName;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match();
                String colName = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
                createViewStmt.columnList.add(colName);
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    colName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    createViewStmt.columnList.add(colName);
                }
                this._tokenList.match(Token.CloseBraceToken);
            }
            createViewStmt.setAsWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(Token.AsToken);
            SelectParser selectParser = new SelectParser(this._tokenList);
            createViewStmt.select = selectParser.select();
            return createViewStmt;
        }
        if (this._tokenList.lookup(0).equals(Token.ProcedureToken)) {
            this._tokenList.match();
            throw new ParserException("not support token:" + this._tokenList.lookup(0));
        }
        if (this._tokenList.lookup(0).equals(Token.FunctionToken)) {
            this._tokenList.match();
            throw new ParserException("not support token:" + this._tokenList.lookup(0));
        }
        if (this._tokenList.lookup(0).equals(Token.IndexToken)) {
            return this.parseCreateIndex(createWord);
        }
        if (this._tokenList.lookup(0).equals(Token.UniqueToken)) {
            return this.parseCreateUniqueIndex(createWord);
        }
        if (this._tokenList.lookup(0).equals(Token.ClusteredToken)) {
            return this.parseCreateClusteredIndex(createWord);
        }
        if (this._tokenList.lookup(0).equals(Token.TriggerToken)) {
            this._tokenList.match();
            throw new ParserException("not support token:" + this._tokenList.lookup(0));
        }
        throw new ParserException("not support token:" + this._tokenList.lookup(0));
    }

    private SqlStmt parseCreateClusteredIndex() throws ParserException {
        return this.parseCreateClusteredIndex("CREATE");
    }

    private SqlStmt parseCreateClusteredIndex(String createWord) throws ParserException {
        createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match();
        createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.IndexToken);
        String indexName = this._tokenList.lookup((int)0).value;
        if (indexName.length() > 18 && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
            throw new ParserException("indexName name is too long. max length is 18, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
        }
        this._tokenList.match(1);
        String onWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.OnToken);
        String tableName = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        SqlCreateIndexStmt stmt = new SqlCreateIndexStmt(indexName, 1);
        stmt.setCreateIndexWord(createWord);
        stmt.setOnWord(onWord);
        stmt.tableName = tableName;
        SqlExprParser parser = new SqlExprParser(this._tokenList);
        do {
            this._tokenList.match();
            stmt.itemList.add(this.parseOrderByMode(parser));
        } while (this._tokenList.lookup(0).equals(Token.CommaToken));
        this._tokenList.match(Token.CloseBraceToken);
        return stmt;
    }

    private SqlStmt parseCreateIndex() throws ParserException {
        return this.parseCreateIndex("CREATE");
    }

    private SqlStmt parseCreateIndex(String createWord) throws ParserException {
        createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match();
        String indexName = this._tokenList.lookup((int)0).value;
        if (indexName.length() > 18 && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
            throw new ParserException("indexName name is too long. max length is 18, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
        }
        this._tokenList.match(1);
        String onWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.OnToken);
        String tableName = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        SqlCreateIndexStmt stmt = new SqlCreateIndexStmt(indexName);
        stmt.setCreateIndexWord(createWord);
        stmt.setOnWord(onWord);
        stmt.tableName = tableName;
        SqlExprParser parser = new SqlExprParser(this._tokenList);
        do {
            this._tokenList.match();
            stmt.itemList.add(this.parseOrderByMode(parser));
        } while (this._tokenList.lookup(0).equals(Token.CommaToken));
        this._tokenList.match(Token.CloseBraceToken);
        return stmt;
    }

    private SqlStmt parseCreateUniqueIndex() throws ParserException {
        return this.parseCreateUniqueIndex("CREATE");
    }

    private SqlStmt parseCreateUniqueIndex(String createWord) throws ParserException {
        int indexEnum = 0;
        createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match();
        String indexName = this._tokenList.lookup(0).getOrgValue();
        if ("CLUSTERED".equalsIgnoreCase(indexName)) {
            createWord = createWord + " " + indexName;
            this._tokenList.match();
            indexEnum = 10;
        } else if ("NONCLUSTERED".equalsIgnoreCase(indexName)) {
            createWord = createWord + " " + indexName;
            this._tokenList.match();
        }
        createWord = createWord + " " + this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.IndexToken);
        indexName = this._tokenList.lookup((int)0).value;
        if (indexName.length() > 30 && this._tokenList.getSqlParser().isThrowExWhenNameTooLong()) {
            throw new ParserException("indexName name is too long. max length is 30, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
        }
        this._tokenList.match(1);
        String onWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.OnToken);
        String tableName = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        SqlCreateIndexStmt stmt = new SqlCreateIndexStmt(indexName, indexEnum);
        stmt.setCreateIndexWord(createWord);
        stmt.setOnWord(onWord);
        stmt.tableName = tableName;
        SqlExprParser parser = new SqlExprParser(this._tokenList);
        do {
            this._tokenList.match();
            stmt.itemList.add(this.parseOrderByMode(parser));
        } while (this._tokenList.lookup(0).equals(Token.CommaToken));
        this._tokenList.match(Token.CloseBraceToken);
        return stmt;
    }

    private SqlOrderByItem parseOrderByMode(SqlExprParser parser) throws ParserException {
        SqlOrderByItem orderByItem;
        String chineseOBN = null;
        int chineseOrderByMode = -1;
        SqlExpr expr = null;
        expr = parser.expr();
        if (this._tokenList.lookup(0).equals(Token.PinYinToken)) {
            chineseOBN = this._tokenList.lookup(0).getOrgValue();
            chineseOrderByMode = 2;
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.StrokeToken)) {
            chineseOBN = this._tokenList.lookup(0).getOrgValue();
            chineseOrderByMode = 3;
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.RadicalToken)) {
            chineseOBN = this._tokenList.lookup(0).getOrgValue();
            chineseOrderByMode = 4;
            this._tokenList.match();
        } else {
            chineseOrderByMode = -1;
        }
        if (this._tokenList.lookup(0).equals(Token.AscToken)) {
            orderByItem = new SqlOrderByItem(expr, 0, chineseOrderByMode);
            orderByItem.setOrgOrderByName(this._tokenList.lookup(0).getOrgValue());
            orderByItem.setOrgChineseOrderByType(chineseOBN);
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.DescToken)) {
            orderByItem = new SqlOrderByItem(expr, 1, chineseOrderByMode);
            orderByItem.setOrgOrderByName(this._tokenList.lookup(0).getOrgValue());
            orderByItem.setOrgChineseOrderByType(chineseOBN);
            this._tokenList.match();
        } else {
            orderByItem = new SqlOrderByItem(expr, 0, chineseOrderByMode);
            orderByItem.setOrgOrderByName("");
            orderByItem.setOrgChineseOrderByType(chineseOBN);
        }
        return orderByItem;
    }
}

