/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.rebuild;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.ksql.dom.SqlDelete;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.rebuild.SqlReBuilderManager;
import kd.bos.ksql.util.LRUCacheMap;

public final class SqlStmtRebuilder {
    private static final Map<Long, SqlLongExpr> valueExprMap = new ConcurrentHashMap<Long, SqlLongExpr>();
    private static final Map<String, SqlBinaryOpExpr> exprExprMap = Collections.synchronizedMap(new LRUCacheMap(4096));

    public static void rebuild(SqlCreateTableStmt stmt) {
        if (SqlReBuilderManager.isEnable() && !SqlReBuilderManager.getReBuilder().isIgnoreAppendColumn(stmt.name)) {
            stmt.columnList.add(SqlReBuilderManager.getReBuilder().getAppendSqlColumnDef());
        }
    }

    public static SqlExpr rebuild(SqlExpr condition, SqlObject stmt) {
        Long value;
        if (SqlReBuilderManager.isEnable() && (value = SqlReBuilderManager.getReBuilder().getColumnValueProvider().get()) != null) {
            if (stmt instanceof SqlSelectBase) {
                if (stmt instanceof SqlSelect) {
                    condition = SqlStmtRebuilder.appendCondition(condition, ((SqlSelect)stmt).tableSource, value);
                } else {
                    condition = SqlStmtRebuilder.rebuild(condition, ((SqlUnionSelect)stmt).left);
                    condition = SqlStmtRebuilder.rebuild(condition, ((SqlUnionSelect)stmt).right);
                }
            } else if (stmt instanceof SqlDelete) {
                condition = SqlStmtRebuilder.appendCondition(condition, ((SqlDelete)stmt).tableSource, value);
            } else if (stmt instanceof SqlUpdate) {
                condition = SqlStmtRebuilder.appendCondition(condition, ((SqlUpdate)stmt).updateTable, value);
                if (((SqlUpdate)stmt).tableSource != null) {
                    condition = SqlStmtRebuilder.appendCondition(condition, ((SqlUpdate)stmt).tableSource, value);
                }
            }
        }
        return condition;
    }

    public static void rebuild(SqlInsert insert) {
        Long value;
        if (SqlReBuilderManager.isEnable() && !SqlReBuilderManager.getReBuilder().isIgnoreAppendColumn(insert.tableName) && (value = SqlReBuilderManager.getReBuilder().getColumnValueProvider().get()) != null) {
            insert.columnList.add(SqlReBuilderManager.getReBuilder().getColumnExpr());
            if (insert.subQuery != null) {
                SqlStmtRebuilder.addSelectColumn(insert.subQuery, value);
            } else {
                insert.valueList.add(SqlStmtRebuilder.getSqlLongExpr(value));
            }
        }
    }

    private static void addSelectColumn(SqlSelectBase select, Long value) {
        if (select instanceof SqlSelect) {
            ((SqlSelect)select).selectList.add(new SqlSelectItem(SqlStmtRebuilder.getSqlLongExpr(value), null));
        } else {
            SqlStmtRebuilder.addSelectColumn(((SqlUnionSelect)select).left, value);
            SqlStmtRebuilder.addSelectColumn(((SqlUnionSelect)select).right, value);
        }
    }

    private static SqlExpr appendCondition(SqlExpr condition, SqlTableSourceBase tableSource, Long value) {
        if (tableSource == null) {
            return condition;
        }
        if (tableSource instanceof SqlTableSource) {
            if (!SqlReBuilderManager.getReBuilder().isIgnoreAppendColumn(((SqlTableSource)tableSource).name)) {
                SqlBinaryOpExpr exp = SqlStmtRebuilder.createAppendConditionExpr(tableSource.alias, value);
                condition = condition == null ? exp : new SqlBinaryOpExpr(exp, 7, condition);
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            condition = SqlStmtRebuilder.appendCondition(condition, ((SqlJoinedTableSource)tableSource).left, value);
            condition = SqlStmtRebuilder.appendCondition(condition, ((SqlJoinedTableSource)tableSource).right, value);
        } else if (!(tableSource instanceof SqlSubQueryTableSource)) {
            throw new UnsupportedOperationException("Unsupported table source: " + tableSource);
        }
        return condition;
    }

    static SqlLongExpr getSqlLongExpr(Long value) {
        SqlLongExpr expr = valueExprMap.get(value);
        if (expr == null) {
            expr = valueExprMap.computeIfAbsent(value, v -> new SqlLongExpr((long)v));
        }
        return expr;
    }

    private static SqlBinaryOpExpr createAppendConditionExpr(String alias, Long value) {
        String s = alias == null ? SqlReBuilderManager.getReBuilder().getAppendSqlColumnDef().name + '=' + value : alias + '.' + SqlReBuilderManager.getReBuilder().getAppendSqlColumnDef().name + '=' + value;
        SqlBinaryOpExpr expr = exprExprMap.get(s);
        if (expr == null) {
            expr = exprExprMap.computeIfAbsent(s, k -> {
                try {
                    return (SqlBinaryOpExpr)new SqlExprParser((String)k).expr();
                }
                catch (ParserException e) {
                    throw new RuntimeException("parse " + k + " error", e);
                }
            });
        }
        return expr;
    }
}

