/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.ksql.KSqlUtil;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.KDDriver;
import kd.bos.ksql.shell.nologging.NoLoggingProcess;
import kd.bos.ksql.shell.trace.KSqlMonitor;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.security.KDReflection;

public final class KDDriverUtil {
    private static Map<String, Connector> conCreatorMap = new ConcurrentHashMap<String, Connector>();
    private static Map<Integer, Driver> driverMap = new ConcurrentHashMap<Integer, Driver>();

    private static Connector createConnector(String url, Properties properties) {
        String password;
        if (url.startsWith("jdbc:ksqle:")) {
            url = KSqlUtil.decodeUrl(url);
        }
        if (!url.startsWith("jdbc:ksql:")) {
            return null;
        }
        String user = properties.getProperty("user");
        if (user != null && user.startsWith("ksqle:")) {
            user = KSqlUtil.decodePassword(user);
            properties.put("user", user);
        }
        if ((password = properties.getProperty("password")) != null && password.startsWith("ksqle:")) {
            password = KSqlUtil.decodePassword(password);
            properties.put("password", password);
        }
        int tempRecycleTime = 0x6DDD00;
        if (properties.getProperty("recycletime") != null) {
            tempRecycleTime = Integer.parseInt(properties.getProperty("recycletime"));
        }
        try {
            TraceInfo traceInfo = KSqlMonitor.getTraceInfo(url);
            if (traceInfo == null) {
                traceInfo = KSqlUtil.parseURL(url, tempRecycleTime);
                KSqlMonitor.putTraceInfo(url, traceInfo);
                KSqlUtil.setOptimizeMode(traceInfo.OptimizeMode);
            } else {
                traceInfo = (TraceInfo)traceInfo.clone();
            }
            traceInfo.password = password;
            traceInfo.userName = user;
            return new Connector(traceInfo, properties);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Connection connect(String url, Properties properties) throws SQLException {
        Class callerClass;
        if (KDReflection.isEnableSecurity() && !KDDriver.class.isAssignableFrom(callerClass = KDReflection.getCallerClass()) && !"kd.bos.monitor.testspeed.KDConnectionSpeedTest".equals(callerClass.getName())) {
            String msg = Resources.getString((String)"bos-ksql", (String)"KDDriverUtil_0", null) + callerClass.getName() + "#" + KDReflection.getCallerMethodName();
            throw KDReflection.securityException((String)msg);
        }
        String key = url + "#" + properties.getProperty("user");
        Connector connector = conCreatorMap.computeIfAbsent(key, akey -> KDDriverUtil.createConnector(url, properties));
        return connector == null ? null : connector.connect();
    }

    private static class Connector {
        private TraceInfo traceInfo;
        private Properties properties;
        private Driver driver;

        private Connector(TraceInfo traceInfo, Properties properties) throws SQLException {
            this.traceInfo = traceInfo;
            this.properties = properties;
            this.driver = driverMap.computeIfAbsent(traceInfo.dbType, dbType -> {
                try {
                    return (Driver)Class.forName(traceInfo.driverName).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Create driver instance  " + traceInfo.driverName + " failed: " + e.getMessage(), e);
                }
            });
        }

        private Connection connect() throws SQLException {
            if (this.traceInfo != null && this.properties.containsKey("routeKey")) {
                this.traceInfo.setRouteKey(this.properties.getProperty("routeKey"));
            }
            Connection con = this.driver.connect(this.traceInfo.originalUrl, this.properties);
            KDConnection kdConn = new KDConnection(con, this.traceInfo.dbType, this.traceInfo);
            NoLoggingProcess.processKDConnection(kdConn);
            return kdConn;
        }
    }
}

