/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.trace.client;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import kd.bos.ksql.shell.trace.LogItem;
import kd.bos.ksql.shell.trace.client.ITraceListener;

public class TraceClient {
    public static final int DEFAULT_PORT = 9791;
    private int port;
    private Socket socket;
    private String hostname;
    private Thread thread;

    public TraceClient(String hostname) {
        this(hostname, 9791);
    }

    public TraceClient(String hostname, int port) {
        this.port = port;
        this.hostname = hostname;
    }

    public void connect(ITraceListener listener) throws IOException {
        InetAddress addr = InetAddress.getByName(this.hostname);
        this.socket = new Socket(addr, this.port);
        InputStream in = this.socket.getInputStream();
        this.thread = new Thread(new TraceRunner(listener, in));
        this.thread.start();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    static class TraceRunner
    implements Runnable {
        private ITraceListener listener;
        private InputStream in;

        public TraceRunner(ITraceListener listener, InputStream in) {
            this.listener = listener;
            this.in = in;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    DataInputStream dataIn = new DataInputStream(this.in);
                    LogItem item = LogItem.readLogItem(dataIn);
                    this.listener.receive(item);
                }
            }
            catch (IOException e) {
                return;
            }
        }
    }
}

