/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 3126734408279148318L;
    private int cacheSize;

    public LRUCacheMap(int cacheSize) {
        this(cacheSize, 0.5f);
    }

    public LRUCacheMap(int cacheSize, float loadFactor) {
        super(cacheSize, loadFactor, true);
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

