/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kd.bos.ksql.util.UUTNException;
import kd.bos.ksql.util.UUTNSource;
import org.apache.log4j.Logger;

public class UUTN {
    public static final String GLOBAL_TEMPORARY_TABLE_PREFIX = "GZT";
    public static final String TABLE_PREFIX = "VT";
    public static final String SEQUENCE_PREFIX = "ZS";
    public static final String CONSTRAINT_PREFIX = "ZC";
    public static final String TRIGGER_PREFIX = "ZR";
    private static final Logger logger = Logger.getLogger(UUTN.class);
    public final String valueAfterMD5;
    private static SecureRandom mySecureRand = new SecureRandom();
    public static final String S_ID = UUTN.normalize(UUTNSource.getUniqueSource().hashCode());
    public final String prefix;

    public UUTN() {
        this.prefix = TABLE_PREFIX;
        this.valueAfterMD5 = this.getRandomGUID();
    }

    public UUTN(String prefix) {
        this.prefix = prefix;
        this.valueAfterMD5 = this.getRandomGUID();
    }

    public UUTN(boolean isFULL) {
        this.prefix = TABLE_PREFIX;
        this.valueAfterMD5 = this.getRandomGUID(isFULL);
    }

    public UUTN(boolean isFULL, String prefix) {
        this.prefix = prefix;
        this.valueAfterMD5 = this.getRandomGUID(isFULL);
    }

    private String getRandomGUID() throws UUTNException {
        return this.getRandomGUID(false);
    }

    private String getRandomGUID(boolean isFULL) throws UUTNException {
        MessageDigest md5 = null;
        StringBuilder sbValueBeforeMD5 = new StringBuilder();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            throw new UUTNException(e);
        }
        long time = System.currentTimeMillis();
        long rand = 0L;
        rand = mySecureRand.nextLong();
        sbValueBeforeMD5.append(S_ID);
        sbValueBeforeMD5.append(":");
        sbValueBeforeMD5.append(Long.toString(time));
        sbValueBeforeMD5.append(":");
        sbValueBeforeMD5.append(Long.toString(rand));
        String valueBeforeMD5 = sbValueBeforeMD5.toString();
        md5.update(valueBeforeMD5.getBytes());
        byte[] array = md5.digest();
        long high = (long)array[0] & 0xFFL ^ ((long)array[1] & 0xFFL) << 8 ^ ((long)array[2] & 0xFFL) << 16 ^ ((long)array[3] & 0xFFL) << 24 ^ ((long)array[4] & 0xFFL) << 32 ^ ((long)array[5] & 0xFFL) << 40 ^ ((long)array[6] & 0xFFL) << 48 ^ ((long)array[7] & 0xFFL) << 56;
        long low = 0L;
        low = isFULL ? (long)array[8] & 0xFFL ^ ((long)array[9] & 0xFFL) << 8 ^ ((long)array[10] & 0xFFL) << 16 ^ ((long)array[11] & 0xFFL) << 24 ^ ((long)array[12] & 0xFFL) << 32 ^ ((long)array[13] & 0xFFL) << 40 ^ ((long)array[14] & 0xFFL) << 48 ^ ((long)array[15] & 0xFFL) << 56 : (long)array[8] & 0xFFL ^ ((long)array[9] & 0xFFL) << 8 ^ ((long)array[10] & 0xFFL) << 16;
        return UUTN.normalize(high) + UUTN.normalize(low);
    }

    public static boolean isTempTable(String tablename) {
        return tablename != null && tablename.startsWith(TABLE_PREFIX);
    }

    public static boolean isGlobalTempTable(String tablename) {
        return tablename != null && tablename.startsWith(GLOBAL_TEMPORARY_TABLE_PREFIX);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix);
        String temp = S_ID + this.valueAfterMD5;
        if (this.prefix.equalsIgnoreCase(CONSTRAINT_PREFIX)) {
            sb.append(temp.substring(temp.length() - 16));
        } else {
            sb.append(S_ID);
            sb.append(this.valueAfterMD5);
        }
        return sb.toString();
    }

    private static final String normalize(long l) {
        return Long.toString(l, 35).toUpperCase().replaceAll("-", "Z");
    }
}

