/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.dbcp;

import bos.org.apache.commons.dbcp.DelegatingConnection;
import bos.org.apache.commons.dbcp.DelegatingPreparedStatement;
import bos.org.apache.commons.dbcp.PoolablePreparedStatement;
import bos.org.apache.commons.dbcp.SQLNestedException;
import bos.org.apache.commons.pool.KeyedObjectPool;
import bos.org.apache.commons.pool.KeyedPoolableObjectFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class PoolingConnection
extends DelegatingConnection
implements Connection,
KeyedPoolableObjectFactory {
    protected KeyedObjectPool _pstmtPool = null;
    private static final Logger logger = Logger.getLogger(PoolingConnection.class);

    public PoolingConnection(Connection c) {
        super(c);
    }

    public PoolingConnection(Connection c, KeyedObjectPool pool) {
        super(c);
        this._pstmtPool = pool;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool oldpool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                oldpool.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLNestedException("Cannot close connection", e);
            }
        }
        this.getInnermostDelegate().close();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", e);
        }
    }

    protected Object createKey(String sql, int resultSetType, int resultSetConcurrency) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (Exception e) {
            logger.error((Object)"PollingConnection createKey error", (Throwable)e);
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency);
    }

    protected Object createKey(String sql) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (Exception e) {
            logger.error((Object)"PollingConnection createKey error", (Throwable)e);
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    @Override
    public Object makeObject(Object obj) throws Exception {
        if (null == obj || !(obj instanceof PStmtKey)) {
            throw new IllegalArgumentException();
        }
        PStmtKey key = (PStmtKey)obj;
        if (null == key._resultSetType && null == key._resultSetConcurrency) {
            return new PoolablePreparedStatement(this.getDelegate().prepareStatement(key._sql), key, this._pstmtPool, this);
        }
        return new PoolablePreparedStatement(this.getDelegate().prepareStatement(key._sql, key._resultSetType, key._resultSetConcurrency), key, this._pstmtPool, this);
    }

    @Override
    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)obj).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)obj).close();
        }
    }

    @Override
    public boolean validateObject(Object key, Object obj) {
        return true;
    }

    @Override
    public void activateObject(Object key, Object obj) throws Exception {
        ((DelegatingPreparedStatement)obj).activate();
    }

    @Override
    public void passivateObject(Object key, Object obj) throws Exception {
        ((PreparedStatement)obj).clearParameters();
        ((DelegatingPreparedStatement)obj).passivate();
    }

    public String toString() {
        return "PoolingConnection: " + this._pstmtPool.toString();
    }

    class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;
        protected String _catalog = null;

        PStmtKey(String sql) {
            this._sql = sql;
        }

        PStmtKey(String sql, String catalog) {
            this._sql = sql;
            this._catalog = catalog;
        }

        PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
            this._sql = sql;
            this._resultSetType = resultSetType;
            this._resultSetConcurrency = resultSetConcurrency;
        }

        PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency) {
            this._sql = sql;
            this._catalog = catalog;
            this._resultSetType = resultSetType;
            this._resultSetConcurrency = resultSetConcurrency;
        }

        public boolean equals(Object that) {
            try {
                if (that == null) {
                    return false;
                }
                if (this == that) {
                    return true;
                }
                PStmtKey key = (PStmtKey)that;
                return (null == this._sql && null == key._sql || this._sql.equals(key._sql)) && (null == this._catalog && null == key._catalog || this._catalog.equals(key._catalog)) && (null == this._resultSetType && null == key._resultSetType || this._resultSetType.equals(key._resultSetType)) && (null == this._resultSetConcurrency && null == key._resultSetConcurrency || this._resultSetConcurrency.equals(key._resultSetConcurrency));
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            if (this._catalog == null) {
                return null == this._sql ? 0 : this._sql.hashCode();
            }
            return null == this._sql ? this._catalog.hashCode() : (this._catalog + this._sql).hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("PStmtKey: sql=");
            buf.append(this._sql);
            buf.append(", catalog=");
            buf.append(this._catalog);
            buf.append(", resultSetType=");
            buf.append(this._resultSetType);
            buf.append(", resultSetConcurrency=");
            buf.append(this._resultSetConcurrency);
            return buf.toString();
        }
    }
}

