/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.dbutils;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class DbUtils {
    public static void close(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    public static void close(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    public static void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void closeQuietly(Connection conn) {
        try {
            DbUtils.close(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Connection conn, Statement stmt, ResultSet rs) {
        DbUtils.closeQuietly(rs);
        DbUtils.closeQuietly(stmt);
        DbUtils.closeQuietly(conn);
    }

    public static void closeQuietly(ResultSet rs) {
        try {
            DbUtils.close(rs);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Statement stmt) {
        try {
            DbUtils.close(stmt);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void commitAndClose(Connection conn) throws SQLException {
        if (conn != null) {
            conn.commit();
            conn.close();
        }
    }

    public static void commitAndCloseQuietly(Connection conn) {
        try {
            DbUtils.commitAndClose(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean loadDriver(String driverClassName) {
        try {
            Class.forName(driverClassName).newInstance();
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return true;
        }
        catch (InstantiationException e) {
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void printStackTrace(SQLException sqle) {
        DbUtils.printStackTrace(sqle, new PrintWriter(System.err));
    }

    public static void printStackTrace(SQLException sqle, PrintWriter pw) {
        SQLException next = sqle;
        while (next != null) {
            next.printStackTrace(pw);
            if ((next = next.getNextException()) == null) continue;
            pw.println("Next SQLException:");
        }
    }

    public static void printWarnings(Connection connection) {
        DbUtils.printWarnings(connection, new PrintWriter(System.err));
    }

    public static void printWarnings(Connection conn, PrintWriter pw) {
        if (conn != null) {
            try {
                DbUtils.printStackTrace(conn.getWarnings(), pw);
            }
            catch (SQLException sqle) {
                DbUtils.printStackTrace(sqle, pw);
            }
        }
    }

    public static void rollback(Connection conn) throws SQLException {
        if (conn != null) {
            conn.rollback();
        }
    }
}

