/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.dbutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class ProxyFactory {
    private static final Class[] callableStatementClass = new Class[]{CallableStatement.class};
    private static final Class[] connectionClass = new Class[]{Connection.class};
    private static final Class[] driverClass = new Class[]{Driver.class};
    private static final ProxyFactory instance = new ProxyFactory();
    private static final Class[] metaClass = new Class[]{ResultSetMetaData.class};
    private static final Class[] preparedStatementClass = new Class[]{PreparedStatement.class};
    private static final Class[] resultSetClass = new Class[]{ResultSet.class};
    private static final Class[] statementClass = new Class[]{Statement.class};

    public static ProxyFactory instance() {
        return instance;
    }

    protected ProxyFactory() {
    }

    public CallableStatement createCallableStatement(InvocationHandler handler) {
        return (CallableStatement)Proxy.newProxyInstance(handler.getClass().getClassLoader(), callableStatementClass, handler);
    }

    public Connection createConnection(InvocationHandler handler) {
        return (Connection)Proxy.newProxyInstance(handler.getClass().getClassLoader(), connectionClass, handler);
    }

    public Driver createDriver(InvocationHandler handler) {
        return (Driver)Proxy.newProxyInstance(handler.getClass().getClassLoader(), driverClass, handler);
    }

    public PreparedStatement createPreparedStatement(InvocationHandler handler) {
        return (PreparedStatement)Proxy.newProxyInstance(handler.getClass().getClassLoader(), preparedStatementClass, handler);
    }

    public ResultSet createResultSet(InvocationHandler handler) {
        return (ResultSet)Proxy.newProxyInstance(handler.getClass().getClassLoader(), resultSetClass, handler);
    }

    public ResultSetMetaData createResultSetMetaData(InvocationHandler handler) {
        return (ResultSetMetaData)Proxy.newProxyInstance(handler.getClass().getClassLoader(), metaClass, handler);
    }

    public Statement createStatement(InvocationHandler handler) {
        return (Statement)Proxy.newProxyInstance(handler.getClass().getClassLoader(), statementClass, handler);
    }
}

