/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.actiondispatcher;

import com.kingdee.bos.actiondispatcher.Invoker;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActionConfig {
    private static Logger logger = Logger.getLogger(ActionConfig.class);
    private static boolean loaded = false;
    private static HashMap<String, Package> packageMap = new HashMap();
    private static HashMap<String, Object> objectMap = new HashMap();

    static synchronized void staticLoad() {
        if (loaded) {
            return;
        }
        try {
            ActionConfig.load();
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load configuration", (Throwable)e);
        }
        loaded = true;
    }

    private static void load() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = null;
        String file = System.getProperty("ActionConfigFile");
        if (file == null || !new File(file).exists()) {
            InputStream in = null;
            try {
                in = ActionConfig.class.getResourceAsStream("/actionconfig.xml");
                document = builder.parse(in);
            }
            catch (Throwable t) {
                logger.error((Object)"can't found actionconfig.xml");
                return;
            }
        } else {
            document = builder.parse(new File(file));
        }
        Element root = (Element)document.getElementsByTagName("root").item(0);
        NodeList list = root.getElementsByTagName("package");
        for (int i = 0; i < list.getLength(); ++i) {
            Element ele = (Element)list.item(i);
            ActionConfig.parsePackage(ele);
        }
    }

    private static void parsePackage(Element ele) {
        String name = ele.getAttribute("name");
        if (name == null) {
            name = "";
        }
        Package p = new Package();
        name.replace('\\', '/');
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        p.name = name;
        packageMap.put(name, p);
        NodeList list = ele.getElementsByTagName("action");
        for (int i = 0; i < list.getLength(); ++i) {
            Element child = (Element)list.item(i);
            ActionConfig.parseAction(child, p);
        }
    }

    private static void parseAction(Element child, Package p) {
        String actionName = child.getAttribute("name");
        String actionMethod = child.getAttribute("method");
        String actionClass = child.getAttribute("class");
        try {
            Class<?> clazz = Class.forName(actionClass);
            Method method = clazz.getMethod(actionMethod, new Class[0]);
            Object instance = clazz.newInstance();
            objectMap.put(actionClass, instance);
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.className = actionClass;
            methodInfo.methodName = actionMethod;
            methodInfo.method = method;
            p.actionMap.put(actionName, methodInfo);
        }
        catch (Throwable b) {
            logger.error((Object)("Error parse action " + actionName + " of package " + p.name + ", ignored."), b);
        }
    }

    public static boolean containsPackage(String _package) {
        return packageMap.containsKey(_package);
    }

    public static Invoker lookupActionInvoker(String _package, String action) {
        Package p = packageMap.get(_package);
        if (p != null) {
            MethodInfo info = p.actionMap.get(action);
            Object object = objectMap.get(info.className);
            Invoker invoker = new Invoker(object, info.method);
            return invoker;
        }
        return null;
    }

    static {
        ActionConfig.staticLoad();
    }

    private static class MethodInfo {
        String methodName;
        String className;
        Method method;

        private MethodInfo() {
        }
    }

    private static class Package {
        String name;
        Map<String, MethodInfo> actionMap = new HashMap<String, MethodInfo>();

        private Package() {
        }
    }
}

