/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.actiondispatcher;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatcherContext {
    private static ThreadLocal<DispatcherContext> t = new ThreadLocal();
    private static final String KEYS_REQUEST = "HTTPSERVLETREQUEST";
    private static final String KEYS_RESPONSE = "HTTPSERVLETRESPONSE";
    private HashMap context = new HashMap();

    public DispatcherContext(Map map) {
        this.context.putAll(map);
    }

    public DispatcherContext(HttpServletRequest request, HttpServletResponse response) {
        this.context.put(KEYS_REQUEST, request);
        this.context.put(KEYS_RESPONSE, response);
    }

    public void put(Object key, Object value) {
        this.context.put(key, value);
    }

    public Object get(Object key) {
        return this.context.get(key);
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.context.get(KEYS_REQUEST);
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.context.get(KEYS_RESPONSE);
    }

    static void setContext(HttpServletRequest request, HttpServletResponse response) {
        DispatcherContext context = new DispatcherContext(request, response);
        t.set(context);
    }

    public static HttpServletRequest getHttpServletRequest() {
        return t.get().getRequest();
    }

    public static HttpServletResponse getHttpServletResponse() {
        return t.get().getResponse();
    }

    public static void clear() {
        t.remove();
    }
}

