/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl;

import com.kingdee.bos.config.impl.SecurityPropertyReader;
import java.io.File;
import java.io.IOException;

public final class BootPath {
    public static final String INSTALL_KEY = "BOS_HOME";
    public static final String INSTANCE_KEY = "BOS_BASE";
    private static File installRoot;
    private static File instanceRoot;

    private BootPath() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized File getInstallConfigPath() {
        if (installRoot != null) {
            return installRoot;
        }
        String path = SecurityPropertyReader.getProperty(INSTALL_KEY);
        if (path == null || path.length() <= 0) throw new IllegalStateException("NO BOS_HOME define");
        File file = new File(path);
        if (!file.exists() || !file.isDirectory() || !file.canRead()) throw new IllegalStateException("BOS_HOME dir ERROR.");
        try {
            installRoot = file.getCanonicalFile();
            return installRoot;
        }
        catch (IOException iOException) {}
        return installRoot;
    }

    public static synchronized File getInstanceConfigPath() {
        if (instanceRoot != null) {
            return instanceRoot;
        }
        String path = SecurityPropertyReader.getProperty(INSTANCE_KEY, ".");
        File file = new File(path);
        if (file.exists() && file.isDirectory() && file.canRead()) {
            try {
                instanceRoot = file.getCanonicalFile();
            }
            catch (IOException iOException) {}
        } else {
            throw new IllegalStateException("BOS_BASE dir ERROR.");
        }
        return instanceRoot;
    }
}

