/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.IConfigService;
import com.kingdee.bos.config.IScopeNode;
import com.kingdee.bos.config.impl.BootPath;
import com.kingdee.bos.config.impl.DefaultScope;
import com.kingdee.bos.config.impl.FileScope;
import com.kingdee.bos.config.server.IConfigFacade;
import java.util.HashMap;
import java.util.Map;

public abstract class ConfigServiceImpl
implements IConfigService {
    private Map seenStrings = new HashMap();
    protected final DefaultScope defaultScope;
    protected final IScopeNode installScope;
    protected final IScopeNode instanceScope;
    private Thread deamonThread;
    protected Map moduleFallbackScopes = new HashMap();

    public ConfigServiceImpl() {
        this.defaultScope = new DefaultScope(this);
        this.installScope = new FileScope("install", "install", BootPath.getInstallConfigPath(), this);
        this.instanceScope = new FileScope("instance", "instance", BootPath.getInstanceConfigPath(), this);
        this.deamonThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ConfigServiceImpl.this.scan();
            }
        });
        this.deamonThread.setDaemon(true);
        this.deamonThread.setName("BOS-Config-Deamon");
        this.deamonThread.setPriority(1);
    }

    @Override
    public String get(String key, String module, IScopeNode[] scopes) {
        IScopeNode[] fallbackScopes;
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("ConfigService get() key is null");
        }
        if (module == null || module.length() == 0) {
            throw new IllegalArgumentException("ConfigService get() module is null");
        }
        key = this.internString(key);
        module = this.internString(module);
        String value = null;
        if (scopes != null) {
            for (int i = 0; i < scopes.length; ++i) {
                IScopeNode scope = scopes[i];
                value = scope.get(key, module);
                if (value == null) continue;
                return value;
            }
        }
        if ((fallbackScopes = (IScopeNode[])this.moduleFallbackScopes.get(module)) != null) {
            for (int i = 0; i < fallbackScopes.length; ++i) {
                IScopeNode scope = fallbackScopes[i];
                value = scope.get(key, module);
                if (value == null) continue;
                return value;
            }
        }
        value = this.defaultScope.get(key, module);
        return value;
    }

    @Override
    public void set(String key, String module, String value, IScopeNode scope) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("ConfigService set() key is null");
        }
        if (module == null || module.length() == 0) {
            throw new IllegalArgumentException("ConfigService set() module is null");
        }
        key = this.internString(key);
        value = this.internString(value);
        module = this.internString(module);
        scope.set(key, module, value);
    }

    public String internString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String cacheValue = (String)this.seenStrings.get(str);
        if (cacheValue == null) {
            this.seenStrings.put(str, str);
            return str;
        }
        return cacheValue;
    }

    public synchronized void moduleDefaultScopeInit(String moduleName) {
        this.defaultScope.onModuleInit(moduleName);
    }

    public IScopeNode getInstallScope() {
        return this.installScope;
    }

    public IScopeNode getInstanceScope() {
        return this.instanceScope;
    }

    public abstract IConfigFacade getFacade() throws BOSException;

    public abstract IConfigFacade getFacade(Context var1) throws BOSException;

    public void start() {
        this.deamonThread.start();
    }

    protected abstract void scan();
}

