/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl;

import com.kingdee.bos.config.IModuleNode;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import com.kingdee.bos.config.impl.FileModule;
import com.kingdee.bos.config.impl.GenericScope;
import com.kingdee.bos.config.impl.SortedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public class FileScope
extends GenericScope {
    private File installRoot;
    private static final String FILE_SUFFIX = ".conf";

    public FileScope(String level, String name, File root, ConfigServiceImpl service) {
        super(level, name, service);
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException("Config Dir[" + root.getAbsolutePath() + "] NOT OK!");
        }
        this.installRoot = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IModuleNode createModule0(String moduleName) {
        FileModule module = new FileModule(this, moduleName);
        File file = this.configFile(moduleName);
        if (file.exists() && file.isFile()) {
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                props.load(is);
                module.fill(props);
            }
            catch (IOException e) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IModuleNode initModule0(String moduleName) {
        FileModule module = new FileModule(this, moduleName);
        File file = this.configFile(moduleName);
        if (file.exists() && file.isFile()) {
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                props.load(is);
                module.fill(props);
            }
            catch (IOException e) {
                IModuleNode iModuleNode = null;
                return iModuleNode;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() {
        for (Map.Entry entry : this.modules.entrySet()) {
            FileModule module = (FileModule)entry.getValue();
            if (!module.isDerty()) continue;
            String name = (String)entry.getKey();
            File file = this.configFile(name);
            OutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(file));
                SortedProperties props = new SortedProperties();
                props.putAll((Map<?, ?>)module.getKeyValues());
                props.store(out, "BOS Config Service output");
                out.flush();
                module.clearFlag();
            }
            catch (IOException e) {}
            continue;
            finally {
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private File configFile(String moduleName) {
        String fileName = moduleName + FILE_SUFFIX;
        return new File(this.installRoot, fileName);
    }
}

