/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import com.kingdee.bos.config.impl.SessionScope;
import com.kingdee.bos.config.impl.client.ClientDcScope;
import com.kingdee.bos.config.impl.client.ClientUserScope;
import com.kingdee.bos.config.server.ConfigFacadeFactory;
import com.kingdee.bos.config.server.IConfigFacade;
import org.apache.log4j.Logger;

public class ClientConfigServiceImpl
extends ConfigServiceImpl {
    protected final SessionScope sessionScope;
    protected ClientDcScope dcScope;
    protected ClientUserScope userScope;
    private static final Logger logger = Logger.getLogger(ClientConfigServiceImpl.class);
    protected volatile boolean isLogin = false;
    private Object scopeCreateLock = new Object();
    private IConfigFacade facade;
    private static final long INTERVAL = 10000L;
    private volatile long lastScan = 0L;

    public ClientConfigServiceImpl() {
        this.sessionScope = new SessionScope("session", "session", this);
    }

    public SessionScope getSessionScope() {
        return this.sessionScope;
    }

    public ClientDcScope getDcScope() {
        return this.dcScope;
    }

    public ClientUserScope getUserScope() {
        return this.userScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canConnection2Server() {
        if (this.isLogin) {
            return true;
        }
        try {
            this.getFacade();
            Object object = this.scopeCreateLock;
            synchronized (object) {
                this.dcScope = new ClientDcScope(this);
                this.userScope = new ClientUserScope(this);
            }
            this.isLogin = true;
            return true;
        }
        catch (BOSException e) {
            return false;
        }
    }

    @Override
    public IConfigFacade getFacade() throws BOSException {
        if (this.facade == null) {
            this.facade = ConfigFacadeFactory.getRemoteInstance();
        }
        return this.facade;
    }

    @Override
    public IConfigFacade getFacade(Context ctx) throws BOSException {
        throw new IllegalStateException("Please Incoke in SERVER Side.");
    }

    @Override
    public void reset() {
        this.installScope.maintain();
        this.instanceScope.maintain();
        if (this.dcScope != null) {
            this.dcScope.maintain();
        }
        if (this.userScope != null) {
            this.userScope.maintain();
        }
        this.sessionScope.maintain();
        this.facade = null;
        this.isLogin = false;
        this.dcScope = null;
        this.userScope = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scan() {
        while (true) {
            try {
                this.installScope.maintain();
                this.instanceScope.maintain();
                Object object = this.scopeCreateLock;
                synchronized (object) {
                    if (this.dcScope != null) {
                        this.dcScope.maintain();
                    }
                    if (this.userScope != null) {
                        this.userScope.maintain();
                    }
                }
                this.sessionScope.maintain();
                this.lastScan = System.currentTimeMillis();
            }
            catch (Throwable _) {
                logger.warn((Object)_.getMessage(), _);
            }
            long sleep = 10000L;
            do {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((sleep = sleep + this.lastScan - System.currentTimeMillis()) > 100L);
        }
    }
}

