/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.IModuleNode;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import com.kingdee.bos.config.impl.GenericScope;
import com.kingdee.bos.config.impl.server.LoggedModule;
import com.kingdee.bos.config.server.IConfigFacade;
import java.util.Map;

public class ServerDcScope
extends GenericScope {
    private final Context ctx;

    public ServerDcScope(Context ctx, ConfigServiceImpl service) {
        super("dc", "ServerDC", service);
        this.ctx = ctx;
    }

    @Override
    protected IModuleNode createModule0(String moduleName) {
        Map keyValues = null;
        try {
            IConfigFacade facade = this.service.getFacade(this.ctx);
            keyValues = facade.getFromDb4Dc(moduleName);
        }
        catch (BOSException e) {
            // empty catch block
        }
        LoggedModule module = new LoggedModule(this, moduleName);
        module.fill(keyValues);
        return module;
    }

    @Override
    protected IModuleNode initModule0(String moduleName) {
        Map keyValues = null;
        try {
            IConfigFacade facade = this.service.getFacade(this.ctx);
            keyValues = facade.getFromDb4Dc(moduleName);
        }
        catch (BOSException e) {
            // empty catch block
        }
        if (keyValues == null || keyValues.isEmpty()) {
            return null;
        }
        LoggedModule module = new LoggedModule(this, moduleName);
        module.fill(keyValues);
        return module;
    }

    @Override
    public synchronized void flush() {
        for (Map.Entry entry : this.modules.entrySet()) {
            LoggedModule module = (LoggedModule)entry.getValue();
            if (!module.isDerty()) continue;
            String moduleName = module.getName();
            try {
                IConfigFacade facade = this.service.getFacade(this.ctx);
                facade.save2Db4Dc(moduleName, module.updateLogs, module.deleteLogs, module.insertLogs);
                module.clearFlag();
            }
            catch (BOSException e) {}
        }
    }

    public Map getMap(String moduleName) {
        LoggedModule module = (LoggedModule)this.getModule(moduleName);
        if (module == null) {
            return null;
        }
        return module.getKeyValues();
    }
}

