/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.config.IConfigService;
import com.kingdee.bos.config.IScopeNode;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import com.kingdee.bos.config.impl.SessionScope;

public class ServerSessionScopeWrapper
implements IScopeNode {
    public static final String SESSION_CTX_KEY = "bos.config";
    protected final ConfigServiceImpl serv;
    protected final Context ctx;

    public ServerSessionScopeWrapper(Context ctx, ConfigServiceImpl service) {
        this.ctx = ctx;
        this.serv = service;
    }

    @Override
    public synchronized String get(String key, String module) {
        Object proxy = this.ctx.get((Object)SESSION_CTX_KEY);
        if (proxy instanceof SessionScope) {
            SessionScope scope = (SessionScope)proxy;
            return scope.get(key, module);
        }
        return null;
    }

    @Override
    public synchronized void set(String key, String module, String value) {
        Object proxy = this.ctx.get((Object)SESSION_CTX_KEY);
        SessionScope scope = null;
        if (proxy instanceof SessionScope) {
            scope = (SessionScope)proxy;
        } else {
            scope = new SessionScope("session", "Server Session Scope", this.serv);
            this.ctx.put((Object)SESSION_CTX_KEY, (Object)scope);
        }
        scope.set(key, module, value);
    }

    @Override
    public String getScopeLevel() {
        return "session";
    }

    @Override
    public IConfigService getService() {
        return this.serv;
    }

    @Override
    public String getName() {
        return "ServerSession";
    }

    @Override
    public void flush() {
    }

    @Override
    public void maintain() {
        Object proxy = this.ctx.get((Object)SESSION_CTX_KEY);
        if (proxy instanceof SessionScope) {
            SessionScope scope = (SessionScope)proxy;
            scope.maintain();
        }
    }
}

