/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.listener;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.listener.app.CommonListenerCollection;
import com.kingdee.bos.config.listener.app.CommonListenerFactory;
import com.kingdee.bos.config.listener.app.CommonListenerInfo;
import com.kingdee.bos.config.listener.app.ICommonListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class CommonListenerManager
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(CommonListenerManager.class);

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent arg0) {
        try {
            String solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ConfigMDUtil.getContext()).getSolution().getFullName();
            ArrayList ids = ConfigMDUtil.getDataCenterIDs();
            for (int i = 0; i < ids.size(); ++i) {
                String ais = (String)ids.get(i);
                Context ctx = new Context(null, solution, ais, null);
                try {
                    ICommonListener cl = CommonListenerFactory.getLocalInstance(ctx);
                    CommonListenerCollection listeners = null;
                    try {
                        listeners = cl.getCollection();
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Can't get database connection: " + e.getMessage()));
                    }
                    if (listeners == null || listeners.size() == 0) continue;
                    for (int j = 0; j < listeners.size(); ++j) {
                        CommonListenerInfo listener = listeners.get(j);
                        if (!listener.isEnable()) continue;
                        String className = listener.getClassName();
                        String methodName = listener.getMethodName();
                        StringBuffer description = new StringBuffer("solution:");
                        description.append(solution);
                        description.append("\tais:");
                        description.append(ais);
                        description.append("\tCommonListenerInfo: ");
                        description.append(className);
                        description.append(".");
                        description.append(methodName);
                        logger.info((Object)("CommonListenerManager.contextInitialized begin: " + description));
                        try {
                            Class<?> clazz = Class.forName(className);
                            Method method = clazz.getMethod(methodName, Context.class);
                            method.invoke(null, ctx);
                        }
                        catch (Exception e) {
                            logger.error((Object)("CommonListenerManager.contextInitialized error: " + e.getMessage()));
                            logger.debug((Object)e, (Throwable)e);
                        }
                        logger.info((Object)("CommonListenerManager.contextInitialized end: " + description));
                    }
                    continue;
                }
                catch (Exception ex) {
                    String message = "CommonListenerManager.contextInitialized id: " + ids.get(i) + " error: " + (ex.getClass() != null ? ex.getClass().getName() : "");
                    logger.warn((Object)(message + ":" + ex.getMessage()));
                    logger.debug((Object)message, (Throwable)ex);
                }
            }
        }
        catch (Throwable e) {
            logger.warn((Object)("CommonListenerManager.contextInitialized error: " + (e.getClass() != null ? e.getClass().getName() : "") + ":" + e.getMessage()));
        }
    }

    public static void delete(Context ctx, String className, String methodName) throws BOSException {
        String oql = "where className='" + className + "' and methodName='" + methodName + "'";
        ICommonListener cl = CommonListenerFactory.getLocalInstance(ctx);
        cl.delete(oql);
    }

    public static void disable(Context ctx, String className, String methodName) throws BOSException {
        String oql = "where className='" + className + "' and methodName='" + methodName + "'";
        ICommonListener cl = CommonListenerFactory.getLocalInstance(ctx);
        CommonListenerInfo listener = cl.getValue(oql);
        listener.setEnable(false);
        cl.update((IObjectPK)new ObjectUuidPK(listener.getId()), listener);
    }

    public static void delete(String className, String methodName) throws BOSException {
        try {
            String solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ConfigMDUtil.getContext()).getSolution().getFullName();
            ArrayList ids = ConfigMDUtil.getDataCenterIDs();
            for (int i = 0; i < ids.size(); ++i) {
                Context ctx = new Context(null, solution, (String)ids.get(i), null);
                CommonListenerManager.delete(ctx, className, methodName);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void disable(String className, String methodName) throws BOSException {
        try {
            String solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ConfigMDUtil.getContext()).getSolution().getFullName();
            ArrayList ids = ConfigMDUtil.getDataCenterIDs();
            for (int i = 0; i < ids.size(); ++i) {
                Context ctx = new Context(null, solution, (String)ids.get(i), null);
                CommonListenerManager.disable(ctx, className, methodName);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

