/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.ConfigServiceFactory;
import com.kingdee.bos.config.impl.server.ServerConfigServiceImpl;
import com.kingdee.bos.config.server.AbstractConfigFacadeControllerBean;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class ConfigFacadeControllerBean
extends AbstractConfigFacadeControllerBean {
    private final CustomCacheService dbCache = new CustomCacheService("configfacade.Db");
    private static final String DB4DC = "Db4Dc";
    private static final String DB4USER = "Db4User";

    @Override
    protected Map _getFromDb4Dc(Context ctx, String moduleName) throws BOSException {
        HashMap<String, String> hashMap;
        String cacheKey = "Db4Dc#" + moduleName;
        Object obj = this.dbCache.get(cacheKey);
        if (obj != null) {
            return (Map)obj;
        }
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstm = conn.prepareStatement("select FKey, FValue from T_BOS_CF_DC_VALUE where FModule_Name = ?");
            this.setParam(pstm, 1, moduleName);
            rs = pstm.executeQuery();
            HashMap<String, String> rtv = new HashMap<String, String>();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                rtv.put(key, value);
            }
            this.dbCache.put(cacheKey, rtv);
            hashMap = rtv;
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Get DC ConfigValues Exception.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return hashMap;
    }

    @Override
    protected Map _getFromDb4User(Context ctx, String moduleName) throws BOSException {
        HashMap<String, String> hashMap;
        String cacheKey = "Db4User#" + moduleName + "#" + ctx.getUserName();
        Object obj = this.dbCache.get(cacheKey);
        if (obj != null) {
            return (Map)obj;
        }
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstm = conn.prepareStatement("select FKey, FValue from T_BOS_CF_USER_VALUE where FUser_Name = ? and FModule_Name = ?");
            this.setParam(pstm, 1, ctx.getUserName());
            this.setParam(pstm, 2, moduleName);
            rs = pstm.executeQuery();
            HashMap<String, String> rtv = new HashMap<String, String>();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                rtv.put(key, value);
            }
            this.dbCache.put(cacheKey, rtv);
            hashMap = rtv;
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Get User ConfigValues Exception.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return hashMap;
    }

    @Override
    protected void _save2Db4Dc(Context ctx, String moduleName, Map updateLogs, Map deleteLogs, Map insertLogs) throws BOSException {
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            String cacheKey = "Db4Dc#" + moduleName;
            this.dbCache.remove(cacheKey);
            conn = this.getConnection(ctx);
            pstm = conn.prepareStatement("insert into T_BOS_CF_DC_VALUE(FModule_Name, FKey, FValue) values(?, ?, ?)");
            int i = 0;
            for (Map.Entry entry : insertLogs.entrySet()) {
                this.setParam(pstm, 1, moduleName);
                this.setParam(pstm, 2, (String)entry.getKey());
                this.setParam(pstm, 3, (String)entry.getValue());
                pstm.addBatch();
                if (++i % 100 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
            pstm = conn.prepareStatement("update T_BOS_CF_DC_VALUE set FValue = ? where FModule_Name = ? and FKey = ?");
            i = 0;
            for (Map.Entry entry : updateLogs.entrySet()) {
                this.setParam(pstm, 1, (String)entry.getValue());
                this.setParam(pstm, 2, moduleName);
                this.setParam(pstm, 3, (String)entry.getKey());
                pstm.addBatch();
                if (++i % 100 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
            pstm = conn.prepareStatement("delete from T_BOS_CF_DC_VALUE where FModule_Name = ? and FKey = ?");
            i = 0;
            for (Map.Entry entry : updateLogs.entrySet()) {
                this.setParam(pstm, 1, moduleName);
                this.setParam(pstm, 2, (String)entry.getKey());
                pstm.addBatch();
                if (++i % 100 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Save DC ConfigValues Exception.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstm, (Connection)conn);
    }

    @Override
    protected void _save2Db4User(Context ctx, String moduleName, Map updateLogs, Map deleteLogs, Map insertLogs) throws BOSException {
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            String cacheKey = "Db4User#" + moduleName + "#" + ctx.getUserName();
            this.dbCache.remove(cacheKey);
            String userName = ctx.getUserName();
            conn = this.getConnection(ctx);
            pstm = conn.prepareStatement("insert into T_BOS_CF_USER_VALUE(FUser_Name, FModule_Name, FKey, FValue) values(?, ?, ?, ?)");
            int i = 0;
            for (Map.Entry entry : insertLogs.entrySet()) {
                this.setParam(pstm, 1, userName);
                this.setParam(pstm, 2, moduleName);
                this.setParam(pstm, 3, (String)entry.getKey());
                this.setParam(pstm, 4, (String)entry.getValue());
                pstm.addBatch();
                if (++i % 100 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
            pstm = conn.prepareStatement("update T_BOS_CF_USER_VALUE set FValue = ? where FUser_Name = ? and  FModule_Name = ? and FKey = ?");
            i = 0;
            for (Map.Entry entry : updateLogs.entrySet()) {
                this.setParam(pstm, 1, (String)entry.getValue());
                this.setParam(pstm, 2, userName);
                this.setParam(pstm, 3, moduleName);
                this.setParam(pstm, 4, (String)entry.getKey());
                pstm.addBatch();
                if (++i % 100 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
            pstm = conn.prepareStatement("delete from T_BOS_CF_USER_VALUE where FUser_Name = ? and FModule_Name = ? and FKey = ?");
            i = 0;
            for (Map.Entry entry : updateLogs.entrySet()) {
                this.setParam(pstm, 1, userName);
                this.setParam(pstm, 2, moduleName);
                this.setParam(pstm, 3, (String)entry.getKey());
                pstm.addBatch();
                if (++i % 100 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Save User ConfigValues Exception.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstm, (Connection)conn);
    }

    private void setParam(PreparedStatement pstm, int index, String str) throws SQLException {
        byte[] bytes = str.getBytes();
        pstm.setAsciiStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
    }

    @Override
    protected Map _getFromServer4Dc(Context ctx, String moduleName) throws BOSException {
        ServerConfigServiceImpl server = (ServerConfigServiceImpl)ConfigServiceFactory.getConfigService();
        return server.getDcScope(ctx).getMap(moduleName);
    }

    @Override
    protected Map _getFromServer4User(Context ctx, String moduleName) throws BOSException {
        ServerConfigServiceImpl server = (ServerConfigServiceImpl)ConfigServiceFactory.getConfigService();
        return server.getUserScope(ctx).getMap(moduleName);
    }

    @Override
    protected void _setDcConfig(Context ctx, String key, String moduleName, String value) throws BOSException {
        String cacheKey = "Db4Dc#" + moduleName;
        this.dbCache.remove(cacheKey);
        ServerConfigServiceImpl server = (ServerConfigServiceImpl)ConfigServiceFactory.getConfigService();
        server.getDcScope(ctx).set(key, moduleName, value);
    }

    @Override
    protected void _setUserConfig(Context ctx, String key, String moduleName, String value) throws BOSException {
        String cacheKey = "Db4User#" + moduleName + "#" + ctx.getUserName();
        this.dbCache.remove(cacheKey);
        ServerConfigServiceImpl server = (ServerConfigServiceImpl)ConfigServiceFactory.getConfigService();
        server.getUserScope(ctx).set(key, moduleName, value);
    }

    @Override
    public Map getFromDb4Dc(Context ctx, String moduleName) throws BOSException {
        try {
            Map retValue;
            Map map = retValue = this._getFromDb4Dc(ctx, moduleName);
            return map;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public Map getFromDb4User(Context ctx, String moduleName) throws BOSException {
        try {
            Map retValue;
            Map map = retValue = this._getFromDb4User(ctx, moduleName);
            return map;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public void save2Db4Dc(Context ctx, String moduleName, Map updateLogs, Map deleteLogs, Map insertLogs) throws BOSException {
        try {
            this._save2Db4Dc(ctx, moduleName, updateLogs, deleteLogs, insertLogs);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public void save2Db4User(Context ctx, String moduleName, Map updateLogs, Map deleteLogs, Map insertLogs) throws BOSException {
        try {
            this._save2Db4User(ctx, moduleName, updateLogs, deleteLogs, insertLogs);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public Map getFromServer4Dc(Context ctx, String moduleName) throws BOSException {
        try {
            Map retValue;
            Map map = retValue = this._getFromServer4Dc(ctx, moduleName);
            return map;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public Map getFromServer4User(Context ctx, String moduleName) throws BOSException {
        try {
            Map retValue;
            Map map = retValue = this._getFromServer4User(ctx, moduleName);
            return map;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public void setDcConfig(Context ctx, String key, String moduleName, String value) throws BOSException {
        try {
            this._setDcConfig(ctx, key, moduleName, value);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }

    @Override
    public void setUserConfig(Context ctx, String key, String moduleName, String value) throws BOSException {
        try {
            this._setUserConfig(ctx, key, moduleName, value);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
    }
}

