/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.mdquery.server;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.mdquery.DimensionFilterCollection;
import com.kingdee.bos.dao.mdquery.DimensionFilterInfo;
import com.kingdee.bos.dao.mdquery.MDQueryException;
import com.kingdee.bos.dao.mdquery.MDQueryOption;
import com.kingdee.bos.dao.mdquery.MDQueryViewInfo;
import com.kingdee.bos.dao.mdquery.server.IMDQueryAccess;
import com.kingdee.bos.dao.mdquery.server.LongNumberRule;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.mdquery.Aggregator;
import com.kingdee.bos.metadata.mdquery.ConfigItemCollection;
import com.kingdee.bos.metadata.mdquery.ConfigItemInfo;
import com.kingdee.bos.metadata.mdquery.ConfigItemName;
import com.kingdee.bos.metadata.mdquery.CubeInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceType;
import com.kingdee.bos.metadata.mdquery.DimensionBaseType;
import com.kingdee.bos.metadata.mdquery.DimensionInfo;
import com.kingdee.bos.metadata.mdquery.DimensionUsageCollection;
import com.kingdee.bos.metadata.mdquery.DimensionUsageInfo;
import com.kingdee.bos.metadata.mdquery.HierarchyCollection;
import com.kingdee.bos.metadata.mdquery.HierarchyInfo;
import com.kingdee.bos.metadata.mdquery.LevelBaseType;
import com.kingdee.bos.metadata.mdquery.LevelCollection;
import com.kingdee.bos.metadata.mdquery.LevelInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.mdquery.MeasureCollection;
import com.kingdee.bos.metadata.mdquery.MeasureInfo;
import com.kingdee.bos.metadata.mdquery.ParentChildrenRule;
import com.kingdee.bos.metadata.mdquery.PropertyCollection;
import com.kingdee.bos.metadata.mdquery.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Schema;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaChecker;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class MDQueryAccess
extends AbstractBOSObject
implements IMDQueryAccess {
    public static final String CONNECTION_DEFAULT_NAME = "KDConnection";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.mdquery.server.MDQueryAccess");

    public MDQueryAccess() {
        this.registerInterface(IMDQueryAccess.class, this);
    }

    public MDQueryAccess(Context ctx) {
        super(ctx);
        this.registerInterface(IMDQueryAccess.class, this);
    }

    @Override
    public BOSObjectType getType() {
        throw new UnsupportedOperationException("not supported getType");
    }

    @Override
    public Schema getSchema(IMetaDataPK mdpk, MDQueryViewInfo view, MDQueryOption option) throws MDQueryException {
        Schema schema = null;
        OLAPDatabase ods = this.getOLAPDatabase(mdpk, view, option);
        if (ods != null) {
            schema = ods.schema;
        }
        return schema;
    }

    @Override
    public OLAPDatabase getOLAPDatabase(IMetaDataPK mdpk, MDQueryViewInfo view, MDQueryOption option, String querySQL) throws MDQueryException {
        OLAPDatabase ods;
        try {
            MDQueryInfo metaDataInfo = this.getMetaData(mdpk);
            if (metaDataInfo == null) {
                throw new MDQueryException("Can't get metadata from cache. pk: " + mdpk.toString());
            }
            ods = this.getOLAPDatabase(metaDataInfo, view, option, querySQL);
        }
        catch (BOSException e) {
            throw new MDQueryException(e);
        }
        return ods;
    }

    @Override
    public OLAPDatabase getOLAPDatabase(IMetaDataPK mdpk, MDQueryViewInfo view, MDQueryOption option) throws MDQueryException {
        OLAPDatabase ods;
        try {
            MDQueryInfo metaDataInfo = this.getMetaData(mdpk);
            if (metaDataInfo == null) {
                throw new MDQueryException("Can't get metadata from cache. pk: " + mdpk.toString());
            }
            ods = this.getOLAPDatabase(metaDataInfo, view, option, null);
        }
        catch (BOSException e) {
            throw new MDQueryException(e);
        }
        return ods;
    }

    private OLAPDatabase getOLAPDatabase(MDQueryInfo metaDataInfo, MDQueryViewInfo view, MDQueryOption option, String querySQL) throws MDQueryException {
        OLAPDatabase ods;
        long beginTime = System.currentTimeMillis();
        MDQueryAccessParameterSet accessParameterSet = new MDQueryAccessParameterSet();
        accessParameterSet.option = option;
        accessParameterSet.querySQL = querySQL;
        if (view != null) {
            DimensionFilterCollection dimFilters;
            FilterInfo factFilter = view.getFactFilter();
            if (factFilter != null) {
                accessParameterSet.queryFilter = factFilter;
            }
            if ((dimFilters = view.getDimensionFilterCollection()) != null) {
                accessParameterSet.dimensionFilters = dimFilters;
            }
            SelectorItemCollection selectorItems = view.getSelectors();
            int n = selectorItems.size();
            for (int i = 0; i < n; ++i) {
                this.addSelectorItemToSetByParse(selectorItems.get(i), accessParameterSet);
            }
        }
        logger.debug((Object)"building schemaDef");
        SchemaDef buildedSchemaDef = this.buildSchemaDef(metaDataInfo, accessParameterSet);
        try {
            if (accessParameterSet.sqlMap.size() != 0) {
                for (Map.Entry entry : accessParameterSet.sqlMap.entrySet()) {
                    String tableName = (String)entry.getKey();
                    String sql = (String)entry.getValue();
                    ResultSet resultSet = this.getResultSet(sql, accessParameterSet);
                    accessParameterSet.parameterMap.put(tableName, resultSet);
                }
            }
            logger.debug((Object)("provider use time: " + (System.currentTimeMillis() - beginTime) + "ms"));
            logger.debug((Object)"building result");
            ods = OLAPEngine.build((SchemaDef)buildedSchemaDef, (Map)accessParameterSet.parameterMap);
        }
        catch (OLAPException e) {
            throw new MDQueryException(e);
        }
        catch (SQLException e) {
            throw new MDQueryException(e);
        }
        finally {
            accessParameterSet.clean();
        }
        return ods;
    }

    private SchemaDef buildSchemaDef(MDQueryInfo metaDataInfo, MDQueryAccessParameterSet accessParameterSet) throws MDQueryException {
        SchemaDef schemaDef = new SchemaDef();
        schemaDef.name = metaDataInfo.getName();
        schemaDef.caption = metaDataInfo.getAlias();
        schemaDef.description = metaDataInfo.getDescription();
        this.buildConfigs(metaDataInfo, schemaDef);
        this.buildCubeDef(metaDataInfo, schemaDef, accessParameterSet);
        if (accessParameterSet.tableInSchemaList.size() > 0) {
            schemaDef.tables = accessParameterSet.tableInSchemaList.toArray(new TableDef[0]);
        }
        if (accessParameterSet.parameterInSchemaList.size() > 0) {
            schemaDef.parameters = accessParameterSet.parameterInSchemaList.toArray(new ParameterDef[0]);
        }
        SchemaChecker checker = new SchemaChecker(schemaDef);
        try {
            checker.check();
        }
        catch (OLAPException e) {
            throw new MDQueryException(e);
        }
        return schemaDef;
    }

    private void buildConfigs(MDQueryInfo metaDataInfo, SchemaDef schemaDef) {
        ConfigItemCollection configsInMeta = metaDataInfo.getConfigCollection();
        Properties configsInSchema = schemaDef.config;
        int n = configsInMeta.size();
        for (int i = 0; i < n; ++i) {
            ConfigItemInfo configInMeta = configsInMeta.get(i);
            ConfigItemName name = configInMeta.getName();
            if (name == null) continue;
            configsInSchema.put(name.toString(), configInMeta.getValue());
        }
    }

    private void buildCubeDef(MDQueryInfo metaDataInfo, SchemaDef schemaDef, MDQueryAccessParameterSet accessParameterSet) throws MDQueryException {
        String cubeName;
        CubeDef cubeInSchema = new CubeDef();
        accessParameterSet.factTableColumnSet.clear();
        CubeInfo cubeInMeta = metaDataInfo.getCube();
        DataSourceInfo dataSourceInMeta = cubeInMeta.getDataSource();
        accessParameterSet.factTableName = dataSourceInMeta.getName();
        ArrayList<SharedDimensionDef> dimensionInSchemaList = new ArrayList<SharedDimensionDef>();
        ArrayList<DimensionUsageDef> dimensionUsageInSchemaList = new ArrayList<DimensionUsageDef>();
        ArrayList<MeasureDef> measureInSchemaList = new ArrayList<MeasureDef>();
        boolean hasAllMeasures = false;
        cubeInSchema.name = cubeName = cubeInMeta.getName();
        cubeInSchema.caption = cubeInMeta.getAlias();
        cubeInSchema.description = cubeInMeta.getDescription();
        cubeInSchema.table = accessParameterSet.factTableName;
        String selectorKey = "cube." + cubeName;
        if (accessParameterSet.selectorSet.contains(selectorKey + ".*") || !accessParameterSet.selectorSet.contains(selectorKey)) {
            hasAllMeasures = true;
        }
        boolean hasAllChildren = false;
        DimensionUsageCollection dimensionUsageInMetaList = cubeInMeta.getDimensionUsageCollection();
        int n = dimensionUsageInMetaList.size();
        for (int i = 0; i < n; ++i) {
            DimensionUsageInfo dimensionUsageInMeta = dimensionUsageInMetaList.get(i);
            DimensionInfo dimensionInMeta = dimensionUsageInMeta.getDimension();
            String dimName = dimensionInMeta.getName();
            selectorKey = "dimension." + dimName;
            hasAllChildren = accessParameterSet.selectorSet.contains(selectorKey + ".*");
            if (!accessParameterSet.isSelectorSetEmpty() && !hasAllChildren && !accessParameterSet.selectorSet.contains(selectorKey)) continue;
            String foreignKey = dimensionUsageInMeta.getForeignKey();
            if (foreignKey != null && !foreignKey.equals("")) {
                accessParameterSet.factTableColumnSet.add(foreignKey);
            }
            dimensionInSchemaList.add(this.buildDimensionDef(dimensionInMeta, selectorKey, hasAllChildren, accessParameterSet));
            DimensionUsageDef dimensionUsageInSchema = new DimensionUsageDef();
            dimensionUsageInSchema.name = dimName;
            dimensionUsageInSchema.foreignKey = foreignKey;
            dimensionUsageInSchemaList.add(dimensionUsageInSchema);
        }
        cubeInSchema.dimensions = dimensionUsageInSchemaList.toArray(new CubeDimension[0]);
        schemaDef.dimensions = dimensionInSchemaList.toArray(new SharedDimensionDef[0]);
        MeasureCollection meaureInMetaList = cubeInMeta.getMeasureCollection();
        int n2 = meaureInMetaList.size();
        for (int i = 0; i < n2; ++i) {
            MeasureInfo measureInMeta = meaureInMetaList.get(i);
            selectorKey = "cube." + cubeName + "." + measureInMeta.getName();
            if (!accessParameterSet.isSelectorSetEmpty() && !hasAllMeasures && !accessParameterSet.selectorSet.contains(selectorKey)) continue;
            measureInSchemaList.add(this.buildMeasureDef(measureInMeta, accessParameterSet));
        }
        cubeInSchema.measures = measureInSchemaList.toArray(new MeasureDef[0]);
        this.addTableParameter(null, dataSourceInMeta, true, accessParameterSet);
        CubeDef[] cubes = new CubeDef[]{cubeInSchema};
        schemaDef.cubes = cubes;
    }

    private MeasureDef buildMeasureDef(MeasureInfo measureInMeta, MDQueryAccessParameterSet accessParameterSet) {
        Aggregator aggregator;
        String column;
        MeasureDef measureInSchema = new MeasureDef();
        measureInSchema.name = measureInMeta.getName();
        measureInSchema.caption = measureInMeta.getAlias();
        measureInSchema.description = measureInMeta.getDescription();
        measureInSchema.column = column = measureInMeta.getColumn();
        if (column != null && !column.equals("")) {
            accessParameterSet.factTableColumnSet.add(column);
        }
        if ((aggregator = measureInMeta.getAggregator()) != null) {
            measureInSchema.aggregator = aggregator.toString();
        }
        measureInSchema.formatString = measureInMeta.getFormatString();
        return measureInSchema;
    }

    private SharedDimensionDef buildDimensionDef(DimensionInfo dimensionInMeta, String dimSelectorKey, boolean hasAllChildren, MDQueryAccessParameterSet accessParameterSet) throws MDQueryException {
        DimensionBaseType dimensionBaseType;
        String primaryKey;
        String dimName;
        SharedDimensionDef dimensionInSchema = new SharedDimensionDef();
        DataSourceInfo dataSourceInMeta = dimensionInMeta.getDataSourceInfo();
        if (dataSourceInMeta == null) {
            throw new MDQueryException("DataSource does not exist.");
        }
        String dimTableName = dataSourceInMeta.getName();
        if (dimTableName == null || dimTableName.equals("")) {
            throw new MDQueryException("TableName has not been defined.");
        }
        accessParameterSet.dimensionTableColumnSet.clear();
        dimensionInSchema.name = dimName = dimensionInMeta.getName();
        dimensionInSchema.caption = dimensionInMeta.getAlias();
        dimensionInSchema.description = dimensionInMeta.getDescription();
        dimensionInSchema.table = dimTableName;
        dimensionInSchema.primaryKey = primaryKey = dimensionInMeta.getPrimaryKey();
        if (primaryKey != null && !primaryKey.equals("")) {
            accessParameterSet.dimensionTableColumnSet.add(primaryKey);
        }
        if ((dimensionBaseType = dimensionInMeta.getBaseType()) != null) {
            dimensionInSchema.type = dimensionBaseType.toString();
        }
        ArrayList<HierarchyDef> hierarchyInSchemaList = new ArrayList<HierarchyDef>();
        HierarchyCollection hierarchyInMetaList = dimensionInMeta.getHierarchyCollection();
        int n = hierarchyInMetaList.size();
        for (int i = 0; i < n; ++i) {
            boolean hasAllLevel = hasAllChildren;
            HierarchyInfo hierarchyInMeta = hierarchyInMetaList.get(i);
            String selectorKey = dimSelectorKey + "." + hierarchyInMeta.getName();
            if (!hasAllLevel) {
                hasAllLevel = accessParameterSet.selectorSet.contains(selectorKey + ".*");
            }
            if (!accessParameterSet.isSelectorSetEmpty() && !hasAllLevel && !accessParameterSet.selectorSet.contains(selectorKey)) continue;
            hierarchyInSchemaList.add(this.buildHierarchyDef(hierarchyInMeta, selectorKey, hasAllLevel, accessParameterSet));
        }
        dimensionInSchema.hierarchies = hierarchyInSchemaList.toArray(new HierarchyDef[0]);
        if (accessParameterSet.factTableName != null && dimTableName.equals(accessParameterSet.factTableName)) {
            this.mergeFactTable(accessParameterSet, dimName);
        } else {
            this.addTableParameter(dimName, dataSourceInMeta, false, accessParameterSet);
        }
        return dimensionInSchema;
    }

    private HierarchyDef buildHierarchyDef(HierarchyInfo hierarchyInMeta, String hierSelectorKey, boolean hasAllLevel, MDQueryAccessParameterSet accessParameterSet) {
        HierarchyDef hierarchyInSchema = new HierarchyDef();
        hierarchyInSchema.name = hierarchyInMeta.getName();
        hierarchyInSchema.caption = hierarchyInMeta.getAlias();
        hierarchyInSchema.description = hierarchyInMeta.getDescription();
        hierarchyInSchema.hasAll = true;
        String allMemberName = hierarchyInMeta.getAllMemberName();
        if (allMemberName != null && !allMemberName.equals("")) {
            hierarchyInSchema.allMemberName = hierarchyInMeta.getAllMemberName();
        }
        ArrayList<LevelDef> LevelInSchemaList = new ArrayList<LevelDef>();
        LevelCollection levelInMetaList = hierarchyInMeta.getLevelCollection();
        int n = levelInMetaList.size();
        for (int i = 0; i < n; ++i) {
            LevelInfo levelInMeta = levelInMetaList.get(i);
            String selectorKey = hierSelectorKey + "." + levelInMeta.getName();
            if (!accessParameterSet.isSelectorSetEmpty() && !hasAllLevel && !accessParameterSet.selectorSet.contains(selectorKey)) continue;
            LevelInSchemaList.add(this.buildLevelDef(levelInMeta, accessParameterSet));
        }
        hierarchyInSchema.levels = LevelInSchemaList.toArray(new LevelDef[0]);
        return hierarchyInSchema;
    }

    private LevelDef buildLevelDef(LevelInfo levelInMeta, MDQueryAccessParameterSet accessParameterSet) {
        ParentChildrenRule rule;
        String orderBy;
        String parentColumn;
        String column;
        LevelDef levelInSchema = new LevelDef();
        levelInSchema.name = levelInMeta.getName();
        levelInSchema.caption = levelInMeta.getAlias();
        levelInSchema.description = levelInMeta.getDescription();
        LevelBaseType levelBaseType = levelInMeta.getBaseType();
        if (levelBaseType != null) {
            levelInSchema.type = levelBaseType.toString();
        }
        levelInSchema.column = column = levelInMeta.getColumn();
        if (column != null && !column.equals("")) {
            accessParameterSet.dimensionTableColumnSet.add(column);
        }
        if ((parentColumn = levelInMeta.getParentColumn()) != null && !parentColumn.equals("")) {
            levelInSchema.parentColumn = parentColumn;
            accessParameterSet.dimensionTableColumnSet.add(parentColumn);
        }
        if ((orderBy = levelInMeta.getOrderBy()) != null && !orderBy.equals("")) {
            levelInSchema.orderBy = orderBy;
            accessParameterSet.dimensionTableColumnSet.add(orderBy);
        }
        if ((rule = levelInMeta.getRule()) != null) {
            LongNumberRule parentMemberRule = null;
            if (rule.equals((Object)ParentChildrenRule.LONGNUMBERRULE)) {
                parentMemberRule = new LongNumberRule();
            }
            if (parentMemberRule != null) {
                String ruleString;
                levelInSchema.rule = ruleString = rule.toString();
                accessParameterSet.parameterMap.put(ruleString, parentMemberRule);
                ParameterDef paraInSchema = new ParameterDef();
                paraInSchema.name = rule.toString();
                paraInSchema.type = "ParentMemberRule";
                accessParameterSet.parameterInSchemaList.add(paraInSchema);
            }
        }
        ArrayList<PropertyDef> PropertyInSchemaList = new ArrayList<PropertyDef>();
        PropertyCollection propertyInMetaList = levelInMeta.getPropertyCollection();
        int n = propertyInMetaList.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInMeta = propertyInMetaList.get(i);
            PropertyInSchemaList.add(this.buildPropertyDef(propertyInMeta, accessParameterSet));
        }
        levelInSchema.properties = PropertyInSchemaList.toArray(new PropertyDef[0]);
        return levelInSchema;
    }

    private PropertyDef buildPropertyDef(PropertyInfo propertyInMeta, MDQueryAccessParameterSet accessParameterSet) {
        String column;
        PropertyDef propertyInSchema = new PropertyDef();
        propertyInSchema.name = propertyInMeta.getName();
        propertyInSchema.caption = propertyInMeta.getAlias();
        propertyInSchema.description = propertyInMeta.getDescription();
        propertyInSchema.column = column = propertyInMeta.getColumnName();
        if (column != null && !column.equals("")) {
            accessParameterSet.dimensionTableColumnSet.add(column);
        }
        return propertyInSchema;
    }

    private void addTableParameter(String dimensionName, DataSourceInfo dataSourceInMeta, boolean isFactTable, MDQueryAccessParameterSet accessParameterSet) throws MDQueryException {
        String sql;
        Iterator iterator;
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selectors = ev.getSelector();
        FilterInfo filter = new FilterInfo();
        if (isFactTable) {
            iterator = accessParameterSet.factTableColumnSet.iterator();
            if (!accessParameterSet.isQuerySQLNotNull()) {
                filter = accessParameterSet.queryFilter;
            }
        } else {
            iterator = accessParameterSet.dimensionTableColumnSet.iterator();
            filter = accessParameterSet.dimensionFilters.get(dimensionName);
        }
        while (iterator.hasNext()) {
            String column = (String)iterator.next();
            selectors.add(new SelectorItemInfo(column));
        }
        ev.setFilter(filter);
        if (isFactTable) {
            if (accessParameterSet.isQuerySQLNotNull()) {
                sql = accessParameterSet.querySQL;
            } else {
                JoinQueryInfo queryInfo = null;
                DataSourceType sourceType = dataSourceInMeta.getBaseType();
                if (sourceType == null) {
                    throw new MDQueryException("Source type has not been defined");
                }
                if (sourceType.equals((Object)DataSourceType.JOINQUERY)) {
                    queryInfo = dataSourceInMeta.getJoinQueryObject();
                } else if (sourceType.equals((Object)DataSourceType.UNIONQUERY)) {
                    queryInfo = dataSourceInMeta.getUnionQueryObject();
                }
                if (queryInfo == null) {
                    throw new MDQueryException("QueryInfo does not exist");
                }
                MetaDataPK pk = MetaDataPK.create((String)queryInfo.getPackage(), (String)queryInfo.getName());
                try {
                    sql = this.getQuerySql((IMetaDataPK)pk, ev);
                }
                catch (BOSException e) {
                    throw new MDQueryException(e);
                }
            }
        } else {
            EntityObjectInfo entityInfo = dataSourceInMeta.getEntityObject();
            if (entityInfo == null) {
                throw new MDQueryException("EntityInfo does not exist");
            }
            MetaDataPK pk = MetaDataPK.create((String)entityInfo.getPackage(), (String)entityInfo.getName());
            try {
                sql = this.getSubEntitySql((IMetaDataPK)pk, ev);
            }
            catch (BOSException e) {
                throw new MDQueryException(e);
            }
        }
        String tableName = dataSourceInMeta.getName();
        ParameterDef parameterInSchema = new ParameterDef();
        parameterInSchema.name = tableName;
        parameterInSchema.type = "Table";
        accessParameterSet.parameterInSchemaList.add(parameterInSchema);
        accessParameterSet.sqlMap.put(tableName, sql);
    }

    private void mergeFactTable(MDQueryAccessParameterSet accessParameterSet, String dimName) throws MDQueryException {
        for (String column : accessParameterSet.dimensionTableColumnSet) {
            accessParameterSet.factTableColumnSet.add(column);
        }
        DimensionFilterInfo dimFilter = accessParameterSet.dimensionFilters.get(dimName);
        if (dimFilter == null) {
            return;
        }
        FilterItemCollection filterItems = dimFilter.getFilterItems();
        if (filterItems == null || filterItems.size() == 0) {
            return;
        }
        if (accessParameterSet.queryFilter == null) {
            accessParameterSet.queryFilter = new FilterInfo();
        }
        try {
            accessParameterSet.queryFilter.mergeFilter((FilterInfo)dimFilter, "AND");
        }
        catch (BOSException e) {
            throw new MDQueryException(e);
        }
    }

    protected String getQuerySql(IMetaDataPK pk, EntityViewInfo view) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.getContext(), null);
        return qda.getQuerySql(pk, view);
    }

    protected String getSubEntitySql(IMetaDataPK pk, EntityViewInfo view) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.getContext(), null);
        String sql = qda.getEntitySql(pk, view);
        return sql;
    }

    private ResultSet getResultSet(String sql, MDQueryAccessParameterSet accessParameterSet) throws MDQueryException {
        ResultSet rs = null;
        try {
            if (accessParameterSet.conn == null || accessParameterSet.conn.isClosed()) {
                accessParameterSet.conn = this.getEJBConnection();
                if (accessParameterSet.option.transactionIsolation != -1) {
                    accessParameterSet.conn.setTransactionIsolation(accessParameterSet.option.transactionIsolation);
                }
            }
            Statement stmt = accessParameterSet.conn.createStatement();
            if (accessParameterSet.option.fetchSize != 0) {
                // empty if block
            }
            rs = stmt.executeQuery(sql);
            accessParameterSet.stmtMap.put(Uuid.create().toString(), stmt);
        }
        catch (SQLException sqle) {
            sqle.setNextException(new SQLException("The query sql is:" + sql));
            throw new MDQueryException(sqle);
        }
        return rs;
    }

    protected MDQueryInfo getMetaData(IMetaDataPK mdpk) {
        MDQueryInfo mdQueryInfo = null;
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext());
        mdQueryInfo = metaDataLoader.getMDQuery(mdpk);
        return mdQueryInfo;
    }

    private void addSelectorItemToSetByParse(SelectorItemInfo selectorItem, MDQueryAccessParameterSet accessParameterSet) throws MDQueryException {
        if (selectorItem == null) {
            throw new MDQueryException("The selectorItem is null");
        }
        String propertyName = selectorItem.getPropertyName();
        if (propertyName == null || propertyName.equals("")) {
            throw new MDQueryException("The propertyName of selectorItem does not defined");
        }
        boolean nodeType = true;
        int firstDotIndex = propertyName.indexOf(".");
        if (firstDotIndex > -1) {
            String nodeName = propertyName.substring(0, firstDotIndex);
            if (nodeName.equalsIgnoreCase("cube")) {
                nodeType = true;
                propertyName = propertyName.replaceFirst(nodeName, "cube");
            } else if (nodeName.equalsIgnoreCase("dimension")) {
                nodeType = false;
                propertyName = propertyName.replaceFirst(nodeName, "dimension");
            } else {
                throw new MDQueryException("Wrong selector name: " + propertyName);
            }
            int secondDotIndex = propertyName.indexOf(".", firstDotIndex + 1);
            if (secondDotIndex > -1) {
                nodeName = propertyName.substring(0, secondDotIndex);
                if (firstDotIndex == secondDotIndex - 1 || propertyName.substring(secondDotIndex + 1).equals("")) {
                    throw new MDQueryException("Wrong selector name: " + propertyName);
                }
                accessParameterSet.selectorSet.add(nodeName);
                if (nodeType) {
                    accessParameterSet.selectorSet.add(propertyName);
                } else {
                    int thirdDotIndex = propertyName.indexOf(".", secondDotIndex + 1);
                    if (thirdDotIndex > -1) {
                        nodeName = propertyName.substring(0, thirdDotIndex);
                        if (secondDotIndex == thirdDotIndex - 1 || propertyName.substring(thirdDotIndex + 1).equals("")) {
                            throw new MDQueryException("Wrong selector name: " + propertyName);
                        }
                        accessParameterSet.selectorSet.add(nodeName);
                        accessParameterSet.selectorSet.add(propertyName);
                    } else {
                        accessParameterSet.selectorSet.add(propertyName + ".*");
                    }
                }
            } else {
                accessParameterSet.selectorSet.add(propertyName + ".*");
            }
        } else {
            throw new MDQueryException("Wrong selector name: " + propertyName);
        }
    }

    protected Connection getEJBConnection() throws SQLException {
        return EJBFactory.getConnection(this.getContext());
    }

    static class MDQueryAccessParameterSet {
        String querySQL;
        FilterInfo queryFilter = new FilterInfo();
        DimensionFilterCollection dimensionFilters = new DimensionFilterCollection();
        Set selectorSet;
        String factTableName;
        Set factTableColumnSet = new HashSet();
        Set dimensionTableColumnSet = new HashSet();
        List parameterInSchemaList;
        HashMap parameterMap;
        List tableInSchemaList;
        MDQueryOption option;
        Connection conn = null;
        Map stmtMap;
        Map sqlMap;

        boolean isSelectorSetEmpty() {
            return this.selectorSet != null && this.selectorSet.size() == 0;
        }

        public boolean isQuerySQLNotNull() {
            return this.querySQL != null && !this.querySQL.equals("");
        }

        MDQueryAccessParameterSet() {
            this.selectorSet = new HashSet();
            this.parameterMap = new HashMap();
            this.parameterInSchemaList = new ArrayList();
            this.tableInSchemaList = new ArrayList();
            this.stmtMap = new HashMap();
            this.sqlMap = new HashMap();
        }

        void clean() {
            if (this.stmtMap.size() > 0) {
                for (Map.Entry entry : this.stmtMap.entrySet()) {
                    Statement stmt = (Statement)entry.getValue();
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
            SQLUtils.cleanup((Connection)this.conn);
        }
    }
}

