/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormCacheService;

import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.RelationshipCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.eas.common.cache.CacheConfigNode;
import com.kingdee.eas.common.cache.CacheXMLConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class BosType2BosTypeHelper {
    private IMetaDataLoader loader;
    private String propertyFile = "";
    private String cacheConfigFile = "";
    private Properties prop = new Properties();
    private HashMap<String, HashSet> bostype2bostypeSetMap = new HashMap();
    private HashMap<String, String> bostypeNameMap = new HashMap();
    private HashMap Type2entityMap = new HashMap();
    private HashSet entitySetInCacheConfig = new HashSet();

    public static void main(String[] args) {
        BosType2BosTypeHelper helper = new BosType2BosTypeHelper("W:/eas/Server/server/metas", "d:/type2type.properties", "d:/CacheConfig.xml");
        helper.doIt();
    }

    public void doIt() {
        HashSet entitySet;
        CacheXMLConfiguration config = CacheXMLConfiguration.getInstance((File)new File(this.cacheConfigFile));
        List configList = config.getEntityConfigList();
        int size = configList.size();
        for (int i = 0; i < size; ++i) {
            CacheConfigNode configNode = (CacheConfigNode)configList.get(i);
            this.entitySetInCacheConfig.add(configNode.getBosType());
            this.bostype2bostypeSetMap.put(configNode.getBosType() + "<" + configNode.getName() + ">", new HashSet());
            this.bostypeNameMap.put(configNode.getBosType(), configNode.getBosType() + "<" + configNode.getName() + ">");
        }
        EntityObjectCollection eColl = this.loader.getEntityCollection();
        int size2 = eColl.size();
        for (int i = 0; i < size2; ++i) {
            EntityObjectInfo eInfo = eColl.get(i);
            if (eInfo.getTable() == null) continue;
            entitySet = new HashSet();
            entitySet.add(eInfo.getFullName());
            if (!this.bostypeNameMap.containsKey(eInfo.get("bosType").toString())) continue;
            this.Type2entityMap.put(eInfo.getFullName(), eInfo.get("bosType"));
        }
        RelationshipCollection rColl = (RelationshipCollection)this.loader.getCollection(MetaDataTypeList.RELATIONSHIP);
        int size3 = rColl.size();
        for (int i = 0; i < size3; ++i) {
            HashSet clientSet;
            RelationshipInfo rInfo = rColl.get(i);
            String supplierName = rInfo.getSupplierObject().getFullName();
            String clientName = rInfo.getClientObject().getFullName();
            if (!this.Type2entityMap.containsKey(supplierName) || !this.Type2entityMap.containsKey(clientName)) continue;
            EntityObjectInfo clientEntity = rInfo.getClientObject();
            String isReverse = clientEntity.getExtendedProperty("IsReverseLinkEntity");
            if (isReverse != null && isReverse.equalsIgnoreCase("true")) {
                clientSet = this.bostype2bostypeSetMap.get(this.bostypeNameMap.get(this.Type2entityMap.get(clientName)));
                clientSet.add(this.bostypeNameMap.get(this.Type2entityMap.get(supplierName)));
                continue;
            }
            clientSet = this.bostype2bostypeSetMap.get(this.bostypeNameMap.get(this.Type2entityMap.get(supplierName)));
            clientSet.add(this.bostypeNameMap.get(this.Type2entityMap.get(clientName)));
        }
        for (String bosType : this.bostype2bostypeSetMap.keySet()) {
            entitySet = this.bostype2bostypeSetMap.get(bosType);
            if (entitySet.size() <= 0) continue;
            this.prop.put(bosType, entitySet.toString());
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.propertyFile);
            this.prop.store(fos, "table name to entity bos type");
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BosType2BosTypeHelper(String metasDir, String propFile, String cacheConfig) {
        this.propertyFile = propFile;
        this.cacheConfigFile = cacheConfig;
        StringBuffer allMetas = new StringBuffer();
        this.getAllMetasByDir(metasDir, allMetas);
        MetaDataLoaderFactory.setClientMetaDataPath((String)allMetas.toString());
        this.loader = MetaDataLoaderFactory.getMetaDataLoader(null);
    }

    private void getAllMetasByDir(String metasDir, StringBuffer allMetas) {
        File file = new File(metasDir);
        if (file.isDirectory()) {
            File[] subFileVec = file.listFiles();
            for (int i = 0; i < subFileVec.length; ++i) {
                this.getAllMetasByDir(subFileVec[i].getAbsolutePath(), allMetas);
            }
        } else if (file.getName().endsWith(".jar")) {
            allMetas.append(file.getAbsolutePath());
            allMetas.append(";");
        }
    }
}

