/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormCacheService;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.util.BOSObjectType;
import java.util.ArrayList;
import java.util.List;

public class ORMCacheOuterAdpter {
    private static CustomCacheService ormInfoCache = new CustomCacheService("orm.infoouter");
    private static CustomCacheService ormCollectionCache = new CustomCacheService("orm.collectionouter");

    public void putCollection(Context ctx, BOSObjectType bosType, String view, Object value) {
        String ais = ctx.getAIS();
        ormCollectionCache.hset(bosType.toString(), bosType.toString() + view, value);
    }

    public Object getCollection(Context ctx, BOSObjectType bosType, String view) {
        String ais = ctx.getAIS();
        return ormCollectionCache.hget(bosType.toString(), bosType.toString() + view);
    }

    public void putInfo(Context ctx, BOSObjectType bosType, IObjectPK pk, String view, Object value) {
        String ais = ctx.getAIS();
        ormInfoCache.hset(bosType.toString(), bosType.toString() + pk + view, value);
        String pkKey = bosType.toString() + "_pk_" + pk;
        ArrayList<String> ls = (ArrayList<String>)ormInfoCache.hget(bosType.toString(), pkKey);
        if (ls == null) {
            ls = new ArrayList<String>();
        }
        ls.add(bosType.toString() + pk + view);
        ormInfoCache.hset(bosType.toString(), pkKey, ls);
    }

    public void putInfo(Context ctx, BOSObjectType bosType, String oql, Object value) {
        String ais = ctx.getAIS();
        ormInfoCache.hset(bosType.toString(), bosType.toString() + oql, value);
        Object pk = ((IObjectValue)value).get("id");
        if (pk == null) {
            return;
        }
        String pkKey = bosType.toString() + "_pk_" + pk;
        ArrayList<String> ls = (ArrayList<String>)ormInfoCache.hget(bosType.toString(), pkKey);
        if (ls == null) {
            ls = new ArrayList<String>();
        }
        ls.add(bosType.toString() + oql);
        ormInfoCache.hset(bosType.toString(), pkKey, ls);
    }

    public Object getInfo(Context ctx, BOSObjectType bosType, String oql) {
        String ais = ctx.getAIS();
        return ormInfoCache.hget(bosType.toString(), bosType.toString() + oql);
    }

    public Object getInfo(Context ctx, BOSObjectType bosType, IObjectPK pk, String view) {
        String ais = ctx.getAIS();
        return ormInfoCache.hget(bosType.toString(), bosType.toString() + pk + view);
    }

    public void removeInfo(Context ctx, BOSObjectType bosType, String pk) {
        String ais = ctx.getAIS();
        String pkKey = bosType.toString() + "_pk_" + pk;
        List ls = (List)ormInfoCache.hget(bosType.toString(), pkKey);
        if (ls != null) {
            for (String s : ls) {
                ormInfoCache.hdel(bosType.toString(), s);
            }
            ormInfoCache.hdel(bosType.toString(), pkKey);
        }
        ormCollectionCache.hdel(bosType.toString());
    }

    public void removeInfos(Context ctx, BOSObjectType bosType, String[] pks) {
        String ais = ctx.getAIS();
        for (String pk : pks) {
            String pkKey = bosType.toString() + "_pk_" + pk;
            List ls = (List)ormInfoCache.hget(bosType.toString(), pkKey);
            if (ls == null) continue;
            for (String s : ls) {
                ormInfoCache.hdel(bosType.toString(), s);
            }
            ormInfoCache.hdel(bosType.toString(), pkKey);
        }
        ormCollectionCache.hdel(bosType.toString());
    }

    public void removeInfosByBosType(Context ctx, BOSObjectType bosType) {
        String ais = ctx.getAIS();
        ormInfoCache.hdel(bosType.toString());
        ormCollectionCache.hdel(bosType.toString());
    }

    public void removeAllCollection(Context ctx, BOSObjectType bosType) {
        String ais = ctx.getAIS();
        ormCollectionCache.hdel(bosType.toString());
    }
}

