/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormCacheService;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMCacheOuterAdpter;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.service.CacheSyncService;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ORMCacheUtil {
    public static final Logger logger = Logger.getLogger((String)ORMCacheUtil.class.getName());
    private static ORMCacheUtil ormCacheUtil;
    private static ORMCacheOuterAdpter ormCacheOuterAdpter;
    private static ConcurrentHashMap<String, String> bosTypeCache;
    private static ConcurrentHashMap<String, String> objIDCache;
    private static ConcurrentHashMap<String, List<String>> objID_Oql_Mapping;
    private static CustomCacheService ormInfoCache;
    private static CustomCacheService ormCollectionCache;

    public static ORMCacheUtil getInstance() {
        if (ormCacheUtil == null) {
            ormCacheUtil = new ORMCacheUtil();
            ormCacheOuterAdpter = new ORMCacheOuterAdpter();
        }
        return ormCacheUtil;
    }

    public void putCollection(Context ctx, BOSObjectType bosType, String view, Object value) {
        if (ctx == null || bosType == null || value == null) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.putCollection(ctx, bosType, view, value);
            return;
        }
        String ais = ctx.getAIS();
        String bosTypeFlag = this.getBosTypeFlag(ctx, bosType.toString() + "Collection");
        String key = bosType.toString() + "#" + bosTypeFlag + "#" + view;
        ormCollectionCache.put(ais, key, value);
    }

    public Object getCollection(Context ctx, BOSObjectType bosType, String view) {
        if (ctx == null || bosType == null || view == null) {
            return null;
        }
        if (this.needOrmOuterCache(bosType)) {
            return ormCacheOuterAdpter.getCollection(ctx, bosType, view);
        }
        String ais = ctx.getAIS();
        String bosTypeFlag = this.getBosTypeFlag(ctx, bosType.toString() + "Collection");
        String key = bosType.toString() + "#" + bosTypeFlag + "#" + view;
        Object o = ormCollectionCache.get(ais, key);
        if (o == null) {
            return null;
        }
        if (this.isOrmCloneWhenGetCache(bosType)) {
            try {
                if (o instanceof IObjectCollection && ((IObjectCollection)o).size() > 10000) {
                    logger.warn((Object)("bostype:" + bosType + " suggest to config outer cache"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                return ObjectUtils.createCopy((Object)o);
            }
            catch (Exception e) {
                logger.warn((Object)("clone Collection error:" + bosType + " "), (Throwable)e);
            }
        }
        return o;
    }

    public void putInfo(Context ctx, BOSObjectType bosType, IObjectPK pk, String view, Object value) {
        if (ctx == null || bosType == null || pk == null || value == null) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.putInfo(ctx, bosType, pk, view, value);
            return;
        }
        String key = this.generateKey(ctx, bosType, pk, view);
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        String ais = ctx.getAIS();
        ormInfoCache.put(ais, key, value);
    }

    public void putInfo(Context ctx, BOSObjectType bosType, String oql, Object value) {
        if (ctx == null || bosType == null || oql == null || value == null) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.putInfo(ctx, bosType, oql, value);
            return;
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return;
        }
        Object pk = ((IObjectValue)value).get("id");
        if (pk == null) {
            return;
        }
        String flag = this.getObjIDFlag(ctx, pk.toString());
        List<String> ls = objID_Oql_Mapping.get(pk.toString());
        if (ls == null) {
            ls = new ArrayList<String>();
            objID_Oql_Mapping.put(pk.toString(), ls);
        }
        ls.add(ais + bosType.toString() + oql);
        objIDCache.put(ais + bosType.toString() + oql, flag);
        ormInfoCache.put(ais, bosType.toString() + oql + flag, value);
    }

    public Object getInfo(Context ctx, BOSObjectType bosType, String oql) {
        if (ctx == null || bosType == null || oql == null) {
            return null;
        }
        if (this.needOrmOuterCache(bosType)) {
            return ormCacheOuterAdpter.getInfo(ctx, bosType, oql);
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return null;
        }
        String key = ais + bosType.toString() + oql;
        String flag = objIDCache.get(key);
        if (flag == null) {
            return null;
        }
        Object o = ormInfoCache.get(ais, bosType.toString() + oql + flag);
        if (o == null) {
            return null;
        }
        if (this.isOrmCloneWhenGetCache(bosType)) {
            try {
                return ObjectUtils.createCopy((Object)o);
            }
            catch (Exception e) {
                logger.warn((Object)("clone info error:" + bosType), (Throwable)e);
            }
        }
        return o;
    }

    public Object getInfo(Context ctx, BOSObjectType bosType, IObjectPK pk, String view) {
        if (ctx == null || bosType == null || pk == null) {
            return null;
        }
        if (this.needOrmOuterCache(bosType)) {
            return ormCacheOuterAdpter.getInfo(ctx, bosType, pk, view);
        }
        String key = this.generateKey(ctx, bosType, pk, view);
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        String ais = ctx.getAIS();
        Object o = ormInfoCache.get(ais, key);
        if (o == null) {
            return null;
        }
        if (this.isOrmCloneWhenGetCache(bosType)) {
            try {
                return ObjectUtils.createCopy((Object)o);
            }
            catch (Exception e) {
                logger.warn((Object)("clone info error:" + bosType + " " + pk), (Throwable)e);
            }
        }
        return o;
    }

    public void removeInfo(Context ctx, BOSObjectType bosType, String pk) {
        if (ctx == null || bosType == null || pk == null) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.removeInfo(ctx, bosType, pk);
            return;
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return;
        }
        Random random = new Random();
        String flag = "" + random.nextInt(1000);
        if (flag.equals(objIDCache.get(ais + pk))) {
            flag = "" + random.nextInt(1000);
        }
        this.updateObjIDFlag(ais, bosType.toString(), pk, flag, Boolean.TRUE);
    }

    public void removeInfos(Context ctx, BOSObjectType bosType, String[] pks) {
        if (pks == null || pks.length == 0) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.removeInfos(ctx, bosType, pks);
            return;
        }
        for (int i = 0; i < pks.length; ++i) {
            this.removeInfo(ctx, bosType, pks[1]);
        }
    }

    public void removeInfosByBosType(Context ctx, BOSObjectType bosType) {
        if (bosType == null) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.removeInfosByBosType(ctx, bosType);
            return;
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return;
        }
        Random random = new Random();
        String flag = "" + random.nextInt(1000);
        this.updateBosTypeFlag(ais, bosType.toString(), flag, Boolean.TRUE);
    }

    public void removeAllCollection(Context ctx, BOSObjectType bosType) {
        if (bosType == null) {
            return;
        }
        if (this.needOrmOuterCache(bosType)) {
            ormCacheOuterAdpter.removeAllCollection(ctx, bosType);
            return;
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return;
        }
        Random random = new Random();
        String flag = "" + random.nextInt(1000);
        this.updateBosTypeCollectionFlag(ais, bosType.toString(), flag, Boolean.TRUE);
    }

    private String generateKey(Context ctx, BOSObjectType bosType, IObjectPK pk, String view) {
        if (bosType == null || pk == null) {
            return null;
        }
        String bosTypeFlag = this.getBosTypeFlag(ctx, bosType.toString());
        String objIDFlag = this.getObjIDFlag(ctx, pk.toString());
        if (StringUtils.isEmpty((String)bosTypeFlag) || StringUtils.isEmpty((String)objIDFlag)) {
            return null;
        }
        if (StringUtils.isEmpty((String)view)) {
            return bosType.toString() + "#" + bosTypeFlag + "#" + pk.toString() + "#" + objIDFlag;
        }
        return bosType.toString() + "#" + bosTypeFlag + "#" + pk.toString() + "#" + objIDFlag + "#" + view;
    }

    private String getBosTypeFlag(Context ctx, String bosType) {
        if (ctx == null || bosType == null) {
            return null;
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return null;
        }
        String obj = bosTypeCache.get(ais + bosType);
        if (obj == null) {
            Random random = new Random();
            String flag = "" + random.nextInt(1000);
            bosTypeCache.put(ais + bosType, flag);
            return flag;
        }
        return obj.toString();
    }

    private String getObjIDFlag(Context ctx, String pk) {
        if (ctx == null || pk == null) {
            return null;
        }
        String ais = ctx.getAIS();
        if (StringUtils.isEmpty((String)ais)) {
            return null;
        }
        String obj = objIDCache.get(ais + pk);
        if (obj == null) {
            Random random = new Random();
            String flag = "" + random.nextInt(1000);
            objIDCache.put(ais + pk, flag);
            return flag;
        }
        return obj.toString();
    }

    public void updateBosTypeCollectionFlag(String ais, String bosType, String flag, Boolean notifyServer) {
        if (StringUtils.isEmpty((String)ais) || StringUtils.isEmpty((String)bosType) || StringUtils.isEmpty((String)flag)) {
            return;
        }
        bosTypeCache.put(ais + bosType + "Collection", flag);
        if (notifyServer.booleanValue()) {
            this.notifyOtherServer("ORMInfo_Update_BosType_Collection_Flag", new Object[]{ais, bosType, flag, Boolean.FALSE});
        }
    }

    public void updateBosTypeFlag(String ais, String bosType, String flag, Boolean notifyServer) {
        if (StringUtils.isEmpty((String)ais) || StringUtils.isEmpty((String)bosType) || StringUtils.isEmpty((String)flag)) {
            return;
        }
        bosTypeCache.put(ais + bosType, flag);
        Random random = new Random();
        String colflag = "" + random.nextInt(1000);
        bosTypeCache.put(ais + bosType + "Collection", colflag);
        if (notifyServer.booleanValue()) {
            this.notifyOtherServer("ORMInfo_Update_BosType_Flag", new Object[]{ais, bosType, flag, Boolean.FALSE});
        }
    }

    public void updateObjIDFlag(String ais, String bosType, String pk, String flag, Boolean notifyServer) {
        if (StringUtils.isEmpty((String)ais) || StringUtils.isEmpty((String)pk) || StringUtils.isEmpty((String)flag)) {
            return;
        }
        objIDCache.put(ais + pk, flag);
        List<String> ls = objID_Oql_Mapping.get(pk);
        if (ls != null) {
            for (String oqlKey : ls) {
                if (StringUtils.isEmpty((String)oqlKey)) continue;
                objIDCache.put(oqlKey, flag);
            }
        }
        Random random = new Random();
        String colflag = "" + random.nextInt(1000);
        bosTypeCache.put(ais + bosType + "Collection", colflag);
        if (notifyServer.booleanValue()) {
            this.notifyOtherServer("ORMInfo_Update_ObjID_Flag", new Object[]{ais, bosType, pk, flag, Boolean.FALSE});
        }
    }

    private void notifyOtherServer(String method, Object[] args) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("method", method);
        msg.put("args", args);
        CacheSyncService.sendCacheFlushMessage(msg);
    }

    private boolean needOrmOuterCache(BOSObjectType bosType) {
        return false;
    }

    private boolean isOrmCloneWhenGetCache(BOSObjectType bosType) {
        ICacheConfig config = CacheConfigManager.getConfig();
        return config != null && config.needServerCache() && config.isOrmCloneWhenGetCache(bosType.toString());
    }

    static {
        bosTypeCache = new ConcurrentHashMap();
        objIDCache = new ConcurrentHashMap();
        objID_Oql_Mapping = new ConcurrentHashMap();
        ormInfoCache = new CustomCacheService("orm.info");
        ormCollectionCache = new CustomCacheService("orm.collection");
    }
}

