/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormCacheService;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.IORMCacheService;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.notify.CacheCleanEvent;
import com.kingdee.bos.framework.cache.notify.CacheCleanManager;
import com.kingdee.bos.framework.cache.notify.ICacheCleanListener;
import com.kingdee.bos.framework.cache.service.command.CacheCommandExecutor;
import com.kingdee.bos.framework.cache.service.command.CacheCommandFactory;
import com.kingdee.bos.framework.cache.service.command.ICacheCommand;
import com.kingdee.bos.util.BOSObjectType;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ORMValueCacheService
implements IORMCacheService {
    public static final Logger logger = Logger.getLogger((String)ORMValueCacheService.class.getName());
    private static ConcurrentHashMap<String, HashSet<String>> Type2TypeCache;
    private static ORMValueCacheService instance;

    public static ORMValueCacheService getInstance() {
        if (instance == null) {
            instance = new ORMValueCacheService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORMValueCacheService() {
        Type2TypeCache = new ConcurrentHashMap();
        String deploy = System.getProperty("eas.deploy");
        String propFile = deploy + "/type2type.properties";
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            prop.load(fis);
        }
        catch (IOException e) {
            logger.warn((Object)("cannot load table2type file " + propFile));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        Enumeration<Object> keyEnum = prop.keys();
        while (keyEnum.hasMoreElements()) {
            String bosType = (String)keyEnum.nextElement();
            String typeSetStr = prop.getProperty(bosType);
            if (bosType == null || typeSetStr == null) continue;
            HashSet<String> typeSet = new HashSet<String>();
            String subStr = typeSetStr.substring(1, typeSetStr.length() - 1);
            StringTokenizer token = new StringTokenizer(subStr, ",");
            while (token.hasMoreTokens()) {
                String type = token.nextToken().trim();
                typeSet.add(type.substring(0, 8));
            }
            if (typeSet.size() <= 0) continue;
            Type2TypeCache.put(bosType.substring(0, 8), typeSet);
        }
    }

    @Override
    public IObjectValue get(Context ctx, BOSObjectType bostype, IObjectPK pk, String view) {
        return (IObjectValue)ORMCacheUtil.getInstance().getInfo(ctx, bostype, pk, view);
    }

    @Override
    public void put(Context ctx, BOSObjectType bostype, IObjectPK pk, String view, IObjectValue val) {
        ORMCacheUtil.getInstance().putInfo(ctx, bostype, pk, view, val);
    }

    @Override
    public void remove(Context ctx, BOSObjectType bostype, IObjectPK pk) {
        ORMCacheUtil.getInstance().removeInfo(ctx, bostype, pk.toString());
    }

    @Override
    public void remove(Context ctx, BOSObjectType bostype, String pk) {
        ORMCacheUtil.getInstance().removeInfo(ctx, bostype, pk);
    }

    @Override
    public void removeBatch(Context ctx, BOSObjectType bostype, IObjectPK[] pks) {
        String[] pkstr = new String[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            this.remove(ctx, bostype, pks[i]);
        }
    }

    @Override
    public void removeBatch(Context ctx, BOSObjectType bostype, String[] pks) {
        for (int i = 0; i < pks.length; ++i) {
            ORMCacheUtil.getInstance().removeInfo(ctx, bostype, pks[i]);
        }
    }

    @Override
    public void discardAll(Context ctx) {
        this.sendCommand(CacheCommandFactory.createKeyDiscardCacheCommand((String)ctx.getAIS()));
    }

    @Override
    public void discardType(Context ctx, BOSObjectType bostype) {
        ORMCacheUtil.getInstance().removeInfosByBosType(ctx, bostype);
    }

    @Override
    public void discardQuery(Context ctx, BOSObjectType bostype) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null && config.needQueryCache(bostype)) {
            ICacheCleanListener cleaner = CacheCleanManager.getCacheCleanListener();
            if (cleaner != null) {
                try {
                    CacheCleanEvent e = new CacheCleanEvent(bostype, null);
                    cleaner.registerMethod(e);
                }
                catch (Exception _) {
                    // empty catch block
                }
            }
            this.sendCommand(CacheCommandFactory.createRemoveCacheCommand(null, (String)(bostype + ctx.getAIS() + "QUERY")));
        }
    }

    @Override
    public void putQueryRs(Context ctx, BOSObjectType bostype, MultiParamKey pk, Object val) {
    }

    @Override
    public Object getQueryRs(Context ctx, BOSObjectType bostype, MultiParamKey pk) {
        return null;
    }

    private String getQueryKey(Context ctx, BOSObjectType bostype, MultiParamKey pk) {
        String key;
        Object obj = this.sendCommand(CacheCommandFactory.createGetOneCacheCommand(null, (String)(bostype + ctx.getAIS() + "QUERY"), (boolean)false));
        if (obj == null) {
            key = Utils.randomStr((String)"Query");
            this.sendCommand(CacheCommandFactory.createPutCacheCommand(null, (String)(bostype + ctx.getAIS() + "QUERY"), (Object)key, (long)0L));
        } else {
            key = (String)obj;
        }
        return key + pk.toString();
    }

    private String generateKey(Context ctx, BOSObjectType bostype, IObjectPK pk, String view) {
        if (!CacheCommandExecutor.getInstance().checkMemcachedService()) {
            return null;
        }
        String id = pk.toString();
        if (id.length() > 55) {
            id = Utils.transMD5((String)id);
        }
        String key = CacheCommandExecutor.getInstance().getOrmKey(bostype.toString(), ctx.getAIS(), id);
        return Utils.transMD5((String)(pk + "#" + key + "#" + view + "#" + ctx.getAIS() + "#" + bostype.toString()));
    }

    private Object sendCommand(ICacheCommand command) {
        if (command == null) {
            return null;
        }
        return command.execute();
    }

    @Override
    public void dealRelationType(Context ctx, BOSObjectType bostype) {
        HashSet<String> typeSet = Type2TypeCache.get(bostype.toString());
        if (typeSet != null && typeSet.size() > 0) {
            for (String relationType : typeSet) {
                if (relationType.equals(bostype)) {
                    this.sendCommand(CacheCommandFactory.createKeyDiscardByBostypeCacheCommand((String)bostype.toString(), (String)ctx.getAIS()));
                    this.discardQuery(ctx, bostype);
                    continue;
                }
                this.discardType(ctx, new BOSObjectType(relationType));
            }
        }
    }
}

