/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.kscript.IObjectLoaderProvider;
import com.kingdee.bos.kscript.dom.CodeObject;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class KscriptObjectLoaderProvider
implements IObjectLoaderProvider {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider");
    private Context context = null;

    public boolean lazyLoadFillValue(Object objValue) throws InterpreterException {
        boolean rtn = false;
        if (objValue instanceof IObjectValue) {
            IObjectValue objVal2 = (IObjectValue)objValue;
            boolean flag = true;
            if (objVal2.size() == 1 && objVal2.containsKey("id")) {
                flag = false;
            }
            if (!flag) {
                long startTime = System.currentTimeMillis();
                if (this.getBOSContext() != null) {
                    try {
                        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance(this.getBOSContext());
                        loader.fillValue(objVal2);
                        rtn = true;
                    }
                    catch (BOSException e) {
                        log.error((Object)("lazy load IObjectValue error." + e.getMessage()), (Throwable)e);
                        throw new InterpreterException("lazy load IObjectValue error." + e.getMessage(), (Throwable)e);
                    }
                } else {
                    log.warn((Object)"IObjectValue not exist , can not lazyload, because bosContext is null.");
                }
                long timeSpan = System.currentTimeMillis() - startTime;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lazy IObjectValue, BOSType : " + objVal2.getBOSType() + ", Cost : " + timeSpan));
                }
            }
        }
        return rtn;
    }

    public Object lazyLoadGetProperty(Object ownerValue, String propName, PropertyExpr propExpr) throws InterpreterException {
        Object rtn = null;
        if (ownerValue instanceof IObjectValue) {
            IObjectValue objValue = (IObjectValue)ownerValue;
            boolean isLoaded = true;
            if (!objValue.containsKey(propName)) {
                isLoaded = false;
            } else {
                IObjectCollection col;
                Object val = objValue.get(propName);
                if (val instanceof IObjectCollection && (col = (IObjectCollection)val).size() == 0) {
                    isLoaded = false;
                }
            }
            if (!isLoaded) {
                long startTime = System.currentTimeMillis();
                if (this.getBOSContext() != null) {
                    try {
                        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance(this.getBOSContext());
                        rtn = loader.getProperty(objValue, propName);
                    }
                    catch (BOSException e) {
                        log.error((Object)("lazy load IObjectValue error." + e.getMessage()), (Throwable)e);
                        throw new InterpreterException("lazy load IObjectValue error." + e.getMessage(), (CodeObject)propExpr, (Throwable)e);
                    }
                } else {
                    log.warn((Object)("IObjectValue not exist property '" + propName + "', can not lazyload, because bosContext is null."));
                }
                long timeSpan = System.currentTimeMillis() - startTime;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lazy IObjectValue, BOSType : " + objValue.getBOSType() + ", Not exist propertyName : " + propName + ", Cost : " + timeSpan));
                }
            }
        }
        return rtn;
    }

    public Context getBOSContext() {
        return this.context;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        if (context == null) {
            this.context = null;
        } else if (context instanceof Context) {
            this.context = (Context)context;
        } else {
            this.context = null;
            log.warn((Object)"setContext Error: the Context Type is not available!");
        }
    }

    public Object getObjectCollectionChildByIndex(Object value, int index) {
        if (this.getObjectCollectionSize(value) > index) {
            IObjectCollection objCol = (IObjectCollection)value;
            return objCol.getObject(index);
        }
        return null;
    }

    public boolean isObjectCollection(Object value) {
        return value instanceof IObjectCollection;
    }

    public boolean isObjectValue(Object value) {
        return value instanceof IObjectValue;
    }

    public boolean isObjectValueContainPropName(Object value, String propName) {
        if (this.isObjectValue(value)) {
            IObjectValue objVal = (IObjectValue)value;
            return objVal.containsKey(propName);
        }
        return false;
    }

    public int getObjectCollectionSize(Object value) {
        if (this.isObjectCollection(value)) {
            IObjectCollection objCol = (IObjectCollection)value;
            return objCol.size();
        }
        return -1;
    }

    public Object getObjectValuePropValueByName(Object value, String propName) {
        if (this.isObjectValueContainPropName(value, propName)) {
            IObjectValue objVal = (IObjectValue)value;
            return objVal.get(propName);
        }
        return null;
    }

    public void setObjectValuePropValue(Object value, String propName, Object val) {
        if (this.isObjectValue(value)) {
            IObjectValue objVal = (IObjectValue)value;
            objVal.put(propName, val);
        }
    }

    public Iterator getObjectCollectionIterator(Object value) {
        if (this.isObjectCollection(value)) {
            IObjectCollection objCol = (IObjectCollection)value;
            return objCol.iterator();
        }
        return null;
    }

    public boolean isBOSContext(Object value) {
        return value instanceof Context;
    }

    public boolean isObjectPK(Object value) {
        return value instanceof IObjectPK;
    }

    public String getObjectValuePKField(Object value) {
        if (this.isObjectValue(value)) {
            IObjectValue objVal = (IObjectValue)value;
            return objVal.getPKField();
        }
        return null;
    }
}

