/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectReader;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfoCreator;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.sql.SQLException;

public class ORMappingDAOUtils {
    public static String getSQLByOQL(BOSObjectType bosType, String oql, Context ctx) throws DataAccessException {
        EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)bosType, (EntityObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType));
        return ORMappingDAOUtils.getSQLByEntityView(bosType, view, ctx);
    }

    public static String getSQLByEntityView(BOSObjectType bosType, EntityViewInfo view, Context ctx) throws DataAccessException {
        if (view == null || bosType == null) {
            return "";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(bosType);
        if (bo == null) {
            return "";
        }
        try {
            ImplUtils.processEntryFilter(bo, view, ctx);
            SolutionInfo solution = loader.getSolution();
            return new ObjectReader(ctx, null, solution).getSelectSQL(bo, view);
        }
        catch (SQLException sqle) {
            throw new DataAccessException((Throwable)sqle);
        }
        catch (BOSException bose) {
            if (bose instanceof DataAccessException) {
                throw (DataAccessException)bose;
            }
            throw new DataAccessException((Throwable)bose);
        }
    }
}

