/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.TypelessObjectCollection;
import com.kingdee.bos.dao.TypelessObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectIntPK;
import com.kingdee.bos.dao.ormapping.ObjectLongPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectFilter;
import com.kingdee.bos.dao.ormapping.impl.ObjectValueToMap;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static IObjectCollection newObjectCollectionInstance(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        assert (bo != null);
        String className = bo.getObjectCollectionClassRuntime();
        if (StringUtils.isEmpty((String)className)) {
            return new TypelessObjectCollection();
        }
        try {
            Class clazz = bo.getObjectCollectionClazzRuntime();
            return (IObjectCollection)clazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidDAOMetaDataException("create object by objectCollectionClass error. entity name:" + bo.getName() + "\n" + e.getMessage(), (Throwable)e);
        }
    }

    public static IObjectValue newObjectValueInstance(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        assert (bo != null);
        String className = bo.getObjectValueClassRuntime();
        if (StringUtils.isEmpty((String)className)) {
            return new TypelessObjectValue();
        }
        try {
            Class clazz = bo.getObjectValueClazzRuntime();
            return Utils.newObjectValueInstance(clazz, bo.getFullName(), bo.getType());
        }
        catch (Exception e) {
            throw new InvalidDAOMetaDataException("create object by objectValueClass error. entity name:" + bo.getName() + "\n" + e.getMessage(), (Throwable)e);
        }
    }

    public static IObjectValue newObjectValueInstance(Class clazz, String boFullName, BOSObjectType boType) throws InvalidDAOMetaDataException {
        if (clazz == null || boFullName == null || boType == null) {
            return new TypelessObjectValue();
        }
        try {
            IObjectValue ov = (IObjectValue)clazz.newInstance();
            if (ov instanceof ICommonBOSType) {
                ((ICommonBOSType)ov).setPK((IMetaDataPK)MetaDataPK.create((String)boFullName));
                ((ICommonBOSType)ov).setBOSType(boType);
            }
            return ov;
        }
        catch (Exception e) {
            throw new InvalidDAOMetaDataException("create object by objectValueClass error. entity name:" + boFullName + "\n" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectValue getObjectValue(Context ctx, BOSUuid bosId) throws BOSException {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx");
        }
        if (bosId == null) {
            throw new IllegalArgumentException("bosId");
        }
        BOSObjectType bosType = bosId.getType();
        Connection cn = null;
        try {
            cn = Utils.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, ctx, cn);
            IObjectValue iObjectValue = dao.getValue((IObjectPK)new ObjectUuidPK(bosId));
            return iObjectValue;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectCollection getObjectCollection(Context ctx, BOSObjectType bosType, String oql) throws BOSException {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx");
        }
        if (bosType == null) {
            throw new IllegalArgumentException("bosType");
        }
        if (StringUtils.isEmpty((String)oql)) {
            throw new IllegalArgumentException("oql");
        }
        Connection cn = null;
        try {
            cn = Utils.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, ctx, cn);
            IObjectCollection iObjectCollection = dao.getCollection(oql);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectCollection getObjectCollection(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo) throws BOSException {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx");
        }
        if (bosType == null) {
            throw new IllegalArgumentException("bosType");
        }
        if (viewInfo == null) {
            throw new IllegalArgumentException("viewInfo");
        }
        Connection cn = null;
        try {
            cn = Utils.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, ctx, cn);
            IObjectCollection iObjectCollection = dao.getCollection(viewInfo);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateObjectValue(Context ctx, BOSUuid bosId, IObjectValue obj) throws BOSException {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx");
        }
        if (bosId == null) {
            throw new IllegalArgumentException("bosId");
        }
        BOSObjectType bosType = bosId.getType();
        Connection cn = null;
        try {
            cn = Utils.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, ctx, cn);
            dao.update((IObjectPK)new ObjectUuidPK(bosId), obj);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private static final Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection(ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static IObjectPK getObjectPK(EntityObjectInfo entity, IObjectValue ov) {
        IObjectPK pk = Utils.createObjectPK(entity);
        PropertyCollection keyFields = entity.getLogicalKey().getKeyPropertys();
        int len = keyFields.size();
        for (int j = 0; j < len; ++j) {
            PropertyInfo prop = keyFields.get(j);
            String propName = prop.getName();
            Object keyValue = null;
            if (prop instanceof OwnPropertyInfo) {
                keyValue = ov.get(propName);
                if (keyValue != null) {
                    pk.setKeyValue(propName, keyValue);
                    continue;
                }
                return null;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(entity, (LinkPropertyInfo)prop);
            PropertyInfo temp = relation.getSupplierObject().getLogicalKey().getKeyPropertys().get(0);
            IObjectValue child = ov.getObjectValue(propName);
            if (child != null) {
                keyValue = child.get(temp.getName());
            }
            if (keyValue != null) {
                pk.setKeyValue(propName, keyValue);
                continue;
            }
            return null;
        }
        return pk;
    }

    public static IObjectPK createObjectPK(EntityObjectInfo entity) {
        LogicalKeyInfo logicalKey = entity.getLogicalKey();
        String pkClassName = logicalKey.getKeyClass();
        if (StringUtils.isEmpty((String)pkClassName) || IObjectPK.class.getName().equals(pkClassName)) {
            if (logicalKey.getKeyPropertys().size() == 1) {
                DataType dataType = null;
                PropertyInfo prop = logicalKey.getKeyPropertys().get(0);
                if (prop instanceof OwnPropertyInfo) {
                    dataType = ((OwnPropertyInfo)prop).getDataType();
                } else if (prop instanceof LinkPropertyInfo) {
                    throw new AssertionError((Object)"Single logical key can not be linkproperty");
                }
                pkClassName = DataType.INTEGER.equals((Object)dataType) ? ObjectIntPK.class.getName() : (DataType.LONG.equals((Object)dataType) ? ObjectLongPK.class.getName() : (DataType.STRING.equals((Object)dataType) ? ObjectStringPK.class.getName() : (DataType.UUID.equals((Object)dataType) || DataType.BOSUUID.equals((Object)dataType) ? ObjectUuidPK.class.getName() : ObjectSingleKey.class.getName())));
            } else {
                pkClassName = ObjectMultiPK.class.getName();
            }
            logicalKey.setKeyClass(pkClassName);
        }
        try {
            return (IObjectPK)Class.forName(pkClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new AssertionError((Object)cnfe.toString());
        }
    }

    public static String removeSpecialTAG(String src, String tag) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isEmpty((String)src) || StringUtils.isEmpty((String)tag)) {
            return src;
        }
        int step = tag.length();
        for (int i = 0; i < src.length(); ++i) {
            if (i < src.length() - step) {
                String s1 = src.substring(i, i + step);
                if (!tag.equalsIgnoreCase(s1)) {
                    sb.append(src.substring(i, i + 1));
                    continue;
                }
                i = i + step - 1;
                continue;
            }
            sb.append(src.substring(i, i + 1));
        }
        return sb.toString();
    }

    public static IObjectValue filteObjectValue(IObjectValue ov, String oql, boolean isReturnNew) throws BOSException {
        try {
            EntityViewInfo fi = new EntityViewInfo(oql);
            return Utils.filteObjectValue(ov, fi, isReturnNew);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static IObjectValue filteObjectValue(IObjectValue ov, EntityViewInfo evi, boolean isReturnNew) throws BOSException {
        return Utils.filteObjectValue(ov, evi.getFilter(), isReturnNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectValue filteObjectValue(IObjectValue ov, FilterInfo mainRule, boolean isReturnNew) throws BOSException {
        block7: {
            IObjectValue nov = null;
            if (isReturnNew) {
                try {
                    nov = (IObjectValue)ObjectUtils.createCopy((Object)ov);
                }
                catch (Exception e) {
                    nov = ov;
                }
            } else {
                nov = ov;
            }
            ObjectFilter of = new ObjectFilter();
            boolean b = of.filte(nov, mainRule);
            if (!b) break block7;
            IObjectValue iObjectValue = nov;
            return iObjectValue;
        }
        IObjectValue iObjectValue = null;
        return iObjectValue;
    }

    public static IObjectCollection filteObjectCollection(IObjectCollection ov, String oql, boolean isReturnNew) throws BOSException {
        try {
            EntityViewInfo fi = new EntityViewInfo(oql);
            return Utils.filteObjectCollection(ov, fi, isReturnNew);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static IObjectCollection filteObjectCollection(IObjectCollection ov, EntityViewInfo evi, boolean isReturnNew) throws BOSException {
        return Utils.filteObjectCollection(ov, evi.getFilter(), isReturnNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectCollection filteObjectCollection(IObjectCollection ov, FilterInfo mainRule, boolean isReturnNew) throws BOSException {
        IObjectCollection nov = null;
        try {
            nov = (IObjectCollection)ov.getClass().newInstance();
        }
        catch (Exception e) {
            try {
                nov = (IObjectCollection)ObjectUtils.createCopy((Object)ov);
                nov.clear();
            }
            catch (Exception ex) {
                return null;
            }
        }
        ObjectFilter of = new ObjectFilter();
        int len = ov.size();
        for (int i = 0; i < len; ++i) {
            boolean b;
            IObjectValue iov = ov.getObject(i);
            IObjectValue tov = null;
            if (isReturnNew) {
                try {
                    tov = (IObjectValue)ObjectUtils.createCopy((Object)iov);
                }
                catch (Exception e) {
                    tov = iov;
                }
            } else {
                tov = iov;
            }
            if (!(b = of.filte(tov, mainRule))) continue;
            nov.addObject(tov);
        }
        IObjectCollection iObjectCollection = nov;
        return iObjectCollection;
    }

    public static List objectValueToMap(IObjectValue value, String[] props) {
        ObjectValueToMap vtm = new ObjectValueToMap();
        return vtm.execute(value, props);
    }
}

