/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.client;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.ormapping.client.IObjectLoader;
import com.kingdee.bos.dao.ormapping.client.LinkPropInfo;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ObjectLoader
extends AbstractBOSObject
implements IObjectLoader {
    public ObjectLoader(Context ctx) {
        super(ctx);
        this.registerInterface(IObjectLoader.class, this);
    }

    public ObjectLoader() {
        this.registerInterface(IObjectLoader.class, this);
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public IObjectValue fillLinkProperty(IObjectValue oldData, SelectorItemCollection selectors) throws DataAccessException {
        if (oldData == null || oldData.getBOSType() == null) {
            throw new IllegalArgumentException("data is null or data has not BOSType");
        }
        IObjectValue value = oldData;
        IObjectValue returnValue = oldData;
        oldData.setDefaultLocale(this.getContext().getLocale());
        EntityObjectInfo bo = this.getEntityObject(oldData.getBOSType());
        List selectorList = this.ConstructSelectors(selectors, bo);
        for (LinkPropInfo link : selectorList) {
            String linkName = link.getLinkPropName();
            LinkPropertyInfo prop = (LinkPropertyInfo)bo.getPropertyByNameRuntime(linkName);
            if (CardinalityType.isOneORZero((CardinalityType)prop.getRelationship().getChildCardinality(bo))) {
                if (value.getObjectValue(linkName) == null) continue;
                BOSUuid bosID = value.getObjectValue(linkName).getBOSUuid(value.getObjectValue(linkName).getPKField());
                if (bosID == null) {
                    throw new IllegalArgumentException(value.getPKField() + " not  value");
                }
                IObjectValue valueFromDB = this.getObjectValueFromDB(value.getObjectValue(linkName).getBOSType(), (IObjectPK)new ObjectUuidPK(bosID), link.getSelectorCollection());
                if (valueFromDB == null) {
                    throw new ObjectNotFoundException("cannot find record: pk: " + bosID.toString());
                }
                returnValue.put(linkName, (Object)this.mergeValue(value.getObjectValue(linkName), valueFromDB));
                continue;
            }
            IObjectCollection collection = (IObjectCollection)value.get(linkName);
            HashSet<BOSUuid> ids = new HashSet<BOSUuid>(0);
            int n = collection.size();
            for (int m = 0; m < n; ++m) {
                IObjectValue multValue = collection.getObject(m);
                BOSUuid bosID = multValue.getBOSUuid(multValue.getPKField());
                if (bosID == null) {
                    throw new IllegalArgumentException(multValue.getPKField() + " not  value");
                }
                ids.add(bosID);
            }
            if (ids.size() <= 0) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection si = link.getSelectorCollection();
            int n2 = si.size();
            for (int m = 0; m < n2; ++m) {
                view.getSelector().add(si.get(m));
            }
            filter.getFilterItems().add(new FilterItemInfo(collection.getObject(0).getPKField(), ids, CompareType.INCLUDE));
            view.setFilter(filter);
            IObjectCollection valuesFromDB = this.getObjectCollectionFromDB(collection.getObject(0).getBOSType(), view);
            if (valuesFromDB == null) {
                throw new ObjectNotFoundException("cannot find records");
            }
            returnValue.put(linkName, (Object)valuesFromDB);
        }
        return returnValue;
    }

    private EntityObjectInfo getEntityObject(BOSObjectType type) {
        if (type == null) {
            throw new IllegalArgumentException("Unknown BOSType.");
        }
        return MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getEntity(type);
    }

    private IObjectValue getObjectValueFromDB(BOSObjectType type, IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(this.getContext());
            IORMappingDAO dao = ORMappingDAO.getInstance(type, this.getContext(), cn);
            IObjectValue iObjectValue = dao.getValue(pk, selector);
            return iObjectValue;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private IObjectCollection getObjectCollectionFromDB(BOSObjectType type, EntityViewInfo view) throws DataAccessException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(this.getContext());
            IORMappingDAO dao = ORMappingDAO.getInstance(type, this.getContext(), cn);
            IObjectCollection iObjectCollection = dao.getCollection(view);
            return iObjectCollection;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private List ConstructSelectors(SelectorItemCollection selectors, EntityObjectInfo bo) throws DataAccessException {
        ArrayList<String> list = new ArrayList<String>(0);
        ArrayList<LinkPropInfo> backList = new ArrayList<LinkPropInfo>(0);
        int j = selectors.size();
        for (int i = 0; i < j; ++i) {
            list.add(selectors.get(i).getPropertyName());
        }
        Collections.sort(list);
        Iterator iterator = list.iterator();
        String perviewItem = null;
        SelectorItemCollection si = new SelectorItemCollection();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (item.indexOf(".") > 0) {
                String propName = item.substring(0, item.indexOf("."));
                if (propName.equals(perviewItem)) {
                    si.add(new SelectorItemInfo(item.substring(item.indexOf(".") + 1)));
                    continue;
                }
                PropertyInfo prop = bo.getPropertyByNameRuntime(propName);
                if (prop == null) {
                    throw new InvalidDAOMetaDataException("cannot found property : " + propName + ",  bo : " + bo.getName());
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                if (perviewItem != null) {
                    backList.add(new LinkPropInfo(perviewItem, (SelectorItemCollection)si.clone()));
                }
                si.clear();
                si.add(new SelectorItemInfo(item.substring(item.indexOf(".") + 1)));
                perviewItem = propName;
                continue;
            }
            if (!"*".equals(item)) continue;
        }
        if (si.size() > 0) {
            backList.add(new LinkPropInfo(perviewItem, si));
        }
        return backList;
    }

    @Override
    public IObjectValue fillLinkProperty(IObjectValue oldData, String oql) throws DataAccessException {
        return null;
    }

    @Override
    public IObjectValue fillLinkProperty(IObjectValue oldData, EntityViewInfo view) throws DataAccessException {
        return null;
    }

    private IObjectValue mergeValue(IObjectValue oldValue, IObjectValue newValue) {
        BOSObjectType type = newValue.getBOSType();
        if (type == null) {
            throw new IllegalArgumentException("Unknown BOSType.");
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getEntity(type);
        PropertyCollection props = entity.getInheritedNoDuplicatedPropertiesRuntime();
        int j = props.size();
        for (int i = 0; i < j; ++i) {
            String propName = props.get(i).getName();
            if (newValue.get(propName) == null) continue;
            oldValue.put(propName, newValue.get(propName));
        }
        return oldValue;
    }
}

