/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.contrast;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.contrast.ValueAccess;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Null;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InfoAccess {
    protected static Logger logger = Logger.getLogger(InfoAccess.class);
    public static final String FIELD = "field";
    public static final String INFOLIST = "infoList";
    public static final String OLDVAL = "oldVal";
    public static final String NEWVAL = "newVal";
    public static final String LOGICKEY = "logicKey";
    public static final String INDEX = "index";
    public static final String ID = "id";
    public static final String INFOMAP = "infoMap";
    public static final String ADDMAP = "addMap";
    public static final String DELETEMAP = "deleteMap";
    public static final String UPDATEMAP = "updateMap";
    public static final String ADDLIST = "addList";
    public static final String DELETELIST = "deleteList";
    public static final String UPDATELIST = "updateList";
    public static final String CHANGEFLAG = "changeFlag";
    private EntityObjectInfo bo;
    private IObjectValue oldValue;
    private IObjectValue newValue;
    private Boolean changeFlag = false;
    private Map addMap = new HashMap();
    private Map deleteMap = new HashMap();
    private Map updateMap = new HashMap();

    public InfoAccess(EntityObjectInfo bo) {
        this.bo = bo;
    }

    public InfoAccess(EntityObjectInfo bo, IObjectValue newValue, IObjectValue oldValue) {
        this.bo = bo;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public InfoAccess(EntityObjectInfo bo, IObjectValue newValue, Map map) {
        this.bo = bo;
        this.newValue = newValue;
        if (map != null) {
            if (map.containsKey(ADDMAP)) {
                this.addMap = (Map)map.get(ADDMAP);
            }
            if (map.containsKey(DELETEMAP)) {
                this.deleteMap = (Map)map.get(DELETEMAP);
            }
            if (map.containsKey(UPDATEMAP)) {
                this.updateMap = (Map)map.get(UPDATEMAP);
            }
        }
    }

    public IObjectValue getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(IObjectValue oldValue) {
        this.oldValue = oldValue;
    }

    public IObjectValue getNewValue() {
        return this.newValue;
    }

    public void setNewValue(IObjectValue newValue) {
        this.newValue = newValue;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection col = new SelectorItemCollection();
        PropertyCollection flds = this.bo.getPropertiesRuntime();
        int fldSize = flds.size();
        for (int i = 0; i < fldSize; ++i) {
            PropertyInfo fld = flds.get(i);
            String fldName = fld.getName();
            if (fld instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ImplUtils.getRTRelation(this.bo, (LinkPropertyInfo)fld);
                EntityObjectInfo linkBO = relation.getChildObject(this.bo);
                if (this.isEntry(fld)) {
                    InfoAccess childInfoAccess = new InfoAccess(linkBO);
                    SelectorItemCollection childCol = childInfoAccess.getSelectors();
                    for (SelectorItemInfo item : childCol) {
                        col.add(fldName + "." + item.getPropertyName());
                    }
                    continue;
                }
                if (this.isF7LinkPro(fld)) {
                    if (linkBO.getPropertyByNameRuntime(ID) != null) {
                        col.add(fldName + ".id");
                    }
                    if (linkBO.getPropertyByNameRuntime("name") != null) {
                        col.add(fldName + ".name");
                    }
                    if (linkBO.getPropertyByNameRuntime("number") == null) continue;
                    col.add(fldName + ".number");
                    continue;
                }
                col.add(fldName + ".*");
                continue;
            }
            col.add(fldName);
        }
        return col;
    }

    private boolean isF7LinkPro(PropertyInfo property) {
        RelationshipInfo relationship;
        return !(!(property instanceof LinkPropertyInfo) || (relationship = ((LinkPropertyInfo)property).getRelationship()) == null || relationship.getClientObject() == null || !CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality()) || !CardinalityType.ONE.equals((Object)relationship.getSupplierCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getSupplierCardinality()));
    }

    private boolean isEntry(PropertyInfo property) {
        RelationshipInfo relationship;
        return !(!(property instanceof LinkPropertyInfo) || (relationship = ((LinkPropertyInfo)property).getRelationship()).isReverseLink(this.bo) || !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) && (relationship == null || relationship.getClientObject() == null || !RelationshipType.COMPOSITION.equals((Object)relationship.getType()) || !CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality()) || !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality())));
    }

    public Map<String, Object> contrastInfoToMap() throws Exception {
        PropertyCollection flds = this.bo.getPropertiesRuntime();
        int fldSize = flds.size();
        for (int i = 0; i < fldSize; ++i) {
            PropertyInfo fld = flds.get(i);
            String fldName = fld.getName();
            Object newVal = this.newValue.get(fldName);
            if (this.isEntry(fld)) {
                this.compareCollection(fld, (AbstractObjectCollection)newVal, (AbstractObjectCollection)this.oldValue.get(fldName));
                continue;
            }
            this.compareObjectValue(fldName, newVal, this.oldValue.get(fldName));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ADDMAP, this.addMap);
        map.put(DELETEMAP, this.deleteMap);
        map.put(UPDATEMAP, this.updateMap);
        return map;
    }

    private void compareCollection(PropertyInfo fld, AbstractObjectCollection newCol, AbstractObjectCollection oldCol) throws Exception {
        if (fld instanceof LinkPropertyInfo) {
            HashMap<String, Object> map;
            String[] logicKeys;
            RelationshipInfo relation = ImplUtils.getRTRelation(this.bo, (LinkPropertyInfo)fld);
            EntityObjectInfo childBO = relation.getChildObject(this.bo);
            String fldName = fld.getName();
            PropertyCollection keys = childBO.getLogicalKeyPropertiesRuntime();
            if (keys != null) {
                logicKeys = new String[keys.size()];
                for (int i = 0; i < logicKeys.length; ++i) {
                    logicKeys[i] = keys.get(i).getName();
                }
            } else {
                logicKeys = null;
            }
            HashMap<String, Integer> oldColMap = new HashMap<String, Integer>();
            if (oldCol != null) {
                for (int index = 0; index < oldCol.size(); ++index) {
                    IObjectValue oldVal = oldCol.getObject(index);
                    oldColMap.put(InfoAccess.getLogicKey(logicKeys, oldVal), index);
                }
            }
            ArrayList<Object> adds = new ArrayList<Object>();
            ArrayList<Object> deletes = new ArrayList<Object>();
            ArrayList<Object> updates = new ArrayList<Object>();
            if (newCol != null) {
                for (int i = 0; i < newCol.size(); ++i) {
                    IObjectValue newVal = newCol.getObject(i);
                    String logicKey = InfoAccess.getLogicKey(logicKeys, newVal);
                    if (logicKey != null) {
                        if (oldColMap.get(logicKey) != null) {
                            IObjectValue oldVal = oldCol.getObject(((Integer)oldColMap.get(logicKey)).intValue());
                            if (oldVal == null) continue;
                            InfoAccess childInfoAccess = new InfoAccess(childBO, newVal, oldVal);
                            Map<String, Object> childMap = childInfoAccess.contrastInfoToMap();
                            if (childInfoAccess.getChangeFlag().booleanValue()) {
                                HashMap<String, Object> map2 = new HashMap<String, Object>();
                                map2.put(LOGICKEY, logicKey);
                                map2.put(INDEX, i);
                                map2.put(INFOMAP, childMap);
                                updates.add(map2);
                            }
                            oldColMap.remove(logicKey);
                            continue;
                        }
                        map = new HashMap();
                        map.put(NEWVAL, newVal);
                        map.put(INDEX, i);
                        adds.add(map);
                        continue;
                    }
                    map = new HashMap();
                    map.put(NEWVAL, newVal);
                    map.put(INDEX, i);
                    adds.add(map);
                }
            }
            for (Map.Entry e : oldColMap.entrySet()) {
                Integer index = (Integer)e.getValue();
                map = new HashMap<String, Object>();
                map.put(OLDVAL, oldCol.getObject(index.intValue()));
                map.put(INDEX, index);
                deletes.add(map);
            }
            if (adds.size() > 0) {
                this.changeFlag = true;
                this.addMap.put(fldName, new ValueAccess(adds));
            }
            if (deletes.size() > 0) {
                this.changeFlag = true;
                this.deleteMap.put(fldName, new ValueAccess(deletes));
            }
            if (updates.size() > 0) {
                this.changeFlag = true;
                this.updateMap.put(fldName, new ValueAccess(updates));
            }
        }
    }

    private static String getLogicKey(String[] logicKeys, IObjectValue data) {
        String tmp = null;
        boolean invalid = false;
        for (int i = 0; i < logicKeys.length; ++i) {
            Object obj = data.get(logicKeys[i]);
            if (obj != null) {
                if (i == 0) {
                    tmp = obj.toString();
                    continue;
                }
                tmp = tmp + "$" + obj.toString();
                continue;
            }
            invalid = true;
            break;
        }
        if (invalid) {
            return null;
        }
        return tmp;
    }

    private void compareObjectValue(Object fldName, Object newVal, Object oldVal) {
        if (newVal != null && oldVal == null) {
            this.changeFlag = true;
            this.addMap.put(fldName, new ValueAccess(null, newVal));
        } else if (newVal == null && oldVal != null) {
            this.changeFlag = true;
            this.deleteMap.put(fldName, new ValueAccess(oldVal, null));
        } else if (newVal != null && oldVal != null && !InfoAccess.compareValue(oldVal, newVal)) {
            this.changeFlag = true;
            this.updateMap.put(fldName, new ValueAccess(oldVal, newVal));
        }
    }

    private static boolean compareValue(Object value1, Object value2) {
        if (InfoAccess.isEmptyObject(value1) && InfoAccess.isEmptyObject(value2)) {
            return true;
        }
        if (InfoAccess.isEmptyObject(value1) || InfoAccess.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = Boolean.parseBoolean(value2.toString());
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo(Byte.valueOf(value2.toString())) == 0;
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo(Short.valueOf(value2.toString())) == 0;
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo(Integer.valueOf(value2.toString())) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo(Long.valueOf(value2.toString())) == 0;
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo(Float.valueOf(value2.toString())) == 0;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo(Double.valueOf(value2.toString())) == 0;
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo(new BigDecimal(value2.toString())) == 0;
        }
        if (value1 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Object[]) {
            Object[] arrValue1 = (Object[])value1;
            Object[] arrValue2 = (Object[])value2;
            if (arrValue1.length != arrValue2.length) {
                return false;
            }
            boolean retValue = true;
            for (int i = 0; i < arrValue1.length && retValue; ++i) {
                retValue = InfoAccess.compareValue(arrValue1[i], arrValue2[i]);
            }
            return retValue;
        }
        if (value1 instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue1 = (AbstractObjectValue)value1;
            AbstractObjectValue objectValue2 = (AbstractObjectValue)value2;
            String pkField1 = objectValue1.getPKField();
            String pkField2 = objectValue1.getPKField();
            if (pkField1 != null && pkField2 != null) {
                if (pkField1.equals(pkField2)) {
                    return InfoAccess.compareValue(objectValue1.get(pkField1), objectValue2.get(pkField2));
                }
                return false;
            }
        }
        return value1.equals(value2);
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    public IObjectValue transFormForOldValue() {
        Integer index;
        Map child;
        List<Object> childList;
        Object val;
        PropertyInfo fld;
        ValueAccess valueAccess;
        String fldName;
        if (this.bo == null || this.newValue == null) {
            return null;
        }
        this.oldValue = this.newValue;
        for (Map.Entry e : this.updateMap.entrySet()) {
            fldName = (String)e.getKey();
            valueAccess = (ValueAccess)e.getValue();
            if (fldName == null) continue;
            Object oldVal = this.oldValue.get(fldName);
            fld = this.bo.getPropertyByNameRuntime(fldName);
            if (this.isEntry(fld)) {
                List<Object> childList2;
                String[] logicKeys;
                if (!(fld instanceof LinkPropertyInfo)) continue;
                RelationshipInfo relation = ImplUtils.getRTRelation(this.bo, (LinkPropertyInfo)fld);
                EntityObjectInfo childBO = relation.getChildObject(this.bo);
                PropertyCollection keys = childBO.getLogicalKeyPropertiesRuntime();
                if (keys != null) {
                    logicKeys = new String[keys.size()];
                    for (int k = 0; k < logicKeys.length; ++k) {
                        logicKeys[k] = keys.get(k).getName();
                    }
                } else {
                    logicKeys = null;
                }
                AbstractObjectCollection valCol = (AbstractObjectCollection)oldVal;
                HashMap<String, Integer> colMap = new HashMap<String, Integer>();
                if (valCol != null) {
                    for (int index2 = 0; index2 < valCol.size(); ++index2) {
                        IObjectValue val2 = valCol.getObject(index2);
                        colMap.put(InfoAccess.getLogicKey(logicKeys, val2), index2);
                    }
                }
                if ((childList2 = valueAccess.getInfoList()) == null) continue;
                for (int j = 0; j < childList2.size(); ++j) {
                    Map child2 = (Map)childList2.get(j);
                    String logicKey = (String)child2.get(LOGICKEY);
                    IObjectValue childVal = ((AbstractObjectCollection)oldVal).getObject(((Integer)colMap.get(logicKey)).intValue());
                    Map childInfoMap = (Map)child2.get(INFOMAP);
                    InfoAccess childInfoAccess = new InfoAccess(childBO, childVal, childInfoMap);
                    childVal = childInfoAccess.transFormForOldValue();
                }
                continue;
            }
            this.oldValue.put(fldName, valueAccess.getOldVal());
        }
        for (Map.Entry e : this.addMap.entrySet()) {
            fldName = (String)e.getKey();
            valueAccess = (ValueAccess)e.getValue();
            if (fldName == null) continue;
            val = this.oldValue.get(fldName);
            fld = this.bo.getPropertyByNameRuntime(fldName);
            if (this.isEntry(fld)) {
                childList = valueAccess.getInfoList();
                if (childList == null) continue;
                for (int j = childList.size() - 1; j >= 0; --j) {
                    child = (Map)childList.get(j);
                    index = (Integer)child.get(INDEX);
                    ((AbstractObjectCollection)val).removeObject(index.intValue());
                }
                continue;
            }
            this.oldValue.put(fldName, null);
        }
        for (Map.Entry e : this.deleteMap.entrySet()) {
            fldName = (String)e.getKey();
            valueAccess = (ValueAccess)e.getValue();
            if (fldName == null) continue;
            val = this.oldValue.get(fldName);
            fld = this.bo.getPropertyByNameRuntime(fldName);
            if (this.isEntry(fld)) {
                childList = valueAccess.getInfoList();
                if (childList == null) continue;
                for (int j = 0; j < childList.size(); ++j) {
                    child = (Map)childList.get(j);
                    index = (Integer)child.get(INDEX);
                    ((AbstractObjectCollection)val).addObject(index.intValue(), (IObjectValue)child.get(OLDVAL));
                }
                continue;
            }
            Object oldVal = valueAccess.getOldVal();
            this.oldValue.put(fldName, oldVal);
        }
        return this.oldValue;
    }

    public Map transFormForMap() {
        HashMap<String, Object> map;
        HashMap<String, Object> map2;
        String logicKey;
        IObjectValue childVal;
        Integer index;
        Map child;
        ArrayList infoList;
        List<Object> childList;
        Object newVal;
        String[] logicKeys;
        PropertyCollection keys;
        EntityObjectInfo childBO;
        RelationshipInfo relation;
        PropertyInfo fld;
        ValueAccess valueAccess;
        String fldName;
        ArrayList addList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        ArrayList updateList = new ArrayList();
        HashMap newMap = new HashMap();
        for (Map.Entry e : this.addMap.entrySet()) {
            fldName = (String)e.getKey();
            valueAccess = (ValueAccess)e.getValue();
            if (fldName == null) continue;
            fld = this.bo.getPropertyByNameRuntime(fldName);
            if (this.isEntry(fld)) {
                relation = ImplUtils.getRTRelation(this.bo, (LinkPropertyInfo)fld);
                childBO = relation.getChildObject(this.bo);
                keys = childBO.getLogicalKeyPropertiesRuntime();
                if (keys != null) {
                    logicKeys = new String[keys.size()];
                    for (int k = 0; k < logicKeys.length; ++k) {
                        logicKeys[k] = keys.get(k).getName();
                    }
                } else {
                    logicKeys = null;
                }
                newVal = this.newValue.get(fldName);
                childList = valueAccess.getInfoList();
                infoList = new ArrayList();
                if (childList != null) {
                    for (int j = childList.size() - 1; j >= 0; --j) {
                        child = (Map)childList.get(j);
                        index = (Integer)child.get(INDEX);
                        childVal = ((AbstractObjectCollection)newVal).getObject(index.intValue());
                        logicKey = InfoAccess.getLogicKey(logicKeys, childVal);
                        HashMap<String, String> map3 = new HashMap<String, String>();
                        map3.put(ID, logicKey);
                        infoList.add(map3);
                    }
                }
                map2 = new HashMap<String, Object>();
                map2.put(FIELD, fldName);
                map2.put(INFOLIST, infoList);
                addList.add(map2);
                continue;
            }
            map = new HashMap<String, Object>();
            map.put(FIELD, fldName);
            map.put(NEWVAL, valueAccess.getNewVal());
            addList.add(map);
        }
        newMap.put(ADDLIST, addList);
        for (Map.Entry e : this.deleteMap.entrySet()) {
            fldName = (String)e.getKey();
            valueAccess = (ValueAccess)e.getValue();
            if (fldName == null) continue;
            fld = this.bo.getPropertyByNameRuntime(fldName);
            if (this.isEntry(fld)) {
                relation = ImplUtils.getRTRelation(this.bo, (LinkPropertyInfo)fld);
                childBO = relation.getChildObject(this.bo);
                keys = childBO.getLogicalKeyPropertiesRuntime();
                if (keys != null) {
                    logicKeys = new String[keys.size()];
                    for (int k = 0; k < logicKeys.length; ++k) {
                        logicKeys[k] = keys.get(k).getName();
                    }
                } else {
                    logicKeys = null;
                }
                List<Object> childList2 = valueAccess.getInfoList();
                ArrayList infoList2 = new ArrayList();
                if (childList2 != null) {
                    for (int j = 0; j < childList2.size(); ++j) {
                        Map child2 = (Map)childList2.get(j);
                        IObjectValue childVal2 = (IObjectValue)child2.get(OLDVAL);
                        String logicKey2 = InfoAccess.getLogicKey(logicKeys, childVal2);
                        HashMap<String, String> map4 = new HashMap<String, String>();
                        map4.put(ID, logicKey2);
                        infoList2.add(map4);
                    }
                }
                HashMap<String, Object> map5 = new HashMap<String, Object>();
                map5.put(FIELD, fldName);
                map5.put(INFOLIST, infoList2);
                deleteList.add(map5);
                continue;
            }
            map = new HashMap();
            map.put(FIELD, fldName);
            map.put(OLDVAL, valueAccess.getOldVal());
            deleteList.add(map);
        }
        newMap.put(DELETELIST, deleteList);
        for (Map.Entry e : this.updateMap.entrySet()) {
            fldName = (String)e.getKey();
            valueAccess = (ValueAccess)e.getValue();
            if (fldName == null) continue;
            fld = this.bo.getPropertyByNameRuntime(fldName);
            if (this.isEntry(fld)) {
                if (!(fld instanceof LinkPropertyInfo)) continue;
                relation = ImplUtils.getRTRelation(this.bo, (LinkPropertyInfo)fld);
                childBO = relation.getChildObject(this.bo);
                keys = childBO.getLogicalKeyPropertiesRuntime();
                if (keys != null) {
                    logicKeys = new String[keys.size()];
                    for (int k = 0; k < logicKeys.length; ++k) {
                        logicKeys[k] = keys.get(k).getName();
                    }
                } else {
                    logicKeys = null;
                }
                newVal = this.newValue.get(fldName);
                childList = valueAccess.getInfoList();
                infoList = new ArrayList();
                if (childList != null) {
                    for (int j = 0; j < childList.size(); ++j) {
                        child = (Map)childList.get(j);
                        index = (Integer)child.get(INDEX);
                        childVal = ((AbstractObjectCollection)newVal).getObject(index.intValue());
                        logicKey = InfoAccess.getLogicKey(logicKeys, childVal);
                        Map childInfoMap = (Map)child.get(INFOMAP);
                        InfoAccess childInfoAccess = new InfoAccess(childBO, childVal, childInfoMap);
                        childInfoMap = childInfoAccess.transFormForMap();
                        HashMap<String, Object> infoMap = new HashMap<String, Object>();
                        infoMap.put(ID, logicKey);
                        infoMap.put(INFOMAP, childInfoMap);
                        infoList.add(infoMap);
                    }
                }
                map2 = new HashMap();
                map2.put(FIELD, fldName);
                map2.put(INFOLIST, infoList);
                updateList.add(map2);
                continue;
            }
            map = new HashMap();
            map.put(FIELD, fldName);
            map.put(OLDVAL, valueAccess.getOldVal());
            map.put(NEWVAL, valueAccess.getNewVal());
            updateList.add(map);
        }
        newMap.put(UPDATELIST, updateList);
        return newMap;
    }

    public Boolean getChangeFlag() {
        return this.changeFlag;
    }
}

