/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ORMContext;
import com.kingdee.bos.dao.ormapping.impl.BatchConnection;
import com.kingdee.bos.dao.ormapping.impl.IObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.ORMContextImpl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractObjectHandler
implements IObjectHandler {
    protected final Context ctx;
    protected final Connection cn;
    protected final SolutionInfo solution;
    private boolean entryPermCol = false;
    private static ThreadLocal<ORMContextImpl> local = new ThreadLocal();

    protected AbstractObjectHandler(Context ctx, Connection cn, SolutionInfo solution) {
        this.ctx = ctx;
        this.cn = cn;
        this.solution = solution;
        this.initContext();
    }

    @Override
    public final void close() throws SQLException {
        if (this.cn instanceof BatchConnection) {
            ((BatchConnection)this.cn).closeStatements();
        }
        this.destroyContext();
    }

    private ORMContextImpl initContext() {
        ORMContextImpl context = new ORMContextImpl();
        local.set(context);
        return context;
    }

    private void destroyContext() {
        local.set(null);
    }

    static ORMContext getContext() {
        ORMContextImpl context = local.get();
        if (context == null) {
            context = new ORMContextImpl();
            local.set(context);
        }
        return context;
    }

    public boolean isEntryPermCol() {
        return this.entryPermCol;
    }

    public void setEntryPermCol(boolean entryPermCol) {
        this.entryPermCol = entryPermCol;
    }
}

