/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ORMContext;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.AbstractObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorCache;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ImplUtils {
    private static final Logger logger = Logger.getLogger(ImplUtils.class);

    private ImplUtils() {
    }

    public static Object convToBOSUuid(Object compareValue) {
        if (compareValue == null) {
            return null;
        }
        if (compareValue instanceof BOSUuid) {
            return (BOSUuid)compareValue;
        }
        if (compareValue instanceof Set) {
            LinkedHashSet<BOSUuid> set = new LinkedHashSet<BOSUuid>();
            for (Object item : (Set)compareValue) {
                if (item == null) continue;
                if (item instanceof BOSUuid) {
                    set.add((BOSUuid)item);
                    continue;
                }
                if (!BOSUuid.isValid((String)item.toString(), (boolean)true)) continue;
                set.add(BOSUuid.read((String)item.toString()));
            }
            return set;
        }
        return BOSUuid.read((String)compareValue.toString());
    }

    public static FilterInfo createFilter(IObjectValue filterData) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        Enumeration e = filterData.keys();
        while (e.hasMoreElements()) {
            String field = (String)e.nextElement();
            items.add(new FilterItemInfo(field, filterData.get(field)));
        }
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterInfo createFilter(EntityObjectInfo entity, IObjectPK pk) throws InvalidDAOMetaDataException {
        if (pk == null) {
            throw new IllegalArgumentException("pk can  not be null");
        }
        FilterInfo filter = new FilterInfo();
        String[] keyFields = pk.getKeyFields();
        PropertyCollection keyProperties = entity.getLogicalKeyPropertiesRuntime();
        int keyCount = keyProperties.size();
        if (keyCount != keyFields.length) {
            throw new InvalidDAOMetaDataException("PK fields count is not equal to the entity logicalkeys count");
        }
        if (keyFields.length == 1) {
            String propName = keyProperties.get(0).getName();
            if (StringUtils.isEmpty((String)keyFields[0])) {
                filter.appendFilterItem(propName, pk.getKeyValue(propName));
                return filter;
            } else {
                if (!keyFields[0].equalsIgnoreCase(propName)) throw new InvalidDAOMetaDataException("PK field name conflicted with logicalkey name.logicalkey name:" + propName);
                filter.appendFilterItem(keyFields[0], pk.getKeyValue(keyFields[0]));
            }
            return filter;
        } else {
            for (int i = 0; i < keyFields.length; ++i) {
                String keyField = keyFields[i];
                boolean findProperty = false;
                for (int j = 0; j < keyCount; ++j) {
                    String keyProperty = keyProperties.get(j).getName();
                    if (!keyField.equalsIgnoreCase(keyProperty)) continue;
                    filter.appendFilterItem(keyField, pk.getKeyValue(keyField));
                    findProperty = true;
                }
                if (findProperty) continue;
                throw new InvalidDAOMetaDataException("PK field name conflicted with logicalkey name. PK field name:" + keyField);
            }
        }
        return filter;
    }

    static IObjectPK[] getPkList(ResultSet rset, EntityObjectInfo bo, List<PropertyInfo> fieldList, Map<String, String> aliasMapping, Context ctx) throws SQLException, InvalidDAOMetaDataException {
        ArrayList<IObjectPK> rtnList = new ArrayList<IObjectPK>();
        ArrayList<String> keyPropList = new ArrayList<String>(1);
        PropertyCollection props = bo.getLogicalKeyPropertiesRuntime();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            keyPropList.add(props.get(i).getName());
        }
        FieldTypes fieldTypes = null;
        if (rset.next()) {
            if (fieldTypes == null) {
                fieldTypes = new FieldTypes(rset, fieldList, aliasMapping, keyPropList);
            }
            do {
                IObjectPK pk = Utils.createObjectPK(bo);
                boolean flag = false;
                for (int i = 0; i < fieldTypes.fieldCount; ++i) {
                    Object sqlData;
                    if (!fieldTypes.isKeyPropField[i]) continue;
                    String colName = rset.getMetaData().getColumnName(i + 1);
                    boolean isObjectNull = false;
                    Object data = sqlData = ImplUtils.getDataFromDr(fieldTypes.dataTypeList[i], rset, i + 1);
                    PropertyInfo fld = fieldList.get(i);
                    if (fld instanceof OwnPropertyInfo) {
                        if (DataType.BOSUUID.equals((Object)((OwnPropertyInfo)fld).getDataType())) {
                            if (StringUtils.isEmpty((String)((String)sqlData))) {
                                isObjectNull = true;
                            } else {
                                try {
                                    data = BOSUuid.read((String)sqlData.toString());
                                }
                                catch (Exception e) {
                                    throw new InvalidDAOMetaDataException("Invalid BOSUuid.  colName:" + colName + ", value:" + data, (Throwable)e);
                                }
                            }
                        } else {
                            DataType dataType = ((OwnPropertyInfo)fld).getDataType();
                            data = ImplUtils.ConvertSQLTypeData2Java(dataType, sqlData, (OwnPropertyInfo)fld);
                        }
                        pk.setKeyValue(fld.getName(), data);
                        flag = true;
                    }
                    if (!isObjectNull) continue;
                }
                if (!flag) continue;
                rtnList.add(pk);
            } while (rset.next());
        }
        return rtnList.toArray(new IObjectPK[rtnList.size()]);
    }

    static IObjectCollection fillObjectValue(ResultSet rset, EntityObjectInfo bo, List<PropertyInfo> fieldList, Map<String, String> aliasMapping, Context ctx) throws SQLException, InvalidDAOMetaDataException {
        IObjectCollection dpc = Utils.newObjectCollectionInstance(bo);
        HashMap<String, IObjectValue> objectValueCache = new HashMap<String, IObjectValue>();
        FieldTypes fieldTypes = null;
        if (rset.next()) {
            if (fieldTypes == null) {
                fieldTypes = new FieldTypes(rset, fieldList, aliasMapping, null);
            }
            String[] path = new String[fieldTypes.maxNameLength - 1];
            IObjectValue[] linkValues = new IObjectValue[fieldTypes.maxNameLength];
            int rsetSize = 0;
            int collection4LogSize = 0;
            int collectionSize = 0;
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            if (manager != null) {
                collectionSize = manager.getCriticalCollection();
                collection4LogSize = manager.getCriticalCollection4Log();
            }
            do {
                boolean f;
                for (int i = 0; i < path.length; ++i) {
                    path[i] = null;
                }
                linkValues[0] = Utils.newObjectValueInstance(bo);
                boolean isObjectNull = false;
                boolean isCancelAdd = false;
                for (int i = 0; i < fieldTypes.fieldCount; ++i) {
                    String[] names;
                    int nameLength;
                    String colName = rset.getMetaData().getColumnName(i + 1);
                    String colPreFix = colName.substring(0, colName.lastIndexOf(46) + 1);
                    isObjectNull = false;
                    Object sqlData = null;
                    try {
                        sqlData = ImplUtils.getDataFromDr(fieldTypes.dataTypeList[i], rset, i + 1);
                    }
                    catch (SQLException e) {
                        logger.error((Object)("getDataFromDr error. colName=" + colName), (Throwable)e);
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error((Object)("getDataFromDr error. colName=" + colName), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    Object data = sqlData;
                    PropertyInfo fld = fieldList.get(i);
                    if (fld instanceof OwnPropertyInfo) {
                        if (DataType.BOSUUID.equals((Object)((OwnPropertyInfo)fld).getDataType())) {
                            if (sqlData == null || StringUtils.isEmpty((String)((String)sqlData))) {
                                isObjectNull = true;
                            } else {
                                try {
                                    data = BOSUuid.read((String)sqlData.toString());
                                }
                                catch (Exception e) {
                                    throw new InvalidDAOMetaDataException("Invalid BOSUuid.  colName:" + colName + ", value:" + data, (Throwable)e);
                                }
                            }
                        } else {
                            DataType dataType = ((OwnPropertyInfo)fld).getDataType();
                            data = ImplUtils.ConvertSQLTypeData2Java(dataType, sqlData, (OwnPropertyInfo)fld);
                        }
                    }
                    if ((nameLength = (names = (String[])fieldTypes.nameList[i]).length) == 1 && isObjectNull) {
                        PropertyInfo fld1 = fieldList.get(i);
                        if (fld1.getMappingField() == null || !bo.isLogicalKey(fld1)) continue;
                        isCancelAdd = true;
                        break;
                    }
                    EntityObjectInfo chdbo = bo;
                    for (int j = 0; j < nameLength - 1; ++j) {
                        PropertyInfo prop = chdbo.getPropertyByNameRuntime(names[j]);
                        if (prop == null) continue;
                        if (prop instanceof LinkPropertyInfo) {
                            RelationshipInfo relation = ImplUtils.getRTRelation(chdbo, (LinkPropertyInfo)prop);
                            chdbo = relation.getChildObject(chdbo);
                        }
                        if (names[j].equalsIgnoreCase(path[j])) continue;
                        for (int propIdx = j; propIdx < path.length; ++propIdx) {
                            path[propIdx] = null;
                        }
                        IObjectValue childData = null;
                        PropertyCollection logicalKeys = chdbo.getLogicalKeyPropertiesRuntime();
                        String keyID = null;
                        boolean hasBOSUuid = false;
                        int size = logicalKeys.size();
                        for (int k = 0; k < size; ++k) {
                            PropertyInfo keyProp = logicalKeys.get(k);
                            if (!(keyProp instanceof OwnPropertyInfo) || !((OwnPropertyInfo)keyProp).getDataType().equals((Object)DataType.BOSUUID)) continue;
                            hasBOSUuid = true;
                            String keyName = colPreFix + keyProp.getName();
                            if (colName.equalsIgnoreCase(keyName)) {
                                if (data != null) {
                                    keyID = data.toString();
                                }
                            } else {
                                keyID = rset.getString(keyName);
                            }
                            if (StringUtils.isEmpty(keyID)) break;
                            try {
                                data = BOSUuid.read((String)keyID);
                            }
                            catch (Exception e) {
                                throw new InvalidDAOMetaDataException("Invalid BOSUuid.  colName:" + colName + ",  keyName:" + keyName + ",  value:" + keyID, (Throwable)e);
                            }
                            EntityObjectInfo subEntity = chdbo;
                            if (subEntity == null) break;
                            IObjectValue cacheValue = (IObjectValue)objectValueCache.get(keyID);
                            if (cacheValue != null && subEntity.getObjectValueClassRuntime().equals(cacheValue.getClass().getName()) && !subEntity.isNeedHistory()) {
                                childData = cacheValue;
                                break;
                            }
                            childData = Utils.newObjectValueInstance(subEntity);
                            objectValueCache.put(keyID, childData);
                            break;
                        }
                        if (!(childData != null || StringUtils.isEmpty(keyID) && hasBOSUuid)) {
                            childData = Utils.newObjectValueInstance(chdbo);
                        }
                        linkValues[j + 1] = childData;
                        if (linkValues[j] != null) {
                            Object linkOv = linkValues[j].get(names[j]);
                            if (linkOv != null && linkOv instanceof IObjectValue) {
                                linkValues[j + 1] = (IObjectValue)linkOv;
                            }
                            linkValues[j].put(names[j], (Object)linkValues[j + 1]);
                        }
                        path[j] = names[j];
                    }
                    if (linkValues[nameLength - 1] == null) continue;
                    linkValues[nameLength - 1].put(names[nameLength - 1], data);
                }
                if (!isCancelAdd && !(f = dpc.addObject(linkValues[0]))) {
                    logger.info((Object)(" oh! no! add objectvalue to objectcollection failed! objectvalue:" + linkValues[0]));
                }
                if (collectionSize == 0 || ++rsetSize <= collectionSize) continue;
                try {
                    throw new FetchedTooMuchRowsException(rsetSize);
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            } while (rset.next());
            if (collection4LogSize != 0 && rsetSize > collection4LogSize) {
                try {
                    throw new FetchedTooMuchRowsException(rsetSize);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                }
            }
        }
        return dpc;
    }

    public static Object getDataFromDr(int dataType, ResultSet rset, int index) throws SQLException {
        Object data = null;
        try {
            switch (dataType) {
                case 1: 
                case 12: {
                    data = rset.getString(index);
                    break;
                }
                case -7: {
                    boolean b = rset.getInt(index) == 1;
                    data = b;
                    break;
                }
                case 4: {
                    data = rset.getInt(index);
                    break;
                }
                case 3: {
                    data = rset.getBigDecimal(index);
                    break;
                }
                case 91: {
                    data = rset.getDate(index);
                    break;
                }
                case 92: {
                    data = rset.getTime(index);
                    break;
                }
                case 93: {
                    data = rset.getTimestamp(index);
                    break;
                }
                case -5: {
                    data = rset.getLong(index);
                    break;
                }
                case 2: {
                    data = rset.getBigDecimal(index);
                    break;
                }
                case 6: 
                case 8: {
                    data = rset.getDouble(index);
                    break;
                }
                case 2004: {
                    InputStream in = rset.getBinaryStream(index);
                    if (in == null) {
                        return data;
                    }
                    int blockSize = 1024;
                    byte[] block = new byte[1024];
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    int len = -1;
                    do {
                        try {
                            len = in.read(block);
                        }
                        catch (IOException e1) {
                            throw new SQLException(e1.getMessage());
                        }
                        if (len <= 0) continue;
                        byteOut.write(block, 0, len);
                    } while (len == 1024);
                    data = byteOut.toByteArray();
                    break;
                }
                case 2005: {
                    data = rset.getString(index);
                }
            }
            return data;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static boolean isInhereitedEntity(EntityObjectInfo boParent, EntityObjectInfo boChild) {
        for (EntityObjectInfo boTemp = boChild; boTemp != null; boTemp = boTemp.getBaseEntity()) {
            if (boParent != boTemp) continue;
            return true;
        }
        return false;
    }

    public static String getOperator(SqlExpr expr, String rightIdentify) {
        int oper = ImplUtils.findOperator(expr, rightIdentify);
        return oper == 7 ? " AND " : " OR ";
    }

    private static int findOperator(SqlExpr expr, String rightIdentify) {
        int operator = 7;
        if (expr != null && expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            SqlExpr left = binaryOpExpr.left;
            SqlExpr right = binaryOpExpr.right;
            if (right instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)right).value.equals(rightIdentify)) {
                    operator = binaryOpExpr.operator;
                } else if (left instanceof SqlBinaryOpExpr) {
                    operator = ImplUtils.findOperator(left, rightIdentify);
                }
            } else if (left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr leftBinaryOpExpr = (SqlBinaryOpExpr)left;
                operator = ImplUtils.findOperator((SqlExpr)leftBinaryOpExpr, rightIdentify);
            } else if (right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr rightBinaryOpExpr = (SqlBinaryOpExpr)right;
                operator = ImplUtils.findOperator((SqlExpr)rightBinaryOpExpr, rightIdentify);
            }
        }
        return operator;
    }

    public static boolean isMainObjRefCrossTable(EntityObjectInfo clientBO, EntityObjectInfo supplierBO, LinkPropertyInfo fld, CrossTableInfo crossTable) throws InvalidDAOMetaDataException {
        return ImplUtils.isMainObjRefCrossTable(clientBO, supplierBO, fld.getRelationship(), crossTable);
    }

    public static boolean isMainObjRefCrossTable(EntityObjectInfo clientBO, EntityObjectInfo supplierBO, RelationshipInfo relation, CrossTableInfo crossTable) throws InvalidDAOMetaDataException {
        DataTableInfo clientTable = clientBO.getTable();
        DataTableInfo supplierTable = supplierBO.getTable();
        AbstractTableInfo clientRefTab = crossTable.getClientTableMap().getRefTable();
        AbstractTableInfo suppRefTab = crossTable.getSupplierTableMap().getRefTable();
        if (clientTable == clientRefTab && supplierTable == suppRefTab) {
            return true;
        }
        if (supplierTable == clientRefTab && clientTable == suppRefTab) {
            return false;
        }
        throw new InvalidDAOMetaDataException("crossTable conflicted with relationship. relationship:" + relation.getName() + " corssTable:" + crossTable.getName());
    }

    public static void processEntryFilter(BOSObjectType bosType, EntityViewInfo view, Context ctx) throws SQLException, BOSException {
        EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        ImplUtils.processEntryFilter(bo, view, ctx);
    }

    public static void processEntryFilter(EntityObjectInfo bo, EntityViewInfo view, Context ctx) throws SQLException, BOSException {
        SolutionInfo solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        ImplUtils.processEntryFilter(bo, view, ctx, solution);
    }

    private static void processEntryFilter(EntityObjectInfo bo, EntityViewInfo view, Context ctx, SolutionInfo solution) throws SQLException, BOSException {
        int n = view.getEntryFilters().size();
        for (int i = 0; i < n; ++i) {
            FilterInfo entryFilter = view.getEntryFilters().get(i);
            EntryFilterType type = entryFilter.getEntryFilterType();
            FilterItemCollection items = entryFilter.getFilterItems();
            if (items.size() == 0 || !EntryFilterType.ENTRYALLWHERE.equals((Object)type) && !EntryFilterType.ENTRYANYWHERE.equals((Object)type)) {
                if (items.size() <= 0) continue;
                String s = entryFilter.toSql();
                FilterInfo filter = null;
                try {
                    filter = new FilterInfo(s);
                }
                catch (ParserException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                if (view.getFilter() != null) {
                    view.getFilter().mergeFilter(filter, "AND");
                    continue;
                }
                view.setFilter(filter);
                continue;
            }
            PropertyInfo prop = bo.getPropertyByNameRuntime(entryFilter.getEntryName());
            if (prop == null || !(prop instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)prop);
            EntityObjectInfo childBO = relation.getChildObject(bo);
            PropertyInfo parentProp = relation.getParentProperty(bo);
            String childFieldName = relation.getChildProperty(bo).getMappingField().getName();
            EntityViewInfo childView = new EntityViewInfo();
            FilterInfo childFilter = new FilterInfo();
            int k = items.size();
            for (int j = 0; j < k; ++j) {
                childFilter.getFilterItems().add(items.get(j));
            }
            childFilter.setMaskString(entryFilter.getMaskString());
            childView.setFilter(childFilter);
            EntityAccess ea = EntityAccess.getInstance(childBO, solution, childView, ctx);
            ea.setFilterFormat(childView.getFilter().getMaskString());
            String childTmpSQL = new SQLGeneratorCache(ea, ctx).selectSQLWithTrueValue(childBO, true, null, false);
            String alias = "";
            if (ea.getAliasMapping() != null && ea.getAliasMapping().containsValue(childBO.getName())) {
                for (Map.Entry<String, String> entry : ea.getAliasMapping().entrySet()) {
                    if (!entry.getValue().equalsIgnoreCase(childBO.getName())) continue;
                    alias = entry.getKey();
                    break;
                }
            }
            String childSQL = alias.length() > 0 ? "SELECT " + alias + "." + childFieldName + " " : "SELECT " + childFieldName + " ";
            childSQL = childSQL.toUpperCase();
            StringBuffer fromSQL = new StringBuffer();
            StringBuffer whereSQL = new StringBuffer();
            ImplUtils.getPharseSQL(childTmpSQL, fromSQL, whereSQL);
            String childSQLFrom = fromSQL.toString();
            String childSQLWhere = whereSQL.toString();
            childSQL = childSQL + childSQLFrom;
            FilterItemInfo filterItem = null;
            if (EntryFilterType.ENTRYALLWHERE.equals((Object)type)) {
                childSQL = childSQL + "WHERE ";
                childSQL = childSQL + " NOT (" + childSQLWhere + ")";
                filterItem = new FilterItemInfo(parentProp.getName(), (Object)childSQL, CompareType.NOTINNER);
            } else if (EntryFilterType.ENTRYANYWHERE.equals((Object)type)) {
                childSQL = childSQL + "WHERE ";
                childSQL = childSQL + childSQLWhere;
                filterItem = new FilterItemInfo(parentProp.getName(), (Object)childSQL, CompareType.INNER);
            }
            if (filterItem == null) continue;
            FilterInfo otherFilter = new FilterInfo();
            otherFilter.getFilterItems().add(filterItem);
            if (view.getFilter() != null) {
                view.getFilter().mergeFilter(otherFilter, "AND");
                continue;
            }
            view.setFilter(otherFilter);
        }
    }

    private static void getPharseSQL(String sql, StringBuffer fromSQL, StringBuffer whereSQL) {
        try {
            SelectParser parser2 = new SelectParser(sql.toString());
            SqlSelect select = (SqlSelect)parser2.select();
            QuerySQLFormater formater = new QuerySQLFormater(fromSQL);
            formater.getFromCause(select);
            formater.setBuffer(whereSQL);
            formater.getConditionCause(select);
        }
        catch (Exception e) {
            fromSQL.append(sql.substring(sql.toUpperCase().indexOf("FROM"), sql.toUpperCase().indexOf("WHERE")));
            whereSQL.append(sql.substring(sql.toUpperCase().indexOf("WHERE") + 5));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPKValue(EntityObjectInfo entity, IObjectPK pk, IObjectValue value) throws DataAccessException {
        assert (pk != null);
        String[] keyFields = pk.getKeyFields();
        PropertyCollection keyProperties = entity.getLogicalKeyPropertiesRuntime();
        if (keyProperties.size() != keyFields.length) {
            throw new InvalidDAOMetaDataException("PK fields count is not equal to the entity logicalkeys count");
        }
        if (keyFields.length == 1) {
            String propName = keyProperties.get(0).getName();
            if (StringUtils.isEmpty((String)keyFields[0])) {
                value.put(propName, pk.getKeyValue(propName));
                return;
            } else {
                if (!keyFields[0].equalsIgnoreCase(propName)) throw new InvalidDAOMetaDataException("PK field name conflicted with logicalkey name.logicalkey name:" + propName);
                value.put(keyFields[0], pk.getKeyValue(keyFields[0]));
            }
            return;
        } else {
            for (int i = 0; i < keyFields.length; ++i) {
                String keyField = keyFields[i];
                boolean findProperty = false;
                for (int j = 0; j < keyProperties.size(); ++j) {
                    String keyProperty = keyProperties.get(j).getName();
                    if (!keyField.equalsIgnoreCase(keyProperty)) continue;
                    value.put(keyField, pk.getKeyValue(keyField));
                    findProperty = true;
                }
                if (findProperty) continue;
                throw new InvalidDAOMetaDataException("PK field name conflicted with logicalkey name. PK field name:" + keyField);
            }
        }
    }

    public static IObjectValue cloneIObjectValue(EntityObjectInfo bo, IObjectValue oldData) throws InvalidDAOMetaDataException {
        IObjectValue returnData = Utils.newObjectValueInstance(bo);
        Enumeration keys = oldData.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            returnData.put(key, oldData.get(key));
        }
        return returnData;
    }

    public static boolean isLogicalKeyChanged(EntityObjectInfo entity, IObjectValue oldValue, IObjectValue newValue) {
        PropertyCollection keys = entity.getLogicalKeyPropertiesRuntime();
        if (keys != null) {
            String[] ss = new String[keys.size()];
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = keys.get(i).getName();
            }
            return ImplUtils.isKeyChanged(ss, oldValue, newValue);
        }
        return false;
    }

    public static boolean isKeyChanged(String[] keys, IObjectValue oldValue, IObjectValue newValue) {
        if (oldValue == null && newValue != null) {
            return true;
        }
        if (oldValue != null && newValue == null) {
            return true;
        }
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (keys == null) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            String keyName = keys[i];
            Object oldKey = oldValue.get(keyName);
            Object newKey = newValue.get(keyName);
            if (oldKey == null && newKey != null) {
                return true;
            }
            if (oldKey != null && newKey == null) {
                return true;
            }
            if (oldKey == null || newKey == null || oldKey.toString().equalsIgnoreCase(newKey.toString())) continue;
            return true;
        }
        return false;
    }

    public static void setBaseObjectPKData(EntityObjectInfo bo, IObjectValue dataValue) {
        EntityObjectInfo basebo = bo.getBaseEntity();
        if (basebo != null && !basebo.isAbstract()) {
            PropertyCollection keys = bo.getLogicalKeyPropertiesRuntime();
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo key = keys.get(i);
                if (!dataValue.containsKey(key.getName())) continue;
                PropertyInfo basekey = basebo.getLogicalKeyPropertiesRuntime().get(i);
                dataValue.put(basekey.getName(), dataValue.get(key.getName()));
            }
            ImplUtils.setBaseObjectPKData(basebo, dataValue);
        }
    }

    public static ORMContext getContext() {
        return AbstractObjectHandler.getContext();
    }

    public static RelationshipInfo getRTRelation(EntityObjectInfo bo, LinkPropertyInfo prop) {
        String key = ImplUtils.getRTRelaKeyName(bo, prop);
        RelationshipInfo relation = ImplUtils.getContext().getRTRelationship(key);
        if (relation == null) {
            relation = prop.getRelationship();
        }
        return relation;
    }

    public static String getRTRelaKeyName(EntityObjectInfo bo, LinkPropertyInfo prop) {
        if (bo == null || prop == null) {
            throw new IllegalArgumentException("bo=" + bo + ",  prop=" + prop);
        }
        String key = bo.getFullName() + "_" + prop.getName();
        return key;
    }

    public static Object ConvertSQLTypeData2Java(DataType dataType, Object data, OwnPropertyInfo fld) {
        Object objData = data;
        if (dataType == null || data == null) {
            objData = data;
        } else if (DataType.STRING.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToString((Object)data);
        } else if (DataType.BOOLEAN.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBBoolean((Object)data);
        } else if (DataType.FLOAT.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToFFloat((Object)data);
        } else if (DataType.INTEGER.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToInteger((Object)data);
        } else if (DataType.LONG.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToLLong((Object)data);
        } else if (DataType.DECIMAL.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBigDecimal((Object)data);
        } else if (DataType.DOUBLE.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToDDouble((Object)data);
        } else if (DataType.TIME.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToTime((Object)data);
        } else if (DataType.TIMESTAMP.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToTimestamp((Object)data);
        } else if (DataType.UUID.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToUuid((Object)data);
        } else if (DataType.BOSUUID.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBOSUuid((Object)data);
        } else if (DataType.BYTE.equals((Object)dataType)) {
            objData = Byte.valueOf(String.valueOf(TypeConversionUtils.objToByte((Object)data)));
        } else if (DataType.BYTEARRAY.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBytes((Object)data);
        } else if (DataType.CHAR.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToString((Object)data);
        } else if (DataType.DATE.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToDate((Object)data);
        } else if (DataType.ENUM.equals((Object)dataType)) {
            if (fld.isConfigured()) {
                BizEnumInfo enumInfo = fld.getEnumType(MDHostType.RUNTIME);
                BizEnumValueType type = enumInfo.getDataType();
                if (type == BizEnumValueType.INTEGER) {
                    objData = Integer.valueOf(String.valueOf(TypeConversionUtils.objToInt((Object)data)));
                } else if (type == BizEnumValueType.STRING) {
                    objData = TypeConversionUtils.objToString((Object)data);
                } else if (type == BizEnumValueType.FLOAT) {
                    objData = Float.valueOf(String.valueOf(TypeConversionUtils.objToFloat((Object)data)));
                } else if (type == BizEnumValueType.LONG) {
                    objData = Long.valueOf(String.valueOf(TypeConversionUtils.objToLong((Object)data)));
                } else if (type == BizEnumValueType.DOUBLE) {
                    objData = Double.valueOf(String.valueOf(TypeConversionUtils.objToDouble((Object)data)));
                }
            }
        } else if (DataType.OBJECTVALUE.equals((Object)dataType)) {
            objData = data;
        } else if (DataType.SHORT.equals((Object)dataType)) {
            objData = Short.valueOf(String.valueOf(TypeConversionUtils.objToShort((Object)data)));
        }
        return objData;
    }

    public static final String buildPermissionServiceKey(BOSObjectType type, String methodName, Object[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(type);
        sb.append(methodName);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null || params[i] instanceof Context) continue;
                sb.append(params[i].getClass().getName());
            }
        }
        return sb.toString();
    }

    public static PropertyInfo getPropertyByName(EntityObjectInfo bo, String name) throws InvalidDAOMetaDataException {
        String[] nameList = StringUtils.fastSplit((String)name, (String)".");
        if (nameList == null || nameList.length < 1) {
            throw new InvalidDAOMetaDataException("selector item is null");
        }
        EntityObjectInfo tmpBo = bo;
        PropertyInfo fld = null;
        for (int i = 0; i < nameList.length; ++i) {
            if (fld != null) {
                if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(tmpBo, (LinkPropertyInfo)fld);
                    tmpBo = relation.getChildObject(tmpBo);
                } else {
                    throw new InvalidDAOMetaDataException("can't get field of this name:" + name + " object:" + bo.getName());
                }
            }
            fld = tmpBo.getPropertyByNameRuntime(nameList[i]);
        }
        return fld;
    }

    private static class FieldTypes {
        final int fieldCount;
        final int maxNameLength;
        final int[] dataTypeList;
        final Object[] nameList;
        final boolean[] isKeyPropField;

        FieldTypes(ResultSet rset, List<PropertyInfo> fieldList, Map<String, String> aliasMapping, List<String> keyFields) throws SQLException {
            this.fieldCount = fieldList.size();
            this.dataTypeList = new int[this.fieldCount];
            this.nameList = new Object[this.fieldCount];
            this.isKeyPropField = new boolean[this.fieldCount];
            int maxLen = 0;
            for (int i = 0; i < this.fieldCount; ++i) {
                ExtendedFieldInfo extFld;
                String[] names;
                String fieldName = FieldTypes.getFieldFullBOName(rset.getMetaData().getColumnName(i + 1), aliasMapping);
                this.nameList[i] = names = StringUtils.split((String)fieldName, (int)46);
                if (maxLen < names.length) {
                    maxLen = names.length;
                }
                this.isKeyPropField[i] = FieldTypes.contains(fieldName, keyFields) || FieldTypes.contains(names[0], keyFields);
                this.dataTypeList[i] = 1;
                PropertyInfo fld = fieldList.get(i);
                ColumnInfo col = fld.getMappingField();
                if (col == null && (extFld = fld.getExtendedField()) != null) {
                    col = extFld.getExtendedColumn();
                }
                if (col == null) continue;
                this.dataTypeList[i] = col.getSQLType();
            }
            this.maxNameLength = maxLen;
        }

        private static boolean contains(String field, List<String> fields) {
            if (fields == null) {
                return false;
            }
            for (String f : fields) {
                if (!field.equalsIgnoreCase(f)) continue;
                return true;
            }
            return false;
        }

        private static String getFieldFullBOName(String fldAliasName, Map<String, String> aliasMapping) {
            int index = fldAliasName.lastIndexOf(".");
            if (index == -1) {
                return fldAliasName;
            }
            String tableAlias = fldAliasName.substring(0, index).toLowerCase();
            String fldA = aliasMapping.get(tableAlias);
            if (fldA != null) {
                return fldA + fldAliasName.substring(index).toLowerCase();
            }
            return fldAliasName;
        }
    }
}

