/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.PropertyConstriantValidator;
import com.kingdee.bos.dao.ormapping.PropertyValidateFailedException;
import com.kingdee.bos.dao.ormapping.impl.AbstractObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.bos.metadata.rule.formula.FormulaExecutor;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;

abstract class ObjectHandler
extends AbstractObjectHandler {
    protected ObjectHandler(Context ctx, Connection cn, SolutionInfo solution) {
        super(ctx, cn, solution);
    }

    protected EntityAccess getEntityAccess(EntityObjectInfo bo, EntityViewInfo view) throws SQLException, InvalidDAOMetaDataException {
        EntityAccess ea = EntityAccess.getInstance(bo, this.solution, view, this.ctx);
        ea.setEntryPermCol(this.isEntryPermCol());
        return ea;
    }

    protected EntityAccess getEntityAccess(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector) throws SQLException, InvalidDAOMetaDataException {
        EntityAccess ea = EntityAccess.getInstance(this.cn, bo, this.solution, filter, sorter, selector, this.ctx);
        ea.setEntryPermCol(this.isEntryPermCol());
        return ea;
    }

    protected EntityAccess getEntityAccess(EntityObjectInfo bo, String tableName) {
        EntityAccess ea = new EntityAccess(bo, this.cn, tableName, this.solution, this.ctx);
        ea.setEntryPermCol(this.isEntryPermCol());
        return ea;
    }

    protected void calculateFormula(PropertyInfo fld, ColumnInfo col, EntityObjectInfo bo, IObjectValue saveData) throws FormulaExecuteException {
        if (!(fld instanceof OwnPropertyInfo)) {
            return;
        }
        String fldName = fld.getName();
        String formula = ((OwnPropertyInfo)fld).getFormula();
        if (formula != null && formula.trim().length() != 0 && !fld.equals((Object)bo.getSequenceProperty())) {
            Object dataValue = FormulaExecutor.executeProperty((Context)this.ctx, (String)formula, (IObjectValue)saveData, (String)fldName);
            saveData.put(fldName, dataValue);
        }
        if (saveData.containsKey(fldName)) {
            saveData.put(fldName, this.perpareParms((OwnPropertyInfo)fld, col, saveData.get(fldName)));
        }
    }

    private Object perpareParms(OwnPropertyInfo fld, ColumnInfo col, Object value) {
        assert (col != null && fld != null && fld.getDataType() != null);
        if (value == null) {
            return null;
        }
        if (fld.getDataType().isDateTime()) {
            return TypeConversionUtils.objToTimestamp((Object)value);
        }
        if (col != null && SQLType.NUMERIC.equals((Object)col.getTypeName())) {
            BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
            return decimal.setScale(col.getScale(), 4);
        }
        if (col != null && (SQLType.NCHAR.equals((Object)col.getTypeName()) || SQLType.NVARCHAR.equals((Object)col.getTypeName()))) {
            return "~9^Nz" + value;
        }
        return value;
    }

    protected void checkConstriant(PropertyInfo prop, Object value) throws SQLException {
        if (!(prop instanceof OwnPropertyInfo)) {
            return;
        }
        if (((OwnPropertyInfo)prop).getConstraint() == null) {
            return;
        }
        try {
            PropertyConstriantValidator.validateProperty((Context)this.ctx, (OwnPropertyInfo)((OwnPropertyInfo)prop), (Object)value);
        }
        catch (PropertyValidateFailedException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected static final String localedName(String name, LanguageInfo lang) {
        return name + "_" + lang.getPostfix();
    }

    protected static final Object addUnicodeTag(Object oldValue, ColumnInfo col) {
        SQLType sqlType;
        if (oldValue != null && col != null && (SQLType.NCHAR.equals((Object)(sqlType = col.getTypeName())) || SQLType.NVARCHAR.equals((Object)sqlType)) && oldValue instanceof String && ((String)oldValue).length() > 0) {
            return "~9^Nz" + oldValue;
        }
        return oldValue;
    }
}

